/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.connectivity;

import java.io.File;
import java.io.IOException;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionFactory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.enablement.ingres.internal.connectivity.IngresJDBCConnection;

public class IngresConnectionFactory
implements IConnectionFactory {
    public static final String INGRES_TRACE_LOG = "ingres.jdbc.trace.log";
    public static final String INGRES_TRACE_DRV = "ingres.jdbc.trace.drv";

    public IConnection createConnection(IConnectionProfile profile) {
        if (System.getProperty(INGRES_TRACE_LOG) == null) {
            try {
                File log = File.createTempFile("ingres_jdbc_trace_", ".log");
                log.deleteOnExit();
                System.setProperty(INGRES_TRACE_LOG, log.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (System.getProperty(INGRES_TRACE_DRV) == null) {
            System.setProperty(INGRES_TRACE_DRV, "1");
        }
        IngresJDBCConnection connection = new IngresJDBCConnection(profile, this.getClass());
        connection.open();
        return connection;
    }

    public IConnection createConnection(IConnectionProfile profile, String uid, String pwd) {
        return this.createConnection(profile);
    }
}

