/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.view;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.net4j.util.ReflectUtil;

public abstract class AbstractCDOViewProvider
implements CDOViewProvider.CDOViewProvider2 {
    private String regex;
    private int priority = 500;
    @ReflectUtil.ExcludeFromDump
    private transient Pattern pattern;

    public AbstractCDOViewProvider() {
    }

    public AbstractCDOViewProvider(String regex, int priority) {
        this.regex = regex;
        this.priority = priority;
    }

    public AbstractCDOViewProvider(String regex) {
        this(regex, 500);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getRegex() {
        return this.regex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegex(String regex) {
        String string = regex;
        synchronized (string) {
            this.regex = regex;
            this.pattern = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchesRegex(URI uri) {
        String string = this.regex;
        synchronized (string) {
            if (this.pattern == null) {
                this.pattern = Pattern.compile(this.regex);
            }
        }
        Matcher matcher = this.pattern.matcher(uri.toString());
        return matcher.matches();
    }

    public URI getResourceURI(CDOView view, String path) {
        return null;
    }

    public final URI getViewURI(CDOView view) {
        return this.getResourceURI(view, null);
    }

    public URI getViewURI(URI uri) {
        return URI.createHierarchicalURI((String)uri.scheme(), (String)uri.authority(), (String)uri.device(), null, null);
    }

    public String getPath(URI uri) {
        return uri.path();
    }

    public String toString() {
        return "CDOViewProviderDescriptor[" + this.getPriority() + " --> " + this.getRegex() + "]";
    }
}

