/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.lang.reflect.Field;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;

public class ProblemReferenceBinding
extends ReferenceBinding {
    ReferenceBinding closestMatch;
    private int problemReason;
    public ITeamAnchor anchor;

    public ProblemReferenceBinding(char[][] compoundName, ReferenceBinding closestMatch, int problemReason) {
        this.compoundName = compoundName;
        this.closestMatch = closestMatch;
        if (closestMatch != null) {
            this.sourceName = closestMatch.sourceName;
        }
        this.problemReason = problemReason;
    }

    @Override
    public TypeBinding clone(TypeBinding enclosingType) {
        throw new IllegalStateException();
    }

    @Override
    public TypeBinding closestMatch() {
        return this.closestMatch;
    }

    public ProblemReferenceBinding(char[] name, int problemReason, ReferenceBinding closestMatch) {
        this(new char[][]{name}, closestMatch, problemReason);
    }

    public ProblemReferenceBinding(ITeamAnchor anchor, char[] typeName, ReferenceBinding closestMatch, int problemReason) {
        this(new char[][]{typeName}, closestMatch, problemReason);
        this.anchor = anchor;
    }

    public ReferenceBinding closestReferenceMatch() {
        return this.closestMatch;
    }

    @Override
    public boolean hasTypeBit(int bit) {
        if (this.closestMatch != null) {
            return this.closestMatch.hasTypeBit(bit);
        }
        return false;
    }

    @Override
    public int problemId() {
        return this.problemReason;
    }

    public static String problemReasonString(int problemReason) {
        try {
            Class<ProblemReasons> reasons = ProblemReasons.class;
            String simpleName = reasons.getName();
            int lastDot = simpleName.lastIndexOf(46);
            if (lastDot >= 0) {
                simpleName = simpleName.substring(lastDot + 1);
            }
            Field[] fields = reasons.getFields();
            int i = 0;
            int length = fields.length;
            while (i < length) {
                Field field = fields[i];
                if (field.getType().equals(Integer.TYPE) && field.getInt(reasons) == problemReason) {
                    return String.valueOf(simpleName) + '.' + field.getName();
                }
                ++i;
            }
        }
        catch (IllegalAccessException illegalAccessException) {}
        return "unknown";
    }

    @Override
    public void setTypeAnnotations(AnnotationBinding[] annotations, boolean evalNullAnnotations) {
    }

    @Override
    public char[] readableName() {
        if (this.closestMatch != null && !(this.closestMatch instanceof MissingTypeBinding)) {
            return this.closestMatch.readableName();
        }
        return super.readableName();
    }

    @Override
    public boolean isCompatibleWith(TypeBinding otherType) {
        if (this.closestMatch != null && otherType instanceof ProblemReferenceBinding) {
            ReferenceBinding otherClosestMatch = ((ProblemReferenceBinding)otherType).closestMatch;
            if (otherClosestMatch != null) {
                return this.closestMatch.isCompatibleWith(otherClosestMatch);
            }
            return this.closestMatch.isCompatibleWith(otherType);
        }
        return super.isCompatibleWith(otherType);
    }

    @Override
    public char[] shortReadableName() {
        return super.readableName();
    }

    @Override
    public char[] sourceName() {
        return this.compoundName.length == 0 ? null : this.compoundName[this.compoundName.length - 1];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("ProblemType:[compoundName=");
        buffer.append(this.compoundName == null ? "<null>" : new String(CharOperation.concatWith(this.compoundName, '.')));
        buffer.append("][problemID=").append(ProblemReferenceBinding.problemReasonString(this.problemReason));
        buffer.append("][closestMatch=");
        buffer.append(this.closestMatch == null ? "<null>" : this.closestMatch.toString());
        buffer.append("]");
        return buffer.toString();
    }
}

