/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.indexer;

import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;

public class GenericSignatures {
    private static final char[][] EMPTY_CHAR_ARRAY_ARRAY = new char[0][];

    public static SignatureWrapper getGenericSignature(IBinaryMethod next) {
        char[] signature = next.getGenericSignature();
        if (signature == null) {
            signature = next.getMethodDescriptor();
        }
        return new SignatureWrapper(signature);
    }

    public static SignatureWrapper getGenericSignature(IBinaryType binaryType) {
        char[] genericSignature;
        char[][] interfaces = binaryType.getInterfaceNames();
        if (interfaces == null) {
            interfaces = EMPTY_CHAR_ARRAY_ARRAY;
        }
        if ((genericSignature = binaryType.getGenericSignature()) == null) {
            int startIndex = binaryType.getSuperclassName() != null ? 3 : 0;
            char[][] toCatenate = new char[startIndex + interfaces.length * 3][];
            char[] prefix = new char[]{'L'};
            char[] suffix = new char[]{';'};
            if (binaryType.getSuperclassName() != null) {
                toCatenate[0] = prefix;
                toCatenate[1] = binaryType.getSuperclassName();
                toCatenate[2] = suffix;
            }
            int idx = 0;
            while (idx < interfaces.length) {
                int catIndex = startIndex + idx * 3;
                toCatenate[catIndex] = prefix;
                toCatenate[catIndex + 1] = interfaces[idx];
                toCatenate[catIndex + 2] = suffix;
                ++idx;
            }
            genericSignature = CharArrayUtils.concat(toCatenate);
        }
        SignatureWrapper signatureWrapper = new SignatureWrapper(genericSignature);
        return signatureWrapper;
    }

    static SignatureWrapper getGenericSignatureFor(IBinaryField nextField) {
        char[] signature = nextField.getGenericSignature();
        if (signature == null) {
            signature = nextField.getTypeName();
        }
        return new SignatureWrapper(signature);
    }
}

