/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.converter.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jwt.converter.PluginProperties;
import org.eclipse.jwt.converter.internal.exception.UnsupportedVersionException;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.drivers.emf4atl.AtlEMFModelHandler;
import org.eclipse.m2m.atl.drivers.emf4atl.EMFModelLoader;
import org.eclipse.m2m.atl.engine.vm.AtlLauncher;
import org.eclipse.m2m.atl.engine.vm.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATLTransformation {
    private String jwtNameMetamodelFile = "JWT";
    private static ATLTransformation instance = null;
    private static final String metamodelPath = "/org/eclipse/jwt/converter/internal/resources/metamodels/";
    private static AtlEMFModelHandler modelHandler;
    private static EMFModelLoader modelLoaderSource;
    private static EMFModelLoader modelLoaderTarget;
    private ASMEMFModel jwtSourceMetamodel;
    private ASMEMFModel jwtTargetMetamodel;
    private ASMEMFModel jwtTargetViewMetamodel;
    private URL JWT2JWT_TransfoResource;
    private String targetVersionString = "";
    private int targetVersion = -1;
    private int sourceVersion = -1;

    public static ATLTransformation getInstance() {
        if (instance == null) {
            instance = new ATLTransformation();
        }
        return instance;
    }

    private void createResources(Map<String, Object> models) throws UnsupportedVersionException, IOException {
        if (this.sourceVersion == -1) {
            throw new UnsupportedVersionException("No source version specified!");
        }
        InputStream sourceMetaModelStream = this.getClass().getResourceAsStream(metamodelPath + this.jwtNameMetamodelFile + this.sourceVersion + ".ecore");
        InputStream targetMetaModelStream = this.getClass().getResourceAsStream(metamodelPath + this.jwtNameMetamodelFile + this.targetVersion + ".ecore");
        InputStream targetMetaModelViewStream = this.getClass().getResourceAsStream(metamodelPath + this.jwtNameMetamodelFile + "View" + this.targetVersion + ".ecore");
        this.jwtSourceMetamodel = (ASMEMFModel)modelLoaderSource.loadModel("jwtSource", modelLoaderSource.getMOF(), sourceMetaModelStream);
        this.jwtTargetMetamodel = (ASMEMFModel)modelLoaderTarget.loadModel("jwtTarget", modelLoaderTarget.getMOF(), targetMetaModelStream);
        modelLoaderTarget.getResourceSet().getResource(URI.createURI((String)"jwtTarget"), false).setURI(URI.createURI((String)(String.valueOf(this.jwtNameMetamodelFile) + this.targetVersion + ".ecore")));
        modelLoaderTarget.getResourceSet().getResource(URI.createURI((String)(String.valueOf(this.jwtNameMetamodelFile) + this.targetVersion + ".ecore")), false).setURI(URI.createURI((String)"jwtTarget"));
        models.put("jwtSource", this.jwtSourceMetamodel);
        models.put("jwtTarget", this.jwtTargetMetamodel);
        if (targetMetaModelViewStream != null) {
            this.jwtTargetViewMetamodel = (ASMEMFModel)modelLoaderTarget.loadModel("jwtTargetView", modelLoaderTarget.getMOF(), targetMetaModelViewStream);
            models.put("jwtTargetView", this.jwtTargetViewMetamodel);
        }
    }

    public void jwt2jwt(String inFilePath, String outFilePath) throws IOException, UnsupportedVersionException {
        modelHandler = (AtlEMFModelHandler)AtlModelHandler.getDefault((String)"EMF");
        modelLoaderSource = (EMFModelLoader)modelHandler.createModelLoader();
        modelLoaderTarget = (EMFModelLoader)modelHandler.createModelLoader();
        HashMap<String, Object> models = new HashMap<String, Object>();
        this.createResources(models);
        ASMEMFModel jwtInputModel = (ASMEMFModel)modelLoaderSource.loadModel("IN", (ASMModel)this.jwtSourceMetamodel, (InputStream)new FileInputStream(inFilePath));
        ASMEMFModel jwtOutputModel = (ASMEMFModel)modelLoaderTarget.newModel("OUT", URI.createFileURI((String)outFilePath).toString(), (ASMModel)this.jwtTargetMetamodel);
        models.put("IN", jwtInputModel);
        models.put("OUT", jwtOutputModel);
        ASMEMFModel jwtOutputViewModel = null;
        if (this.jwtTargetViewMetamodel != null) {
            jwtOutputViewModel = (ASMEMFModel)modelLoaderTarget.newModel("VIEW", URI.createFileURI((String)outFilePath).toFileString(), (ASMModel)this.jwtTargetViewMetamodel);
            models.put("VIEW", jwtOutputViewModel);
            jwtOutputViewModel.setCheckSameModel(false);
        }
        this.JWT2JWT_TransfoResource = ATLTransformation.class.getResource("resources/transformations/JWT" + this.sourceVersion + "toJWT" + this.targetVersion + ".asm");
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("allowInterModelReferences", "true");
        jwtInputModel.setCheckSameModel(false);
        jwtOutputModel.setCheckSameModel(false);
        AtlLauncher.getDefault().launch(this.JWT2JWT_TransfoResource, Collections.EMPTY_MAP, models, Collections.EMPTY_MAP, Collections.EMPTY_LIST, options);
        modelLoaderTarget.save((ASMModel)jwtOutputModel, new File(outFilePath).toURI().toURL().toString());
        if (jwtOutputViewModel != null) {
            modelLoaderTarget.save((ASMModel)jwtOutputViewModel, new File(String.valueOf(outFilePath) + "_view").toURI().toURL().toString());
        }
        this.dispose(models);
    }

    public void justUpdateFileTag(String inFilePath, String outFilePath) throws Exception {
        String fileContents = "";
        FileInputStream inputStream = null;
        try {
            try {
                String line;
                inputStream = new FileInputStream(inFilePath);
                StringBuilder sb = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                fileContents = sb.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception(PluginProperties.getString("convert_couldnotupdate_message"), e);
            }
        }
        finally {
            inputStream.close();
        }
        int versionStringBegin = fileContents.indexOf("fileversion=\"") + "fileversion=\"".length();
        int versionStringEnd = fileContents.indexOf("\"", versionStringBegin);
        String newFileContents = "";
        newFileContents = String.valueOf(newFileContents) + fileContents.subSequence(0, versionStringBegin);
        newFileContents = String.valueOf(newFileContents) + this.targetVersionString;
        newFileContents = String.valueOf(newFileContents) + fileContents.subSequence(versionStringEnd, fileContents.length() - 1);
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(outFilePath));
            out.write(newFileContents);
            out.close();
        }
        catch (Exception e) {
            throw new Exception(PluginProperties.getString("convert_couldnotupdate_message"), e);
        }
    }

    public void setSourceVersion(int version) {
        this.sourceVersion = version;
    }

    public void setTargetVersion(int version, String versionS) {
        this.targetVersion = version;
        this.targetVersionString = versionS;
    }

    private void dispose(Map<String, Object> models) {
        models.clear();
    }
}

