/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.collection;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.net4j.util.collection.HistoryElement;
import org.eclipse.net4j.util.collection.IHistory;
import org.eclipse.net4j.util.collection.IHistoryChangeEvent;
import org.eclipse.net4j.util.collection.IHistoryElement;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.Notifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History<T>
extends Notifier
implements IHistory<T> {
    protected List<IHistoryElement<T>> elements = new ArrayList<IHistoryElement<T>>(0);
    private boolean loaded;

    public List<IHistoryElement<T>> getElements() {
        this.lazyLoad();
        return this.elements;
    }

    public void setElements(List<IHistoryElement<T>> newElements) {
        if (newElements == null) {
            newElements = new ArrayList<IHistoryElement<T>>(0);
        }
        if (!this.elements.equals(newElements)) {
            this.elements = newElements;
            this.changed();
        }
    }

    @Override
    public boolean isEmpty() {
        this.lazyLoad();
        return this.elements.isEmpty();
    }

    @Override
    public int size() {
        this.lazyLoad();
        return this.elements.size();
    }

    @Override
    public int indexOf(T data) {
        this.lazyLoad();
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.get(i).getData().equals(data)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public IHistoryElement<T> get(int index) {
        this.lazyLoad();
        return this.elements.get(index);
    }

    @Override
    public boolean add(T data) {
        boolean changed;
        this.lazyLoad();
        int index = this.indexOf(data);
        IHistoryElement<T> element = index != -1 ? this.elements.remove(index) : this.createElement(data);
        this.elements.add(0, element);
        boolean bl = changed = index != 0;
        if (changed) {
            this.changed();
        }
        return changed;
    }

    @Override
    public IHistoryElement<T> remove(int index) {
        this.lazyLoad();
        IHistoryElement<T> element = this.elements.remove(index);
        if (element != null) {
            this.changed();
        }
        return element;
    }

    @Override
    public boolean clear() {
        if (this.elements.isEmpty()) {
            return false;
        }
        this.elements.clear();
        this.changed();
        return true;
    }

    @Override
    public T getMostRecent() {
        this.lazyLoad();
        if (this.isEmpty()) {
            return null;
        }
        return this.elements.get(0).getData();
    }

    @Override
    public <D> D[] getData(D[] a) {
        this.lazyLoad();
        int size = this.elements.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        int i = 0;
        while (i < size) {
            a[i] = this.elements.get(i).getData();
            ++i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public IHistoryElement<T>[] toArray() {
        this.lazyLoad();
        return this.elements.toArray(new IHistoryElement[this.elements.size()]);
    }

    @Override
    public Iterator<IHistoryElement<T>> iterator() {
        this.lazyLoad();
        return this.elements.iterator();
    }

    protected IHistoryElement<T> createElement(T data) {
        HistoryElement<T> result = new HistoryElement<T>(this, data);
        return result;
    }

    protected void load() {
    }

    protected void save() {
    }

    protected final void changed() {
        this.save();
        this.fireChangedEvent();
    }

    private void lazyLoad() {
        if (!this.loaded) {
            this.loaded = true;
            this.load();
        }
    }

    private void fireChangedEvent() {
        IListener[] listeners = this.getListeners();
        if (listeners != null) {
            this.fireEvent(new IHistoryChangeEvent(){

                @Override
                public IHistory<?> getSource() {
                    return History.this;
                }
            }, listeners);
        }
    }
}

