/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.validation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.ui.editor.validation.IControlValidator;
import org.eclipse.pde.internal.ui.editor.validation.IValidatorMessageHandler;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IMessageManager;

public abstract class AbstractControlValidator
implements IControlValidator,
IValidatorMessageHandler {
    public static final Object F_DEFAULT_MESSAGE_KEY = "k";
    private boolean fEnabled;
    private IManagedForm fManagedForm;
    private Control fControl;
    private String fMessagePrefix;
    private boolean fIsValid;
    private IProject fProject;

    public AbstractControlValidator(IManagedForm managedForm, Control control, IProject project) {
        this.fProject = project;
        this.fManagedForm = managedForm;
        this.fControl = control;
        this.fMessagePrefix = null;
        this.fEnabled = this.autoEnable();
        this.reset();
    }

    protected boolean autoEnable() {
        boolean isBinaryProject = WorkspaceModelManager.isBinaryProject((IProject)this.fProject);
        return !isBinaryProject && this.fControl.getEnabled() && !this.fControl.isDisposed();
    }

    @Override
    public boolean getEnabled() {
        return this.fEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled == this.fEnabled) {
            return;
        }
        this.fEnabled = enabled;
        if (this.fEnabled) {
            this.validate();
        } else {
            this.reset();
        }
    }

    @Override
    public boolean validate() {
        if (!this.fEnabled) {
            return this.fIsValid;
        }
        this.fIsValid = this.validateControl();
        if (this.fIsValid) {
            this.fManagedForm.getMessageManager().removeMessages(this.fControl);
        }
        return this.fIsValid;
    }

    protected abstract boolean validateControl();

    @Override
    public void addMessage(Object key, String messageText, int messageType) {
        if (this.fMessagePrefix != null) {
            messageText = String.valueOf(this.fMessagePrefix) + ' ' + messageText;
        }
        this.fManagedForm.getMessageManager().addMessage(key, messageText, null, messageType, this.fControl);
    }

    @Override
    public void addMessage(String messageText, int messageType) {
        if (this.fMessagePrefix != null) {
            messageText = String.valueOf(this.fMessagePrefix) + ' ' + messageText;
        }
        this.fManagedForm.getMessageManager().addMessage(F_DEFAULT_MESSAGE_KEY, messageText, null, messageType, this.fControl);
    }

    public static int getMessageType(IStatus status) {
        int severity = status.getSeverity();
        if (severity == 0) {
            return 0;
        }
        if (severity == 4) {
            return 3;
        }
        if (severity == 2) {
            return 2;
        }
        if (severity == 1) {
            return 1;
        }
        return 0;
    }

    public static int getMessageType(IProject project, String compilerFlagId) {
        int severity = CompilerFlags.getFlag((IProject)project, (String)compilerFlagId);
        if (severity == 2) {
            return 0;
        }
        if (severity == 0) {
            return 3;
        }
        return 2;
    }

    @Override
    public void removeMessage(Object key) {
        this.fManagedForm.getMessageManager().removeMessage(key, this.fControl);
    }

    @Override
    public void setMessagePrefix(String prefix) {
        this.fMessagePrefix = prefix;
    }

    @Override
    public String getMessagePrefix() {
        return this.fMessagePrefix;
    }

    @Override
    public IManagedForm getManagedForm() {
        return this.fManagedForm;
    }

    @Override
    public IMessageManager getMessageManager() {
        return this.fManagedForm.getMessageManager();
    }

    @Override
    public void setRefresh(boolean refresh) {
        this.getMessageManager().setAutoUpdate(refresh);
    }

    @Override
    public Control getControl() {
        return this.fControl;
    }

    @Override
    public boolean isValid() {
        return this.fIsValid;
    }

    @Override
    public void reset() {
        this.fIsValid = true;
        this.fManagedForm.getMessageManager().removeMessages(this.fControl);
    }
}

