/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.launch;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.IType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.PHPToolkitUtil;
import org.eclipse.php.internal.debug.ui.launching.PHPExecutableLaunchTab;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.launch.PHPUnitLaunchUtils;
import org.eclipse.php.phpunit.ui.launch.PHPUnitLaunchConfigurationTab;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class PHPUnitLaunchShortcut
implements ILaunchShortcut {
    private static final Set<String> CONFIG_FILES = new HashSet<String>(Arrays.asList("phpunit.xml", "phpunit.xml.dist"));
    boolean launchInBackground = true;
    PHPExecutableLaunchTab phpTab;
    PHPUnitLaunchConfigurationTab tab;

    public void setLaunchInBackground(boolean launchInBackground) {
        this.launchInBackground = launchInBackground;
    }

    public void launch(IEditorPart editor, String mode) {
        IModelElement element = ((PHPStructuredEditor)editor).getModelElement();
        ISourceReference highlighted = ((PHPStructuredEditor)editor).computeHighlightRangeSourceReference();
        if (highlighted instanceof IMethod) {
            String selectionText;
            String elementName = ((IMethod)highlighted).getElementName();
            StructuredTextViewer textViewer = ((PHPStructuredEditor)editor).getTextViewer();
            StyledText textWidget = textViewer == null ? null : textViewer.getTextWidget();
            String string = selectionText = textWidget == null ? null : textWidget.getSelectionText();
            if (selectionText != null && selectionText.equals(elementName) && selectionText.startsWith("test")) {
                element = ((IMethod)highlighted).getPrimaryElement();
            }
        }
        this.launch(element, mode);
    }

    public void launch(ISelection selection, String mode) {
        Object element = null;
        if (selection instanceof IStructuredSelection) {
            element = ((IStructuredSelection)selection).getFirstElement();
        }
        this.launch(element, mode);
    }

    private void launch(Object selectedElement, String mode) {
        try {
            String configName;
            String osString = null;
            if (selectedElement instanceof IModelElement) {
                IModelElement me = (IModelElement)selectedElement;
                osString = me.getPath().toOSString();
                configName = me.getElementName();
            } else if (selectedElement instanceof IResource) {
                IResource resource = (IResource)selectedElement;
                osString = resource.getFullPath().toOSString();
                configName = resource.getName();
            } else {
                configName = PHPUnitMessages.PHPUnitLaunchShortcut_New_Configuration;
            }
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(launchManager.getLaunchConfigurationType("org.eclipse.php.phpunit.PHPUnitLaunchConfigurationType"));
            ILaunchConfiguration config = null;
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
            int n = launchConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launchConfig = iLaunchConfigurationArray[n2];
                if (launchConfig.getAttribute("org.eclipse.php.phpunit.elementPath", "").equals(osString)) {
                    config = launchConfig;
                    break;
                }
                ++n2;
            }
            if (config == null) {
                ILaunchConfigurationWorkingCopy wconfig = launchManager.getLaunchConfigurationType("org.eclipse.php.phpunit.PHPUnitLaunchConfigurationType").newInstance(null, launchManager.generateLaunchConfigurationName(configName));
                this.getPHPExeTab().setDefaults(wconfig);
                this.getTab().setDefaults(wconfig);
                wconfig.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", this.launchInBackground);
                wconfig.setAttribute("org.eclipse.php.phpunit.elementPath", osString);
                this.generateConfigFromSelection(selectedElement, wconfig);
                wconfig.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", false);
                config = wconfig.doSave();
            }
            DebugUITools.launch(config, (String)mode);
        }
        catch (CoreException e) {
            PHPUnitPlugin.log(e);
        }
    }

    private void generateConfigFromSelection(Object selectedElement, ILaunchConfigurationWorkingCopy config) {
        IProject project = null;
        if (selectedElement instanceof IResource) {
            IResource resource = (IResource)selectedElement;
            config.setAttribute("org.eclipse.php.phpunit.project", resource.getProject().getName());
            config.setAttribute("org.eclipse.php.phpunit.file", resource.getFullPath().toString());
            if (resource.getType() == 1) {
                IFile file = (IFile)selectedElement;
                if (PHPToolkitUtil.hasPHPExtention((IFile)file)) {
                    selectedElement = DLTKCore.create((IFile)file);
                } else if (CONFIG_FILES.contains(file.getName())) {
                    config.setAttribute("org.eclipse.php.phpunit.phpunitPath", file.getProjectRelativePath().toString());
                    selectedElement = DLTKCore.create((IResource)file.getParent());
                }
            } else {
                config.setAttribute("org.eclipse.php.phpunit.container", resource.getProjectRelativePath().toString());
                config.setAttribute("org.eclipse.php.phpunit.is_suite", true);
            }
            project = resource.getProject();
        }
        if (selectedElement instanceof IModelElement) {
            if (selectedElement instanceof IMethod) {
                IMethod method = (IMethod)selectedElement;
                config.setAttribute("ATTRIBUTE_METHOD_NAME", method.getElementName());
                selectedElement = method.getDeclaringType();
            }
            if (selectedElement instanceof IType) {
                IType type = (IType)selectedElement;
                config.setAttribute("org.eclipse.php.phpunit.is_suite", false);
                config.setAttribute("org.eclipse.php.phpunit.project", type.getScriptProject().getProject().getName());
                config.setAttribute("org.eclipse.php.phpunit.class", type.getElementName());
                config.setAttribute("org.eclipse.php.phpunit.file", type.getSourceModule().getResource().getProjectRelativePath().toString());
                project = type.getScriptProject().getProject();
            } else {
                IModelElement fContainerElement = (IModelElement)selectedElement;
                project = fContainerElement.getScriptProject().getProject();
                config.setAttribute("org.eclipse.php.phpunit.is_suite", true);
                config.setAttribute("org.eclipse.php.phpunit.project", project.getName());
                config.setAttribute("org.eclipse.php.phpunit.container", this.getProjectRelativePath(fContainerElement));
            }
        }
        String typeName = this.getContainerType(selectedElement);
        config.setAttribute("ZEND_PHPUNIT_TESTS_CONTAINER_TYPE", typeName);
        if (PHPUnitLaunchUtils.findComposerExecutionFile(project) != null) {
            config.setAttribute("org.eclipse.php.phpunit.runType", "COMPOSER_EXECUTION_TYPE");
        }
    }

    private String getContainerType(Object container) {
        if (container instanceof IScriptProject || container instanceof IProject) {
            return "SCRIPT_PROJECT";
        }
        if (container instanceof IScriptFolder || container instanceof IProjectFragment || container instanceof IFolder) {
            return "SCRIPT_FOLDER";
        }
        if (container instanceof ISourceModule) {
            return "SCRIPT_SOURCE";
        }
        return null;
    }

    private String getProjectRelativePath(Object element) {
        if (element instanceof IScriptFolder) {
            return ((IScriptFolder)element).getResource().getProjectRelativePath().toString();
        }
        if (element instanceof IProjectFragment) {
            return ((IProjectFragment)element).getResource().getProjectRelativePath().toString();
        }
        if (element instanceof IScriptProject) {
            return ((IScriptProject)element).getPath().toString();
        }
        if (element instanceof ISourceModule) {
            return ((ISourceModule)element).getResource().getProjectRelativePath().toString();
        }
        return "";
    }

    public PHPUnitLaunchConfigurationTab getTab() {
        if (this.tab == null) {
            this.tab = new PHPUnitLaunchConfigurationTab();
        }
        return this.tab;
    }

    public PHPExecutableLaunchTab getPHPExeTab() {
        if (this.phpTab == null) {
            this.phpTab = new PHPExecutableLaunchTab();
        }
        return this.phpTab;
    }
}

