/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class LayoutPanelParser
implements ElementParser {
    private static final String ERR_PAIRING = "In %s %s, 'left' must be paired with 'right' or 'width'.";
    private static final String ERR_TOO_MANY = "In %s %s, there are too many %s constraints.";
    private static final String LAYER = "layer";

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        for (XMLElement layerElem : elem.consumeChildElements()) {
            if (!this.isElementType(elem, layerElem, LAYER)) {
                writer.die("In %s, only <%s:%s> children are allowed.", new Object[]{elem, elem.getPrefix(), LAYER});
            }
            String childFieldName = writer.parseElementToField(layerElem.consumeSingleChildElement());
            writer.addStatement("%1$s.add(%2$s);", new Object[]{fieldName, childFieldName});
            String left = layerElem.consumeLengthAttribute("left");
            String right = layerElem.consumeLengthAttribute("right");
            String width = layerElem.consumeLengthAttribute("width");
            if (left != null) {
                if (right != null) {
                    if (width != null) {
                        writer.die(ERR_TOO_MANY, new Object[]{elem, layerElem, "horizontal"});
                    }
                    this.generateConstraint(fieldName, childFieldName, "LeftRight", left, right, writer);
                } else if (width != null) {
                    this.generateConstraint(fieldName, childFieldName, "LeftWidth", left, width, writer);
                } else {
                    writer.die(ERR_PAIRING, new Object[]{elem, layerElem, "left", "right", "width"});
                }
            } else if (right != null) {
                if (width != null) {
                    this.generateConstraint(fieldName, childFieldName, "RightWidth", right, width, writer);
                } else {
                    writer.die(ERR_PAIRING, new Object[]{elem, layerElem, "right", "left", "width"});
                }
            }
            String top = layerElem.consumeLengthAttribute("top");
            String bottom = layerElem.consumeLengthAttribute("bottom");
            String height = layerElem.consumeLengthAttribute("height");
            if (top != null) {
                if (bottom != null) {
                    if (height != null) {
                        writer.die(ERR_TOO_MANY, new Object[]{elem, layerElem, "vertical"});
                    }
                    this.generateConstraint(fieldName, childFieldName, "TopBottom", top, bottom, writer);
                    continue;
                }
                if (height != null) {
                    this.generateConstraint(fieldName, childFieldName, "TopHeight", top, height, writer);
                    continue;
                }
                writer.die(ERR_PAIRING, new Object[]{elem, layerElem, "top", "bottom", "height"});
                continue;
            }
            if (bottom == null) continue;
            if (height != null) {
                this.generateConstraint(fieldName, childFieldName, "BottomHeight", bottom, height, writer);
                continue;
            }
            writer.die(ERR_PAIRING, new Object[]{elem, layerElem, "bottom", "top", "height"});
        }
    }

    private void generateConstraint(String panelName, String widgetName, String constraintName, String first, String second, UiBinderWriter writer) {
        writer.addStatement("%s.setWidget%s(%s, %s, %s);", new Object[]{panelName, constraintName, widgetName, first, second});
    }

    private boolean isElementType(XMLElement parent, XMLElement child, String type) {
        return parent.getNamespaceUri().equals(child.getNamespaceUri()) && type.equals(child.getLocalName());
    }
}

