/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.tools.ant.Target;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.internal.core.AntCoreUtil;
import org.eclipse.ant.internal.launching.AntLaunchingUtil;
import org.eclipse.ant.internal.ui.AntUIModelMessages;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.editor.AntEditor;
import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntModel;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.IAntElement;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.ant.internal.ui.model.LocationProvider;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public final class AntUtil {
    public static final String ATTRIBUTE_SEPARATOR = ",";
    public static final char ANT_CLASSPATH_DELIMITER = '*';
    public static final String ANT_HOME_CLASSPATH_PLACEHOLDER = "G";
    public static final String ANT_GLOBAL_USER_CLASSPATH_PLACEHOLDER = "UG";
    private static String fgBrowserId;

    private AntUtil() {
    }

    public static String combineStrings(String[] strings) {
        return AntLaunchingUtil.combineStrings((String[])strings);
    }

    public static String[] getTargetNames(ILaunchConfiguration configuration) throws CoreException {
        return AntLaunchingUtil.getTargetNames((ILaunchConfiguration)configuration);
    }

    public static Map<String, String> getProperties(ILaunchConfiguration configuration) throws CoreException {
        return AntLaunchingUtil.getProperties((ILaunchConfiguration)configuration);
    }

    public static String getAntHome(ILaunchConfiguration configuration) throws CoreException {
        return AntLaunchingUtil.getAntHome((ILaunchConfiguration)configuration);
    }

    public static String[] getPropertyFiles(ILaunchConfiguration configuration) throws CoreException {
        String attribute = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_PROPERTY_FILES", null);
        if (attribute == null) {
            return null;
        }
        String[] propertyFiles = AntUtil.parseString(attribute, ATTRIBUTE_SEPARATOR);
        int i = 0;
        while (i < propertyFiles.length) {
            String propertyFile = propertyFiles[i];
            propertyFiles[i] = propertyFile = AntUtil.expandVariableString(propertyFile, AntUIModelMessages.AntUtil_6);
            ++i;
        }
        return propertyFiles;
    }

    public static AntTargetNode[] getTargets(String path, ILaunchConfiguration config) throws CoreException {
        File buildfile = AntUtil.getBuildFile(path);
        if (buildfile == null) {
            return null;
        }
        URL[] urls = AntUtil.getCustomClasspath(config);
        IAntModel model = AntUtil.getAntModel(buildfile, urls, false, false, false);
        try {
            model.setProperties(AntUtil.getAllProperties(config));
        }
        catch (CoreException coreException) {}
        model.setPropertyFiles(AntUtil.getPropertyFiles(config));
        AntProjectNode project = model.getProjectNode();
        model.dispose();
        return AntUtil.getTargets(project);
    }

    private static Map<String, String> getAllProperties(ILaunchConfiguration config) throws CoreException {
        Map<String, String> configProperties;
        String allArgs = config.getAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", null);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (allArgs != null) {
            ArrayList<String> filtered = new ArrayList<String>();
            Pattern pattern = Pattern.compile("\\$\\{.*_prompt.*\\}");
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            String[] stringArray = ExternalToolsUtil.parseStringIntoList((String)allArgs);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (arg.startsWith("-D") && !pattern.matcher(arg).find()) {
                    filtered.add(manager.performStringSubstitution(arg, false));
                }
                ++n2;
            }
            AntCoreUtil.processMinusDProperties(filtered, properties);
        }
        if ((configProperties = AntUtil.getProperties(config)) != null) {
            for (String name : configProperties.keySet()) {
                if (properties.get(name) != null) continue;
                properties.put(name, configProperties.get(name));
            }
        }
        return properties;
    }

    private static AntTargetNode[] getTargets(AntProjectNode project) {
        if (project == null || !project.hasChildren()) {
            return null;
        }
        ArrayList<IAntElement> targets = new ArrayList<IAntElement>();
        for (IAntElement node : project.getChildNodes()) {
            if (!(node instanceof AntTargetNode)) continue;
            targets.add(node);
        }
        if (targets.isEmpty()) {
            return null;
        }
        return targets.toArray(new AntTargetNode[targets.size()]);
    }

    public static AntTargetNode[] getTargets(String path) {
        Hashtable antTargets;
        Target implicitTarget;
        File buildfile = AntUtil.getBuildFile(path);
        if (buildfile == null) {
            return null;
        }
        IAntModel model = AntUtil.getAntModel(buildfile, null, false, true, true);
        AntProjectNode project = model.getProjectNode();
        if (project == null) {
            model.dispose();
            return null;
        }
        AntTargetNode[] targets = AntUtil.getTargets(project);
        if (targets == null && (implicitTarget = (Target)(antTargets = project.getProject().getTargets()).get("")) != null) {
            AntTargetNode implicitTargetNode = AntTargetNode.newAntTargetNode(implicitTarget);
            project.addChildNode(implicitTargetNode);
            return new AntTargetNode[]{implicitTargetNode};
        }
        return targets;
    }

    public static IAntModel getAntModel(String buildFilePath, boolean needsLexicalResolution, boolean needsPositionResolution, boolean needsTaskResolution) {
        IAntModel model = AntUtil.getAntModel(AntUtil.getBuildFile(buildFilePath), null, needsLexicalResolution, needsPositionResolution, needsTaskResolution);
        return model;
    }

    private static File getBuildFile(String path) {
        File buildFile = new File(path);
        if (!buildFile.isFile() || !buildFile.exists()) {
            return null;
        }
        return buildFile;
    }

    private static IAntModel getAntModel(final File buildFile, URL[] urls, boolean needsLexical, boolean needsPosition, boolean needsTask) {
        if (buildFile == null || !buildFile.exists()) {
            return null;
        }
        IDocument doc = AntUtil.getDocument(buildFile);
        if (doc == null) {
            return null;
        }
        final IFile file = AntUtil.getFileForLocation(buildFile.getAbsolutePath(), null);
        LocationProvider provider = new LocationProvider(null){

            @Override
            public IFile getFile() {
                return file;
            }

            @Override
            public IPath getLocation() {
                if (file == null) {
                    return new Path(buildFile.getAbsolutePath());
                }
                return file.getLocation();
            }
        };
        AntModel model = new AntModel(doc, null, provider, needsLexical, needsPosition, needsTask);
        if (urls != null) {
            model.setClassLoader(AntCorePlugin.getPlugin().getNewClassLoader(urls));
        }
        return model;
    }

    private static IDocument getDocument(File buildFile) {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        Path location = new Path(buildFile.getAbsolutePath());
        boolean connected = false;
        try {
            ITextFileBuffer buffer = manager.getTextFileBuffer((IPath)location, LocationKind.NORMALIZE);
            if (buffer == null) {
                manager.connect((IPath)location, LocationKind.NORMALIZE, (IProgressMonitor)new NullProgressMonitor());
                connected = true;
                buffer = manager.getTextFileBuffer((IPath)location, LocationKind.NORMALIZE);
                if (buffer == null) {
                    return null;
                }
            }
            IDocument iDocument = buffer.getDocument();
            return iDocument;
        }
        catch (CoreException ce) {
            AntUIPlugin.log(ce.getStatus());
            return null;
        }
        finally {
            if (connected) {
                try {
                    manager.disconnect((IPath)location, LocationKind.NORMALIZE, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    AntUIPlugin.log(e.getStatus());
                }
            }
        }
    }

    public static URL[] getCustomClasspath(ILaunchConfiguration config) throws CoreException {
        return AntLaunchingUtil.getCustomClasspath((ILaunchConfiguration)config);
    }

    private static String expandVariableString(String variableString, String invalidMessage) throws CoreException {
        String expandedString = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(variableString);
        if (expandedString == null || expandedString.length() == 0) {
            String msg = MessageFormat.format((String)invalidMessage, (Object[])new Object[]{variableString});
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ant.ui", 0, msg, null));
        }
        return expandedString;
    }

    public static String[] parseRunTargets(String extraAttibuteValue) {
        return AntLaunchingUtil.parseRunTargets((String)extraAttibuteValue);
    }

    public static String[] parseString(String delimString, String delim) {
        return AntLaunchingUtil.parseString((String)delimString, (String)delim);
    }

    public static IFile getFile(String fullPath) {
        return AntLaunchingUtil.getFile((String)fullPath);
    }

    public static IHyperlink getLocationLink(String path, File buildFileParent) {
        int index;
        if ((path = path.trim()).length() == 0) {
            return null;
        }
        if (path.startsWith("file:")) {
            path = path.substring(5, path.length());
        }
        if ((index = path.lastIndexOf(58)) == -1) {
            return null;
        }
        if (index == path.length() - 1) {
            path = path.substring(0, index);
            index = path.lastIndexOf(58);
        }
        String fileName = path.substring(0, index);
        try {
            String lineNumber = path.substring(index + 1);
            int line = Integer.parseInt(lineNumber);
            IFile file = AntUtil.getFileForLocation(fileName, buildFileParent);
            if (file != null) {
                return new FileLink(file, null, -1, -1, line);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return null;
    }

    public static IFile getFileForLocation(String path, File buildFileParent) {
        return AntLaunchingUtil.getFileForLocation((String)path, (File)buildFileParent);
    }

    public static void migrateToNewClasspathFormat(ILaunchConfiguration configuration) throws CoreException {
        AntLaunchingUtil.migrateToNewClasspathFormat((ILaunchConfiguration)configuration);
    }

    private static int getOffset(int line, int column, ITextEditor editor) {
        IDocumentProvider provider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        try {
            provider.connect((Object)input);
        }
        catch (CoreException coreException) {
            return -1;
        }
        try {
            IDocument document = provider.getDocument((Object)input);
            if (document != null) {
                if (column > -1) {
                    int n = document.getLineOffset(line - 1) + column - 1 - 2;
                    return n;
                }
                int n = document.getLineOffset(line - 1);
                return n;
            }
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            provider.disconnect((Object)input);
        }
        return -1;
    }

    public static void openInEditor(IWorkbenchPage page, IEditorDescriptor editorDescriptor, AntElementNode node) {
        IEditorPart editorPart = null;
        IFile fileResource = node.getIFile();
        try {
            editorPart = editorDescriptor == null ? page.openEditor((IEditorInput)new FileEditorInput(fileResource), "org.eclipse.ui.systemExternalEditor") : page.openEditor((IEditorInput)new FileEditorInput(fileResource), editorDescriptor.getId());
        }
        catch (PartInitException e) {
            AntUIPlugin.log(MessageFormat.format((String)AntUIModelMessages.AntUtil_0, (Object[])new Object[]{fileResource.getLocation().toOSString()}), e);
        }
        if (editorPart instanceof AntEditor) {
            AntEditor editor = (AntEditor)editorPart;
            if (node.getImportNode() != null) {
                AntModel model = editor.getAntModel();
                AntProjectNode project = model.getProjectNode();
                if (project == null) {
                    return;
                }
                int[] info = node.getExternalInfo();
                int offset = AntUtil.getOffset(info[0], info[1], (ITextEditor)editor);
                node = project.getNode(offset);
            }
            editor.setSelection(node, true);
        }
    }

    public static void openInEditor(IWorkbenchPage page, AntElementNode node) {
        IEditorDescriptor editorDesc;
        IFile file = node.getIFile();
        try {
            editorDesc = IDE.getEditorDescriptor((IFile)file, (boolean)true, (boolean)true);
        }
        catch (PartInitException partInitException) {
            return;
        }
        AntUtil.openInEditor(page, editorDesc, node);
    }

    public static void openBrowser(String urlString, Shell shell, String errorDialogTitle) {
        shell.getDisplay().syncExec(() -> {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                IWebBrowser browser = support.createBrowser(fgBrowserId);
                fgBrowserId = browser.getId();
                browser.openURL(new URL(urlString));
                return;
            }
            catch (PartInitException e1) {
                AntUIPlugin.log(e1.getStatus());
            }
            catch (MalformedURLException e2) {
                AntUIPlugin.log(e2);
            }
            String platform = SWT.getPlatform();
            boolean succeeded = true;
            if ("motif".equals(platform) || "gtk".equals(platform)) {
                Program program = Program.findProgram((String)"html");
                if (program == null) {
                    program = Program.findProgram((String)"htm");
                }
                if (program != null) {
                    succeeded = program.execute(urlString.toString());
                }
            } else {
                succeeded = Program.launch((String)urlString.toString());
            }
            if (!succeeded) {
                MessageDialog.openInformation((Shell)shell, (String)errorDialogTitle, (String)AntUIModelMessages.AntUtil_1);
            }
        });
    }

    public static boolean isSeparateJREAntBuild(ILaunchConfiguration configuration) {
        return AntLaunchingUtil.isSeparateJREAntBuild((ILaunchConfiguration)configuration);
    }

    public static boolean isKnownAntFile(IResource resource) {
        if (resource != null) {
            IFile file = null;
            file = resource.getType() == 1 ? (IFile)resource : (IFile)resource.getAdapter(IFile.class);
            if (file != null) {
                IContentType fileType = IDE.getContentType((IFile)file);
                if (fileType == null) {
                    return false;
                }
                IContentType antType = Platform.getContentTypeManager().getContentType("org.eclipse.ant.core.antBuildFile");
                if (antType != null) {
                    return fileType.isKindOf(antType);
                }
            }
        }
        return false;
    }

    public static boolean isKnownAntFile(File file) {
        if (file != null && !file.isDirectory()) {
            IContentType antType;
            String filename = file.getName();
            IContentType type = Platform.getContentTypeManager().findContentTypeFor(filename);
            if (type != null && (antType = Platform.getContentTypeManager().getContentType("org.eclipse.ant.core.antBuildFile")) != null) {
                return type.isKindOf(antType);
            }
            String[] names = AntUtil.getKnownBuildfileNames();
            int i = 0;
            while (names != null && i < names.length) {
                if (filename.endsWith(names[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] getKnownBuildfileNames() {
        IPreferenceStore prefs = AntUIPlugin.getDefault().getPreferenceStore();
        String buildFileNames = prefs.getString("ant.findBuildFileNames");
        if (buildFileNames.length() == 0) {
            return null;
        }
        return AntUtil.parseString(buildFileNames, ATTRIBUTE_SEPARATOR);
    }

    public static boolean isKnownBuildfileName(String filename) {
        String[] names = AntUtil.getKnownBuildfileNames();
        int i = 0;
        while (names != null && i < names.length) {
            if (names[i].equalsIgnoreCase(filename)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getKnownBuildFileExtensions() {
        IContentType antType = null;
        String[] result = null;
        try {
            antType = Platform.getContentTypeManager().getContentType("org.eclipse.ant.core.antBuildFile");
            if (antType != null) {
                result = antType.getFileSpecs(8);
            }
        }
        catch (Exception exception) {}
        return result == null ? new String[]{} : result;
    }

    public static String getKnownBuildFileExtensionsAsPattern() {
        String[] extns = AntUtil.getKnownBuildFileExtensions();
        if (extns.length == 0) {
            return "xml";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < extns.length) {
            if (i > 0) {
                sb.append('|');
            }
            sb.append(extns[i]);
            ++i;
        }
        return sb.toString();
    }

    public static boolean isKnownAntFileName(String name) {
        StringBuilder buf = new StringBuilder(".*.(");
        buf.append(AntUtil.getKnownBuildFileExtensionsAsPattern());
        buf.append(")");
        try {
            Pattern p = Pattern.compile(buf.toString());
            return p.matcher(name).matches();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }
}

