/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.ltk.core.refactoring.TextEditBasedChangeGroup;
import org.eclipse.ltk.internal.ui.refactoring.AbstractChangeNode;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElementContentProvider;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElementLabelProvider;
import org.eclipse.ltk.internal.ui.refactoring.ChangeElementTreeViewer;
import org.eclipse.ltk.internal.ui.refactoring.ChangePreviewViewerDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.ExceptionHandler;
import org.eclipse.ltk.internal.ui.refactoring.FinishResult;
import org.eclipse.ltk.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.InternalAPI;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.PreviewNode;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.UIPerformChangeOperation;
import org.eclipse.ltk.internal.ui.refactoring.util.ViewerPane;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class PreviewWizardPage
extends RefactoringWizardPage
implements IPreviewWizardPage {
    private static final String PREVIEW_WIZARD_PAGE_HIDE_DERIVED = "PreviewWizardPage.hide.derived";
    protected static final String PREVIOUS_CHANGE_ID = "org.eclipse.ltk.ui.refactoring.previousChange";
    protected static final String NEXT_CHANGE_ID = "org.eclipse.ltk.ui.refactoring.nextChange";
    protected Change fChange;
    private List<GroupCategory> fActiveGroupCategories;
    private boolean fDerivedFilterActive;
    protected CompositeChange fTreeViewerInputChange;
    private PreviewNode fCurrentSelection;
    private PageBook fPageContainer;
    private Control fStandardPage;
    private Control fNullPage;
    protected Action fFilterDropDownAction;
    protected Action fNextAction;
    protected Action fPreviousAction;
    protected ViewerPane fTreeViewerPane;
    protected ChangeElementTreeViewer fTreeViewer;
    private PageBook fPreviewContainer;
    private ChangePreviewViewerDescriptor fCurrentDescriptor;
    private IChangePreviewViewer fCurrentPreviewViewer;
    private IChangePreviewViewer fNullPreviewer;

    public PreviewWizardPage() {
        super("PreviewPage");
        this.setDescription(RefactoringUIMessages.PreviewWizardPage_description);
    }

    public PreviewWizardPage(boolean wizard) {
        super("PreviewPage", wizard);
        this.setDescription(RefactoringUIMessages.PreviewWizardPage_description);
    }

    @Override
    public void setChange(Change change) {
        if (this.fChange == change) {
            return;
        }
        this.fChange = change;
        if (this.fChange instanceof CompositeChange) {
            this.fTreeViewerInputChange = (CompositeChange)this.fChange;
        } else {
            this.fTreeViewerInputChange = new CompositeChange("Dummy Change");
            this.fTreeViewerInputChange.add(this.fChange);
        }
        this.setTreeViewerInput();
    }

    protected ChangeElementTreeViewer createTreeViewer(Composite parent) {
        return new ChangeElementTreeViewer(parent);
    }

    protected ITreeContentProvider createTreeContentProvider() {
        return new ChangeElementContentProvider();
    }

    protected ILabelProvider createTreeLabelProvider() {
        return new ChangeElementLabelProvider();
    }

    protected ViewerComparator createTreeComparator() {
        return new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                PreviewNode node1 = (PreviewNode)e1;
                PreviewNode node2 = (PreviewNode)e2;
                if (node1.hasDerived()) {
                    if (node2.hasDerived()) {
                        return 0;
                    }
                    return 1;
                }
                if (node2.hasDerived()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    @Override
    protected boolean performFinish() {
        UIPerformChangeOperation operation = new UIPerformChangeOperation(this.getShell().getDisplay(), this.fChange, this.getContainer());
        FinishResult result = this.getRefactoringWizard().internalPerformFinish(InternalAPI.INSTANCE, operation);
        if (result.isException()) {
            return true;
        }
        if (result.isInterrupted()) {
            return false;
        }
        RefactoringStatus fValidationStatus = operation.getValidationStatus();
        if (fValidationStatus != null && fValidationStatus.hasFatalError()) {
            RefactoringWizard wizard = this.getRefactoringWizard();
            MessageDialog.openError((Shell)wizard.getShell(), (String)wizard.getWindowTitle(), (String)Messages.format(RefactoringUIMessages.RefactoringUI_cannot_execute, fValidationStatus.getMessageMatchingSeverity(4)));
            return true;
        }
        return true;
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fPageContainer = new PageBook(parent, 0);
        this.fStandardPage = this.createStandardPreviewPage((Composite)this.fPageContainer);
        this.fNullPage = this.createNullPage((Composite)this.fPageContainer);
        this.setControl((Control)this.fPageContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.refactoring_preview_wizard_page_context");
    }

    private Composite createStandardPreviewPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        SashForm sashForm = new SashForm(result, 512);
        this.fTreeViewerPane = new ViewerPane((Composite)sashForm, 0x800800);
        ToolBarManager tbm = this.fTreeViewerPane.getToolBarManager();
        this.fNextAction = new NextChange();
        tbm.add((IAction)this.fNextAction);
        this.fPreviousAction = new PreviousChange();
        tbm.add((IAction)this.fPreviousAction);
        tbm.add((IContributionItem)new Separator());
        IDialogSettings settings = this.getRefactoringSettings();
        if (settings != null) {
            this.fDerivedFilterActive = settings.getBoolean(PREVIEW_WIZARD_PAGE_HIDE_DERIVED);
        }
        this.fFilterDropDownAction = new FilterDropDownAction();
        tbm.add((IAction)this.fFilterDropDownAction);
        tbm.update(true);
        final ToolBar toolBar = tbm.getControl();
        toolBar.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    e.result = toolBar.getItem(e.childID).getToolTipText();
                }
            }
        });
        this.fTreeViewer = this.createTreeViewer((Composite)this.fTreeViewerPane);
        this.fTreeViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.createTreeLabelProvider());
        this.fTreeViewer.setComparator(this.createTreeComparator());
        this.fTreeViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.fTreeViewer.addCheckStateListener(this.createCheckStateListener());
        this.fTreeViewerPane.setContent(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                super.getName(e);
                e.result = String.valueOf(PreviewWizardPage.this.fTreeViewerPane.getText()) + (e.result != null ? " " + e.result : "");
            }
        });
        this.setHideDerived(this.fDerivedFilterActive);
        this.setTreeViewerInput();
        this.updateTreeViewerPaneTitle();
        this.fPreviewContainer = new PageBook((Composite)sashForm, 0);
        this.fNullPreviewer = new NullPreviewer();
        this.fNullPreviewer.createControl((Composite)this.fPreviewContainer);
        this.fPreviewContainer.showPage(this.fNullPreviewer.getControl());
        this.fCurrentPreviewViewer = this.fNullPreviewer;
        this.fCurrentDescriptor = null;
        sashForm.setWeights(new int[]{33, 67});
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        sashForm.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private Control createNullPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0x1000000);
        label.setText(RefactoringUIMessages.PreviewWizardPage_no_source_code_change);
        label.setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void setVisible(boolean visible) {
        this.fCurrentSelection = null;
        RefactoringWizard refactoringWizard = this.getRefactoringWizard();
        if (this.hasChanges()) {
            this.fPageContainer.showPage(this.fStandardPage);
            AbstractChangeNode treeViewerInput = (AbstractChangeNode)this.fTreeViewer.getInput();
            if (visible && treeViewerInput != null) {
                ViewerComparator comparator;
                ITreeContentProvider provider;
                PreviewNode element;
                IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
                if (selection.isEmpty() && (element = this.getFirstNonCompositeChange(provider = (ITreeContentProvider)this.fTreeViewer.getContentProvider(), comparator = this.fTreeViewer.getComparator(), treeViewerInput)) != null) {
                    Object[] subElements;
                    if (refactoringWizard != null && refactoringWizard.internalGetExpandFirstNode(InternalAPI.INSTANCE) && (subElements = provider.getElements((Object)element)) != null && subElements.length > 0) {
                        comparator.sort((Viewer)this.fTreeViewer, subElements);
                        this.fTreeViewer.expandToLevel(element, 999);
                    }
                    this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)element));
                }
            } else if (!visible) {
                this.fCurrentPreviewViewer.setInput(new ChangePreviewViewerInput((Change)new NullChange()));
            }
            ((FilterDropDownAction)this.fFilterDropDownAction).initialize(this.collectGroupCategories());
            super.setVisible(visible);
            this.fTreeViewer.getControl().setFocus();
        } else {
            this.fPageContainer.showPage(this.fNullPage);
            super.setVisible(visible);
        }
        if (refactoringWizard != null) {
            refactoringWizard.internalSetPreviewShown(InternalAPI.INSTANCE, visible);
        }
    }

    private PreviewNode getFirstNonCompositeChange(ITreeContentProvider provider, ViewerComparator comparator, AbstractChangeNode input) {
        Object focus = input;
        Change change = input.getChange();
        while (change != null && change instanceof CompositeChange) {
            Object[] children = (PreviewNode[])provider.getElements(focus);
            if (children == null || children.length == 0) {
                return null;
            }
            comparator.sort((Viewer)this.fTreeViewer, children);
            focus = children[0];
            Change change2 = change = focus instanceof AbstractChangeNode ? ((AbstractChangeNode)focus).getChange() : null;
        }
        return focus;
    }

    protected void setTreeViewerInput() {
        if (this.fTreeViewer == null) {
            return;
        }
        PreviewNode input = null;
        if (this.fTreeViewerInputChange != null) {
            input = AbstractChangeNode.createNode(null, (Change)this.fTreeViewerInputChange);
        }
        this.fTreeViewer.setInput(input);
    }

    private ICheckStateListener createCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PreviewNode element = (PreviewNode)event.getElement();
                if (this.isChild(PreviewWizardPage.this.fCurrentSelection, element) || this.isChild(element, PreviewWizardPage.this.fCurrentSelection)) {
                    PreviewWizardPage.this.showPreview(PreviewWizardPage.this.fCurrentSelection);
                }
            }

            private boolean isChild(PreviewNode element, PreviewNode child) {
                while (child != null) {
                    if (child == element) {
                        return true;
                    }
                    child = child.getParent();
                }
                return false;
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.size() == 1) {
                    PreviewNode newSelection = (PreviewNode)sel.getFirstElement();
                    if (newSelection != PreviewWizardPage.this.fCurrentSelection) {
                        PreviewWizardPage.this.fCurrentSelection = newSelection;
                        PreviewWizardPage.this.showPreview(newSelection);
                    }
                } else {
                    PreviewWizardPage.this.showPreview(null);
                }
            }
        };
    }

    private void showPreview(PreviewNode element) {
        try {
            if (element == null) {
                this.showNullPreviewer();
            } else {
                ChangePreviewViewerDescriptor descriptor = element.getChangePreviewViewerDescriptor();
                if (this.fCurrentDescriptor != descriptor) {
                    IChangePreviewViewer newViewer;
                    if (descriptor != null) {
                        newViewer = descriptor.createViewer();
                        newViewer.createControl((Composite)this.fPreviewContainer);
                    } else {
                        newViewer = this.fNullPreviewer;
                    }
                    this.fCurrentDescriptor = descriptor;
                    element.feedInput(newViewer, this.fActiveGroupCategories);
                    if (this.fCurrentPreviewViewer != null && this.fCurrentPreviewViewer != this.fNullPreviewer) {
                        this.fCurrentPreviewViewer.getControl().dispose();
                    }
                    this.fCurrentPreviewViewer = newViewer;
                    this.fPreviewContainer.showPage(this.fCurrentPreviewViewer.getControl());
                } else {
                    element.feedInput(this.fCurrentPreviewViewer, this.fActiveGroupCategories);
                }
            }
        }
        catch (CoreException e) {
            this.showNullPreviewer();
            ExceptionHandler.handle(e, this.getShell(), RefactoringUIMessages.PreviewWizardPage_refactoring, RefactoringUIMessages.PreviewWizardPage_Internal_error);
        }
    }

    private void showNullPreviewer() {
        this.fCurrentDescriptor = null;
        this.fCurrentPreviewViewer = this.fNullPreviewer;
        this.fPreviewContainer.showPage(this.fCurrentPreviewViewer.getControl());
    }

    public boolean hasChanges() {
        if (this.fChange == null) {
            return false;
        }
        if (this.fChange instanceof CompositeChange) {
            return this.hasChanges((CompositeChange)this.fChange);
        }
        return true;
    }

    private boolean hasChanges(CompositeChange change) {
        Change[] changeArray = change.getChildren();
        int n = changeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Change child = changeArray[n2];
            if (child instanceof CompositeChange) {
                if (this.hasChanges((CompositeChange)child)) {
                    return true;
                }
            } else {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Collection<GroupCategory> collectGroupCategories() {
        HashSet<GroupCategory> result = new HashSet<GroupCategory>();
        this.collectGroupCategories(result, this.fChange);
        return result;
    }

    private void collectGroupCategories(Set<GroupCategory> result, Change change) {
        block3: {
            block2: {
                if (!(change instanceof TextEditBasedChange)) break block2;
                TextEditBasedChangeGroup[] textEditBasedChangeGroupArray = ((TextEditBasedChange)change).getChangeGroups();
                int n = textEditBasedChangeGroupArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TextEditBasedChangeGroup group = textEditBasedChangeGroupArray[n2];
                    result.addAll(group.getGroupCategorySet().asList());
                    ++n2;
                }
                break block3;
            }
            if (!(change instanceof CompositeChange)) break block3;
            Change[] changeArray = ((CompositeChange)change).getChildren();
            int n = changeArray.length;
            int n3 = 0;
            while (n3 < n) {
                Change child = changeArray[n3];
                this.collectGroupCategories(result, child);
                ++n3;
            }
        }
    }

    private void setActiveGroupCategory(GroupCategory category) {
        if (this.fActiveGroupCategories == null) {
            this.fActiveGroupCategories = new ArrayList<GroupCategory>(1);
        } else {
            this.fActiveGroupCategories.clear();
        }
        this.fActiveGroupCategories.add(category);
        this.fTreeViewer.setGroupCategory(this.fActiveGroupCategories);
        this.updateTreeViewerPaneTitle();
    }

    private void updateTreeViewerPaneTitle() {
        String derivedMessage = null;
        String groupFilterMessage = null;
        if (this.fDerivedFilterActive && this.fTreeViewer != null && this.fTreeViewer.getInput() instanceof PreviewNode && ((PreviewNode)this.fTreeViewer.getInput()).hasDerived()) {
            derivedMessage = RefactoringUIMessages.PreviewWizardPage_changes_filter_derived;
        }
        if (this.fActiveGroupCategories != null && this.fActiveGroupCategories.size() > 0) {
            GroupCategory groupCategory = this.fActiveGroupCategories.get(0);
            groupFilterMessage = Messages.format(RefactoringUIMessages.PreviewWizardPage_changes_filter_category, groupCategory.getName());
        }
        String title = groupFilterMessage == null && derivedMessage == null ? RefactoringUIMessages.PreviewWizardPage_changes : (groupFilterMessage != null && derivedMessage != null ? Messages.format(RefactoringUIMessages.PreviewWizardPage_changes_filtered2, new Object[]{groupFilterMessage, derivedMessage}) : (groupFilterMessage != null ? Messages.format(RefactoringUIMessages.PreviewWizardPage_changes_filtered, groupFilterMessage) : Messages.format(RefactoringUIMessages.PreviewWizardPage_changes_filtered, derivedMessage)));
        this.fTreeViewerPane.setText(title);
    }

    private void clearGroupCategories() {
        this.fActiveGroupCategories = null;
        this.fTreeViewer.setGroupCategory(null);
        this.updateTreeViewerPaneTitle();
    }

    private void setHideDerived(boolean hide) {
        this.fDerivedFilterActive = hide;
        this.fTreeViewer.setHideDerived(hide);
        this.updateTreeViewerPaneTitle();
    }

    @Override
    public Change getChange() {
        return this.fChange;
    }

    private class FilterAction
    extends Action {
        private FilterDropDownAction fOwner;
        private GroupCategory fGroupCategory;

        public FilterAction(FilterDropDownAction owner, GroupCategory category) {
            super(category.getName(), 8);
            this.setToolTipText(category.getDescription());
            this.fOwner = owner;
            this.fGroupCategory = category;
        }

        public void run() {
            BusyIndicator.showWhile((Display)PreviewWizardPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    PreviewWizardPage.this.setActiveGroupCategory(FilterAction.this.fGroupCategory);
                    FilterAction.this.fOwner.executed(FilterAction.this);
                }
            });
        }
    }

    private class FilterDropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;
        private ShowAllAction fShowAllAction;
        private FilterAction[] fFilterActions;
        private Action fActiveAction;
        private HideDerivedAction fHideDerivedAction;

        public FilterDropDownAction() {
            this.setImageDescriptor(RefactoringPluginImages.DESC_ELCL_FILTER);
            this.setDisabledImageDescriptor(RefactoringPluginImages.DESC_DLCL_FILTER);
            this.setText(RefactoringUIMessages.PreviewWizardPage_filterChanges);
            this.setToolTipText(RefactoringUIMessages.PreviewWizardPage_filterChanges);
            this.setMenuCreator(this);
        }

        public void initialize(Collection<GroupCategory> groupCategories) {
            ArrayList<GroupCategory> list = new ArrayList<GroupCategory>(groupCategories);
            Collections.sort(list, new Comparator<GroupCategory>(){
                private Collator fCollator = Collator.getInstance();

                @Override
                public final int compare(GroupCategory first, GroupCategory second) {
                    return this.fCollator.compare(first.getName(), second.getName());
                }
            });
            this.fShowAllAction = new ShowAllAction(this);
            this.fActiveAction = this.fShowAllAction;
            this.fFilterActions = new FilterAction[list.size()];
            int i = 0;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                this.fFilterActions[i++] = new FilterAction(this, (GroupCategory)iter.next());
            }
            this.fHideDerivedAction = new HideDerivedAction();
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            this.dispose();
            this.fMenu = new Menu(parent);
            if (this.fFilterActions.length != 0) {
                new ActionContributionItem((IAction)this.fShowAllAction).fill(this.fMenu, -1);
                FilterAction[] filterActionArray = this.fFilterActions;
                int n = this.fFilterActions.length;
                int n2 = 0;
                while (n2 < n) {
                    FilterAction fFilterAction = filterActionArray[n2];
                    new ActionContributionItem((IAction)fFilterAction).fill(this.fMenu, -1);
                    ++n2;
                }
                new MenuItem(this.fMenu, 2);
            }
            new ActionContributionItem((IAction)this.fHideDerivedAction).fill(this.fMenu, -1);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void runWithEvent(Event event) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar toolBar = toolItem.getParent();
            Menu menu = this.getMenu((Control)toolBar);
            Rectangle toolItemBounds = toolItem.getBounds();
            Point location = toolBar.toDisplay(toolItemBounds.x, toolItemBounds.y + toolItemBounds.height);
            menu.setLocation(location);
            menu.setVisible(true);
        }

        public void executed(Action action) {
            if (this.fActiveAction == action) {
                return;
            }
            this.fActiveAction.setChecked(false);
            this.fActiveAction = action;
            this.fActiveAction.setChecked(true);
            if (PreviewWizardPage.this.fCurrentSelection != null) {
                PreviewWizardPage.this.showPreview(PreviewWizardPage.this.fCurrentSelection);
            }
        }
    }

    private class HideDerivedAction
    extends Action {
        public HideDerivedAction() {
            super(RefactoringUIMessages.PreviewWizardPage_hideDerived_text, 2);
            this.setChecked(PreviewWizardPage.this.fDerivedFilterActive);
        }

        public void run() {
            BusyIndicator.showWhile((Display)PreviewWizardPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public final void run() {
                    boolean hideDerived = HideDerivedAction.this.isChecked();
                    PreviewWizardPage.this.getRefactoringSettings().put(PreviewWizardPage.PREVIEW_WIZARD_PAGE_HIDE_DERIVED, hideDerived);
                    PreviewWizardPage.this.setHideDerived(hideDerived);
                }
            });
        }
    }

    private class NextChange
    extends Action {
        public NextChange() {
            this.setId(PreviewWizardPage.NEXT_CHANGE_ID);
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_NEXT);
            this.setToolTipText(RefactoringUIMessages.PreviewWizardPage_next_Change);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.next_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealNext();
        }
    }

    private static class NullPreviewer
    implements IChangePreviewViewer {
        private Label fLabel;

        private NullPreviewer() {
        }

        @Override
        public void createControl(Composite parent) {
            this.fLabel = new Label(parent, 0x1800000);
            this.fLabel.setText(RefactoringUIMessages.PreviewWizardPage_no_preview);
        }

        @Override
        public Control getControl() {
            return this.fLabel;
        }

        @Override
        public void setInput(ChangePreviewViewerInput input) {
        }
    }

    private class PreviousChange
    extends Action {
        public PreviousChange() {
            this.setId(PreviewWizardPage.PREVIOUS_CHANGE_ID);
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_PREV);
            this.setToolTipText(RefactoringUIMessages.PreviewWizardPage_previous_Change);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.previous_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealPrevious();
        }
    }

    private class ShowAllAction
    extends Action {
        private FilterDropDownAction fOwner;

        public ShowAllAction(FilterDropDownAction owner) {
            super(RefactoringUIMessages.PreviewWizardPage_showAll_text, 8);
            super.setToolTipText(RefactoringUIMessages.PreviewWizardPage_showAll_description);
            this.fOwner = owner;
            this.setChecked(true);
        }

        public void run() {
            BusyIndicator.showWhile((Display)PreviewWizardPage.this.getShell().getDisplay(), (Runnable)new Runnable(){

                @Override
                public final void run() {
                    PreviewWizardPage.this.clearGroupCategories();
                    ShowAllAction.this.fOwner.executed(ShowAllAction.this);
                }
            });
        }
    }
}

