/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.panes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.snapshot.HeapObjectContextArgument;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.refined.RefinedResultBuilder;
import org.eclipse.mat.query.refined.RefinedTable;
import org.eclipse.mat.query.refined.RefinedTree;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.query.registry.QueryRegistry;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.editor.MultiPaneEditorSite;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.internal.viewer.RefinedTableViewer;
import org.eclipse.mat.ui.internal.viewer.RefinedTreeViewer;
import org.eclipse.mat.ui.snapshot.editor.HeapEditor;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryResultPane
extends AbstractEditorPane
implements ISelectionProvider {
    private List<ISelectionChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    protected Composite top;
    protected RefinedResultViewer viewer;
    protected QueryResult srcQueryResult;
    private Listener proxy = new Listener(){
        boolean arrowKeyDown = false;
        int[] count = new int[1];

        public void handleEvent(Event e) {
            switch (e.type) {
                case 1: {
                    this.arrowKeyDown = (e.keyCode == 0x1000001 || e.keyCode == 0x1000002 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004) && e.stateMask == 0;
                }
                case 13: {
                    this.count[0] = this.count[0] + 1;
                    final int id = this.count[0];
                    QueryResultPane.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (arrowKeyDown) {
                                (this).QueryResultPane.this.viewer.getControl().getDisplay().timerExec(250, new Runnable(){

                                    public void run() {
                                        if (id == count[0]) {
                                            QueryResultPane.this.forwardSelectionChangedEvent();
                                        }
                                    }
                                });
                            } else {
                                QueryResultPane.this.forwardSelectionChangedEvent();
                            }
                        }
                    });
                    break;
                }
            }
        }
    };

    public void createPartControl(Composite parent) {
        this.top = parent;
        this.makeActions();
    }

    protected void makeActions() {
    }

    @Override
    public void initWithArgument(Object argument) {
        this.srcQueryResult = (QueryResult)argument;
        RefinedResultViewer viewer = this.createViewer(this.srcQueryResult);
        this.activateViewer(viewer);
        this.firePropertyChange(1);
        this.firePropertyChange(0x1000002);
    }

    public String getTitle() {
        return this.viewer != null ? this.viewer.getQueryResult().getTitle() : Messages.QueryResultPane_QueryResult;
    }

    @Override
    public Image getTitleImage() {
        Image image = this.viewer != null ? MemoryAnalyserPlugin.getDefault().getImage(this.viewer.getQueryResult().getQuery()) : null;
        return image != null ? image : MemoryAnalyserPlugin.getImage("$nl$/icons/query_browser.gif");
    }

    @Override
    public String getTitleToolTip() {
        return this.viewer != null ? this.viewer.getQueryResult().getTitleToolTip() : null;
    }

    @Override
    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    @Override
    protected void editorContextMenuAboutToShow(PopupMenu menu) {
        menu.addSeparator();
        this.viewer.addContextMenu(menu);
    }

    @Override
    public void contributeToToolBar(IToolBarManager manager) {
        this.viewer.contributeToToolBar(manager);
        IResult subject = this.viewer.getQueryResult().getSubject();
        if (subject instanceof IResultTree) {
            manager.add((IContributionItem)new Separator());
            this.addShowAsHistogramAction(manager, (IResultTree)subject);
        }
    }

    private void addShowAsHistogramAction(IToolBarManager manager, final IResultTree subject) {
        Action showAsHistogramAction = new Action(){

            public void run() {
                boolean foundObj = false;
                List elements = subject.getElements();
                ArrayList<IContextObject> contextObjects = new ArrayList<IContextObject>();
                int i = 0;
                while (i < elements.size()) {
                    IContextObject context = subject.getContext(elements.get(i));
                    if (context != null) {
                        contextObjects.add(context);
                        if (context instanceof IContextObjectSet) {
                            foundObj = foundObj || ((IContextObjectSet)context).getObjectIds().length > 0;
                        } else if (context.getObjectId() >= 0) {
                            foundObj = true;
                        }
                    }
                    ++i;
                }
                if (!foundObj) {
                    ErrorHelper.showInfoMessage(Messages.QueryResultPane_InfoMessage);
                }
                try {
                    IEditorPart editor = QueryResultPane.this.site.getPage().getActiveEditor();
                    QueryDescriptor descriptor = QueryRegistry.instance().getQuery("histogram");
                    ArgumentSet set = descriptor.createNewArgumentSet(QueryResultPane.this.getQueryContext());
                    HeapObjectContextArgument objs = new HeapObjectContextArgument((ISnapshot)QueryResultPane.this.getQueryContext().get(ISnapshot.class, null), contextObjects, QueryResultPane.this.getTitle());
                    set.setArgumentValue(descriptor.getArgumentByName("objects"), (Object)objs);
                    QueryExecution.execute((HeapEditor)editor, ((HeapEditor)editor).getActiveEditor().getPaneState(), null, set, false, false);
                }
                catch (SnapshotException e) {
                    ErrorHelper.logThrowableAndShowMessage(e);
                }
            }
        };
        showAsHistogramAction.setImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("$nl$/icons/as_histogram.gif"));
        showAsHistogramAction.setToolTipText(Messages.QueryResultPane_ShowAsHistogram);
        manager.add((IAction)showAsHistogramAction);
    }

    protected RefinedResultViewer createViewer(QueryResult queryResult) {
        IResult subject = queryResult.getSubject();
        if (subject instanceof IResultTree) {
            RefinedTree refinedTree = (RefinedTree)new RefinedResultBuilder(this.getQueryContext(), (IStructuredResult)((IResultTree)subject)).build();
            return new RefinedTreeViewer(this.getQueryContext(), queryResult, refinedTree);
        }
        if (subject instanceof IResultTable) {
            RefinedTable refinedTable = (RefinedTable)new RefinedResultBuilder(this.getQueryContext(), (IStructuredResult)((IResultTable)subject)).build();
            return new RefinedTableViewer(this.getQueryContext(), queryResult, refinedTable);
        }
        throw new IllegalArgumentException(subject.getClass().getName());
    }

    protected void activateViewer(RefinedResultViewer viewer) {
        this.viewer = viewer;
        this.top.setRedraw(false);
        try {
            viewer.init(this.top, ((MultiPaneEditorSite)this.getEditorSite()).getMultiPageEditor(), this);
            this.hookContextMenu(viewer.getControl());
            this.hookContextAwareListeners();
            MultiPaneEditor multiPaneEditor = ((MultiPaneEditorSite)this.getEditorSite()).getMultiPageEditor();
            multiPaneEditor.updateToolbar();
        }
        finally {
            this.top.layout();
            this.top.setRedraw(true);
        }
    }

    protected void deactivateViewer() {
        this.unhookContextAwareListeners();
        this.viewer.dispose();
    }

    protected void hookContextAwareListeners() {
        Control control = this.viewer.getControl();
        control.addListener(13, this.proxy);
        control.addListener(1, this.proxy);
    }

    protected void unhookContextAwareListeners() {
        Control control = this.viewer.getControl();
        control.removeListener(13, this.proxy);
        control.removeListener(1, this.proxy);
    }

    private void forwardSelectionChangedEvent() {
        ArrayList<ISelectionChangedListener> l = new ArrayList<ISelectionChangedListener>(this.listeners);
        for (ISelectionChangedListener listener : l) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.convertSelection(this.viewer.getSelection())));
        }
    }

    public ISelection getSelection() {
        return this.viewer != null ? this.convertSelection(this.viewer.getSelection()) : StructuredSelection.EMPTY;
    }

    private ISelection convertSelection(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            ArrayList<IContextObject> menuContext = new ArrayList<IContextObject>();
            for (Object selected : selection) {
                IContextObject ctx = this.getInspectorContextObject(selected);
                if (ctx == null) continue;
                menuContext.add(ctx);
            }
            if (!menuContext.isEmpty()) {
                return new StructuredSelection(menuContext);
            }
        }
        return StructuredSelection.EMPTY;
    }

    private IContextObject getInspectorContextObject(Object subject) {
        return this.viewer.getQueryResult().getDefaultContextProvider().getContext(subject);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public QueryResult getSrcQueryResult() {
        return this.srcQueryResult;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.srcQueryResult.getClass())) {
            return adapter.cast(this.srcQueryResult);
        }
        if (adapter.isAssignableFrom(this.srcQueryResult.getSubject().getClass())) {
            return adapter.cast(this.srcQueryResult.getSubject());
        }
        return super.getAdapter(adapter);
    }
}

