/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.jee.actions.Messages;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDeploymentDescriptorDiscoverer<T>
extends AbstractModelDiscoverer<T> {
    public static String getDescXmlVersion(Plugin plugin, Object source, String rootName, String dtdUrl) {
        Document doc;
        File file;
        String extension;
        String version;
        block20: {
            version = "";
            extension = ".xsd";
            file = null;
            file = source instanceof IFile && ((IFile)source).exists() ? new File(((IFile)source).getLocation().toString()) : (File)source;
            try {
                String http;
                FileReader reader = new FileReader(file);
                BufferedReader buffReader = new BufferedReader(reader);
                String line = buffReader.readLine();
                StringBuffer buffer = new StringBuffer();
                while (line != null) {
                    if (line.contains("<!DOCTYPE")) {
                        buffer.append(line);
                        if (line.contains(">")) break;
                        line = buffReader.readLine();
                        while (line != null) {
                            buffer.append(line);
                            if (line.contains(">")) break;
                            line = buffReader.readLine();
                        }
                    }
                    line = buffReader.readLine();
                }
                if (buffer.length() > 0 && buffer.indexOf(http = "http://java.sun.com") > 0) {
                    String systemId = buffer.substring(buffer.indexOf(http));
                    if (systemId.indexOf(".dtd") > 0) {
                        systemId = systemId.substring(0, systemId.indexOf(".dtd"));
                        version = systemId.substring(systemId.indexOf(rootName) + rootName.length() + 1, systemId.length()).replace("_", ".");
                    }
                    return version;
                }
            }
            catch (FileNotFoundException e) {
                MoDiscoLogger.logError((String)e.getMessage(), (Plugin)plugin);
            }
            catch (IOException e) {
                MoDiscoLogger.logError((String)e.getMessage(), (Plugin)plugin);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(file);
            doc.getDocumentElement().normalize();
            if (doc.getDocumentElement().getNodeName().equalsIgnoreCase(rootName)) break block20;
            return "0";
        }
        try {
            if (!doc.getDocumentElement().getAttribute("version").toString().equalsIgnoreCase("")) {
                version = doc.getDocumentElement().getAttribute("version").toString();
            } else if (!doc.getDocumentElement().getAttribute("xsi:schemaLocation").toString().equalsIgnoreCase("")) {
                String schemaLocation = doc.getDocumentElement().getAttribute("xsi:schemaLocation");
                if (schemaLocation.contains(rootName)) {
                    version = ((String)schemaLocation.subSequence(schemaLocation.indexOf(rootName) + rootName.length() + 1, schemaLocation.length() - extension.length())).replace("_", ".");
                }
            } else if (doc.getDoctype() != null) {
                String systemId = doc.getDoctype().getSystemId();
                version = systemId.substring(systemId.indexOf(rootName) + rootName.length() + 1, systemId.length() - extension.length()).replace("_", ".");
            } else {
                version = AbstractDeploymentDescriptorDiscoverer.getDoctypeVersion(plugin, file, rootName, dtdUrl);
            }
        }
        catch (ParserConfigurationException e) {
            MoDiscoLogger.logError((String)e.getMessage(), (Plugin)plugin);
        }
        catch (IOException e) {
            MoDiscoLogger.logError((String)e.getMessage(), (Plugin)plugin);
        }
        catch (SAXException e) {
            MoDiscoLogger.logError((String)e.getMessage(), (Plugin)plugin);
        }
        return version;
    }

    public static String getDoctypeVersion(Plugin plugin, Object source, String rootName, String baseUrl) {
        String version = "";
        String docType = "DOCTYPE";
        String dtdFileExtension = ".dtd";
        int dtdDeclarationSize = 5;
        File file = null;
        file = source instanceof IFile && ((IFile)source).exists() ? new File(((IFile)source).getLocation().toString()) : (File)source;
        try {
            String line;
            FileInputStream ips = new FileInputStream(file.getPath());
            InputStreamReader ipsr = new InputStreamReader(ips);
            BufferedReader br = new BufferedReader(ipsr);
            while ((line = br.readLine()) != null) {
                if (!line.contains(docType)) continue;
                String bigLine = line;
                int i = 0;
                while (i < 5) {
                    bigLine = String.valueOf(bigLine) + br.readLine();
                    ++i;
                }
                if (!(bigLine = bigLine.replaceAll("\\s+", "")).contains(baseUrl)) continue;
                String subSq = (String)bigLine.subSequence(bigLine.indexOf(baseUrl), bigLine.length());
                version = subSq.substring(subSq.indexOf(rootName) + rootName.length() + 1, subSq.indexOf(rootName) + rootName.length() + dtdFileExtension.length()).replace("_", ".");
                break;
            }
            br.close();
        }
        catch (Exception e) {
            MoDiscoLogger.logWarning((String)(String.valueOf(Messages.DeployementDescriptorDiscoverer_1) + e.toString()), (Plugin)plugin);
        }
        return version;
    }
}

