/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkDocument;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractEditHyperlinkShell;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class EditorHyperlinkDocumentShell
extends AbstractEditHyperlinkShell {
    protected boolean usedefaultTooltip = true;
    protected HyperLinkDocument hyperlinkDocument;

    public EditorHyperlinkDocumentShell(Shell parentShell) {
        super(parentShell, true);
    }

    public HyperLinkDocument getHyperlinkDocument() {
        return this.hyperlinkDocument;
    }

    public void setHyperlinkDocument(HyperLinkDocument hyperlinkDocument) {
        this.hyperlinkDocument = hyperlinkDocument;
        this.updateFields();
    }

    @Override
    protected void contentsCreated() {
        this.getObjectLabel().setText(Messages.AbstractEditHyperlinkDocumentShell_Document);
        this.getUseDefaultCheckBox().setSelection(this.usedefaultTooltip);
        this.getObjectLabelText().setEditable(false);
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabelText().getText());
        }
        this.updateFields();
    }

    private void updateFields() {
        if (this.getHyperlinkDocument() != null) {
            if (this.getObjectLabelText() != null) {
                this.getObjectLabelText().setText(this.getHyperlinkDocument().getHyperlinkDocument());
            }
            if (this.getTooltipInputText() != null) {
                this.getTooltipInputText().setText(this.getHyperlinkDocument().getTooltipText());
            }
        }
    }

    @Override
    protected void onSearch() {
        FileDialog fd = new FileDialog(this.getShell(), 4096);
        fd.setText(Messages.EditorHyperlinkDocumentShell_Open);
        String[] filterExt = new String[]{"*.pdf", "*.doc", "*.txt", "*"};
        fd.setFilterExtensions(filterExt);
        String selected = fd.open();
        if (selected != null) {
            this.getObjectLabelText().setText(selected);
            if (this.usedefaultTooltip) {
                this.getTooltipInputText().setText(selected);
            }
        }
    }

    @Override
    protected void onUseDefaultTooltip() {
        this.usedefaultTooltip = this.getUseDefaultCheckBox().getSelection();
        if (this.usedefaultTooltip) {
            this.getTooltipInputText().setEditable(false);
            this.getTooltipInputText().setText(this.getObjectLabelText().getText());
        } else {
            this.getTooltipInputText().setEditable(true);
        }
    }

    protected void cancelPressed() {
        this.hyperlinkDocument = null;
        super.cancelPressed();
    }

    protected void okPressed() {
        if (this.hyperlinkDocument == null) {
            this.hyperlinkDocument = new HyperLinkDocument();
        }
        this.hyperlinkDocument.setHyperlinkDocument(this.getObjectLabelText().getText().trim());
        this.hyperlinkDocument.setTooltipText(this.getTooltipInputText().getText().trim());
        super.cancelPressed();
    }
}

