/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.utils.TableGridRegion;
import org.eclipse.swt.graphics.Point;

public class LocationValue {
    private final Point absolutePoint;
    private final Point widgetPoint;
    private final TableGridRegion kind;
    private final int columnIndex;
    private final int rowIndex;
    private final ILayerCell layerCell;
    private final Object columnObject;
    private final Object rowObject;

    public LocationValue(TableGridRegion kind, ILayerCell cell, int columnIndex, int rowIndex, Object columnObject, Object rowObject) {
        this(null, null, kind, cell, columnIndex, rowIndex, columnObject, rowObject);
    }

    public LocationValue(Point absoluteLocation, Point widgetLocation, TableGridRegion kind, ILayerCell cell, int columnIndex, int rowIndex, Object columnObject, Object rowObject) {
        this.absolutePoint = absoluteLocation;
        this.widgetPoint = widgetLocation;
        this.kind = kind;
        this.layerCell = cell;
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
        this.columnObject = columnObject;
        this.rowObject = rowObject;
    }

    public Point getPoint() {
        return this.absolutePoint;
    }

    public Point getTranslatedPoint() {
        return this.widgetPoint;
    }

    public TableGridRegion getKind() {
        return this.kind;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public ILayerCell getLayerCell() {
        return this.layerCell;
    }

    public Point getAbsolutePoint() {
        return this.absolutePoint;
    }

    public Point getWidgetPoint() {
        return this.widgetPoint;
    }

    public Object getColumnObject() {
        return this.columnObject;
    }

    public Object getRowObject() {
        return this.rowObject;
    }

    public String toString() {
        String message = "location : " + (Object)((Object)this.kind) + ", columnIndex :" + this.columnIndex + ", rowIndex :" + this.rowIndex + ", columnObject :" + this.columnObject + ", rowObject :" + this.rowObject;
        return message;
    }
}

