/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.layout;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.layout.LayoutUtils;

public class LinkRepresentationForLayoutAction {
    private EditPart source = null;
    private EditPart target = null;
    private Point newSourcePosition = null;
    private Point oldSourcePosition = null;
    private Point newTargetPosition = null;
    private Point oldTargetPosition = null;
    private ConnectionEditPart link;

    public LinkRepresentationForLayoutAction(ConnectionEditPart link) {
        this.link = link;
        this.source = link.getSource();
        this.target = link.getTarget();
        IFigure fig = ((AbstractConnectionEditPart)link).getFigure();
        Assert.isTrue((boolean)(fig instanceof PolylineConnectionEx));
        PolylineConnectionEx linkFigure = (PolylineConnectionEx)fig;
        Point start = linkFigure.getStart();
        Point end = linkFigure.getEnd();
        linkFigure.translateToAbsolute((Translatable)start);
        linkFigure.translateToAbsolute((Translatable)end);
        this.oldSourcePosition = start;
        this.oldTargetPosition = end;
    }

    public String toString() {
        return ((View)this.link.getModel()).getElement().toString();
    }

    public org.eclipse.gef.commands.Command getCommand() {
        if (this.newSourcePosition == null && this.newTargetPosition == null || this.oldSourcePosition.equals((Object)this.newSourcePosition) && this.oldTargetPosition.equals((Object)this.newTargetPosition)) {
            return new EMFtoGEFCommandWrapper((Command)new IdentityCommand());
        }
        CompoundCommand command = new CompoundCommand();
        command.add(this.source.getCommand(this.getRequestForSource()));
        command.add(this.target.getCommand(this.getRequestForTarget()));
        return command.canExecute() ? command : UnexecutableCommand.INSTANCE;
    }

    public Request getRequestForSource() {
        ReconnectRequest request = new ReconnectRequest((Object)"Reconnection source");
        request.setConnectionEditPart(this.link);
        request.setTargetEditPart(this.source);
        request.setLocation(this.getNewSourceLocation());
        return request;
    }

    protected Point getNewSourceLocation() {
        if (this.newSourcePosition != null) {
            return this.newSourcePosition;
        }
        return this.oldSourcePosition;
    }

    protected Point getNewTargetLocation() {
        if (this.newTargetPosition != null) {
            return this.newTargetPosition;
        }
        return this.oldTargetPosition;
    }

    public void setNewLocationFor(EditPart node, Point location) {
        if (this.source == node) {
            this.newSourcePosition = location;
        } else if (this.target == node) {
            this.newTargetPosition = location;
        } else {
            Activator.log.error("Can't find the EditPart " + node + " (from " + this.getClass().getName() + ")", null);
        }
    }

    public Request getRequestForTarget() {
        ReconnectRequest request = new ReconnectRequest((Object)"Reconnection target");
        request.setConnectionEditPart(this.link);
        request.setTargetEditPart(this.target);
        request.setLocation(this.getNewTargetLocation());
        return request;
    }

    public int getCurrentSideOn(EditPart node) {
        if (node == this.source) {
            return LayoutUtils.getAnchorPosition(this.source, this.oldSourcePosition);
        }
        if (node == this.target) {
            return LayoutUtils.getAnchorPosition(this.target, this.oldTargetPosition);
        }
        Activator.log.error("Can't find the EditPart " + node + " (from " + this.getClass().getName() + ")", null);
        return 0;
    }

    public ConnectionEditPart getRepresentedLink() {
        return this.link;
    }

    public PrecisionRectangle getAbsolutePositionOn(EditPart node) {
        PrecisionRectangle rect = new PrecisionRectangle();
        rect.setSize(new Dimension(1, 1));
        if (this.source == node) {
            rect.setX(this.oldSourcePosition.x);
            rect.setY(this.oldSourcePosition.y);
        } else if (this.target == node) {
            rect.setX(this.oldTargetPosition.x);
            rect.setY(this.oldTargetPosition.y);
        } else {
            Activator.log.error("Can't find the EditPart " + node + " (from " + this.getClass().getName() + ")", null);
        }
        return rect;
    }

    public Point getAbsoluteLocationOn(EditPart node) {
        if (this.source == node) {
            return this.oldSourcePosition;
        }
        if (this.target == node) {
            return this.oldTargetPosition;
        }
        Activator.log.error("Can't find the EditPart " + node + " (from " + this.getClass().getName() + ")", null);
        return new Point();
    }

    public int getSideOnSource() {
        return this.getCurrentSideOn(this.source);
    }

    public int getSideOnTarget() {
        return this.getCurrentSideOn(this.target);
    }
}

