/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;

public class PFWorkspaceJob
extends WorkspaceJob {
    private RSEDOM _dom;
    private IRSEPersistenceProvider _provider;

    public PFWorkspaceJob(RSEDOM dom, IRSEPersistenceProvider provider) {
        super("Saving Profile");
        String title = NLS.bind((String)RSECoreMessages.SaveRSEDOMJob_SavingProfileJobName, (Object)dom.getName());
        this.setName(title);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        this._dom = dom;
        this._provider = provider;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) {
        IStatus result = Status.OK_STATUS;
        boolean saved = this._provider.saveRSEDOM(this._dom, monitor);
        if (!saved) {
            result = Status.CANCEL_STATUS;
        }
        return result;
    }

    public boolean belongsTo(Object family) {
        Object[] families = new Object[]{RSECorePlugin.getThePersistenceManager()};
        int i = 0;
        while (i < families.length) {
            Object object = families[i];
            if (family == object) {
                return true;
            }
            ++i;
        }
        return super.belongsTo(family);
    }
}

