/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;

public class RemoteModule
extends RemoteFolder {
    private String label;
    private ICVSRemoteResource[] referencedModules;
    private Command.LocalOption[] localOptions;
    private boolean expandable;

    public static RemoteModule[] getRemoteModules(ICVSRepositoryLocation repository, CVSTag tag, IProgressMonitor monitor) throws TeamException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(CVSMessages.RemoteModule_getRemoteModules, 100);
        try {
            RemoteModule[] modules;
            s.open(Policy.subMonitorFor(monitor, 10), false);
            try (Session s = new Session(repository, RemoteModule.getRemoteRootFolder(repository), false);){
                modules = Command.CHECKOUT.getRemoteModules(s, tag, Policy.subMonitorFor(monitor, 90));
            }
            RemoteModule[] remoteModuleArray = modules;
            return remoteModuleArray;
        }
        finally {
            monitor.done();
        }
    }

    private static ICVSFolder getRemoteRootFolder(ICVSRepositoryLocation repository) {
        return new RemoteFolder(null, repository, "/", null);
    }

    public static RemoteModule[] createRemoteModules(String[] moduleDefinitionStrings, ICVSRepositoryLocation repository, CVSTag tag) {
        String[] stringArray;
        ArrayList<RemoteFolder> referencedFolders;
        HashMap<String, RemoteModule> modules = new HashMap<String, RemoteModule>();
        HashMap<String, String[]> referencedModulesTable = new HashMap<String, String[]>();
        HashMap<String, String[]> moduleAliases = new HashMap<String, String[]>();
        String[] stringArray2 = moduleDefinitionStrings;
        int n = moduleDefinitionStrings.length;
        int n2 = 0;
        while (n2 < n) {
            block41: {
                String next;
                ArrayList<Command.LocalOption> localOptionsList;
                String moduleDefinitionString = stringArray2[n2];
                StringTokenizer tokenizer = new StringTokenizer(moduleDefinitionString);
                String moduleName = tokenizer.nextToken();
                try {
                    localOptionsList = new ArrayList<Command.LocalOption>();
                    next = tokenizer.nextToken();
                    while (next.charAt(0) == '-') {
                        switch (next.charAt(1)) {
                            case 'a': {
                                localOptionsList.add(Checkout.ALIAS);
                                break;
                            }
                            case 'l': {
                                localOptionsList.add(Command.DO_NOT_RECURSE);
                                break;
                            }
                            case 'd': {
                                localOptionsList.add(Checkout.makeDirectoryNameOption(tokenizer.nextToken()));
                                break;
                            }
                            case 'e': 
                            case 'i': 
                            case 'o': 
                            case 't': 
                            case 'u': {
                                tokenizer.nextToken();
                                break;
                            }
                            case 's': {
                                localOptionsList.add(Checkout.makeStatusOption(tokenizer.nextToken()));
                            }
                        }
                        next = tokenizer.nextToken();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    CVSProviderPlugin.log(2, NLS.bind((String)CVSMessages.RemoteModule_invalidDefinition, (Object[])new String[]{moduleDefinitionString, repository.getLocation(true)}), null);
                    break block41;
                }
                Command.Option[] localOptions = localOptionsList.toArray(new Command.LocalOption[localOptionsList.size()]);
                if (Checkout.ALIAS.isElementOf(localOptions)) {
                    int cfr_ignored_0 = localOptions.length;
                    ArrayList<String> expansions = new ArrayList<String>(10);
                    expansions.add(next);
                    while (tokenizer.hasMoreTokens()) {
                        expansions.add(tokenizer.nextToken());
                    }
                    moduleAliases.put(moduleName, expansions.toArray(new String[expansions.size()]));
                    modules.put(moduleName, new RemoteModule(moduleName, null, repository, null, (Command.LocalOption[])localOptions, tag, true));
                } else {
                    if (next.charAt(0) != '&') {
                        String directory = next;
                        ArrayList<String> files = new ArrayList<String>();
                        while (tokenizer.hasMoreTokens() && next.charAt(0) != '&') {
                            next = tokenizer.nextToken();
                            if (next.charAt(0) == '&') continue;
                            files.add(next);
                        }
                        RemoteModule remoteModule = new RemoteModule(moduleName, null, repository, directory, (Command.LocalOption[])localOptions, tag, !files.isEmpty());
                        modules.put(moduleName, remoteModule);
                        if (!files.isEmpty()) {
                            ICVSRemoteResource[] children = new ICVSRemoteResource[files.size()];
                            int j = 0;
                            while (j < children.length) {
                                children[j] = new RemoteFile(remoteModule, 0, (String)files.get(j), null, null, tag);
                                remoteModule.setChildren(children);
                                ++j;
                            }
                        }
                    } else {
                        modules.put(moduleName, new RemoteModule(moduleName, null, repository, null, (Command.LocalOption[])localOptions, tag, true));
                    }
                    if (next.charAt(0) == '&') {
                        ArrayList<String> children = new ArrayList<String>(10);
                        children.add(next);
                        while (tokenizer.hasMoreTokens()) {
                            children.add(tokenizer.nextToken());
                        }
                        referencedModulesTable.put(moduleName, children.toArray(new String[children.size()]));
                    }
                }
            }
            ++n2;
        }
        for (String moduleName : moduleAliases.keySet()) {
            RemoteModule module = (RemoteModule)modules.get(moduleName);
            String[] expansion = (String[])moduleAliases.get(moduleName);
            referencedFolders = new ArrayList<RemoteFolder>();
            boolean expandable = true;
            stringArray = expansion;
            int n3 = expansion.length;
            int n4 = 0;
            while (n4 < n3) {
                String e = stringArray[n4];
                if (e.charAt(0) == '!') {
                    expandable = false;
                } else {
                    Path path = new Path(null, e);
                    if (path.segmentCount() > 1) {
                        expandable = false;
                    } else {
                        RemoteModule child = (RemoteModule)modules.get(e);
                        if (child == null) {
                            referencedFolders.add(new RemoteFolder(null, repository, path.toString(), tag));
                        } else if (child.isAlias()) {
                            expandable = false;
                        } else {
                            referencedFolders.add(child);
                        }
                    }
                }
                ++n4;
            }
            if (expandable) {
                module.setChildren(referencedFolders.toArray(new ICVSRemoteResource[referencedFolders.size()]));
                continue;
            }
            module.setExpandable(false);
        }
        for (String moduleName : modules.keySet()) {
            String[] children = (String[])referencedModulesTable.get(moduleName);
            if (children == null) continue;
            RemoteModule module = (RemoteModule)modules.get(moduleName);
            referencedFolders = new ArrayList();
            boolean expandable = true;
            stringArray = children;
            int n5 = children.length;
            int n6 = 0;
            while (n6 < n5) {
                String c = stringArray[n6];
                RemoteModule child = (RemoteModule)modules.get(c.substring(1));
                if (child == null) {
                    expandable = false;
                } else if (child.isAlias()) {
                    expandable = false;
                } else if (Command.findOption(child.getLocalOptions(), "-d") != null) {
                    expandable = false;
                } else {
                    referencedFolders.add(child);
                }
                ++n6;
            }
            if (expandable) {
                module.setReferencedModules(referencedFolders.toArray(new ICVSRemoteResource[referencedFolders.size()]));
                continue;
            }
            module.setExpandable(false);
        }
        return modules.values().toArray(new RemoteModule[modules.size()]);
    }

    public RemoteModule(String label, RemoteFolder parent, ICVSRepositoryLocation repository, String repositoryRelativePath, Command.LocalOption[] localOptions, CVSTag tag, boolean isStatic) {
        super(parent, label, repository, repositoryRelativePath == null ? "CVSROOT/Emptydir" : repositoryRelativePath, tag, isStatic);
        this.localOptions = localOptions;
        this.label = label;
        this.expandable = true;
    }

    @Override
    public Command.LocalOption[] getLocalOptions() {
        return this.localOptions;
    }

    @Override
    public ICVSRemoteResource[] getMembers(CVSTag tagName, IProgressMonitor monitor) throws CVSException {
        ICVSRemoteResource[] allChildren;
        if (!this.expandable) {
            return new ICVSRemoteResource[0];
        }
        ICVSRemoteResource[] physicalChildren = this.folderInfo.getIsStatic() ? this.getChildren() : super.getMembers(tagName, monitor);
        if (this.referencedModules != null && this.referencedModules.length > 0) {
            if (physicalChildren == null) {
                allChildren = this.referencedModules;
            } else {
                allChildren = new ICVSRemoteResource[physicalChildren.length + this.referencedModules.length];
                System.arraycopy(physicalChildren, 0, allChildren, 0, physicalChildren.length);
                System.arraycopy(this.referencedModules, 0, allChildren, physicalChildren.length, this.referencedModules.length);
            }
        } else {
            allChildren = physicalChildren != null ? physicalChildren : new ICVSRemoteResource[]{};
        }
        return allChildren;
    }

    private void setReferencedModules(ICVSRemoteResource[] referencedModules) {
        this.referencedModules = referencedModules;
    }

    public boolean isAlias() {
        return Checkout.ALIAS.isElementOf(this.localOptions);
    }

    @Override
    public boolean isExpandable() {
        return this.expandable;
    }

    private void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    @Override
    public ICVSRemoteResource forTag(ICVSRemoteFolder parent, CVSTag tagName) {
        int n;
        ICVSRemoteResource[] children;
        RemoteModule r = new RemoteModule(this.label, (RemoteFolder)parent, this.getRepository(), this.folderInfo.getRepository(), this.localOptions, tagName, this.folderInfo.getIsStatic());
        r.setExpandable(this.expandable);
        if (this.folderInfo.getIsStatic() && (children = this.getChildren()) != null) {
            ArrayList<ICVSRemoteResource> taggedChildren = new ArrayList<ICVSRemoteResource>(children.length);
            ICVSRemoteResource[] iCVSRemoteResourceArray = children;
            int n2 = children.length;
            n = 0;
            while (n < n2) {
                ICVSRemoteResource resource = iCVSRemoteResourceArray[n];
                taggedChildren.add(((RemoteResource)resource).forTag(r, tagName));
                ++n;
            }
            r.setChildren(taggedChildren.toArray(new ICVSRemoteResource[taggedChildren.size()]));
        }
        if (this.referencedModules != null) {
            ArrayList<ICVSRemoteResource> taggedModules = new ArrayList<ICVSRemoteResource>(this.referencedModules.length);
            ICVSRemoteResource[] iCVSRemoteResourceArray = this.referencedModules;
            n = this.referencedModules.length;
            int n3 = 0;
            while (n3 < n) {
                ICVSRemoteResource referencedModule = iCVSRemoteResourceArray[n3];
                RemoteModule module = (RemoteModule)referencedModule;
                taggedModules.add(module.forTag(r, tagName));
                ++n3;
            }
            r.setReferencedModules(taggedModules.toArray(new ICVSRemoteResource[taggedModules.size()]));
        }
        return r;
    }

    @Override
    public boolean isDefinedModule() {
        return true;
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 instanceof RemoteModule) {
            RemoteModule module = (RemoteModule)arg0;
            return this.getName().equals(module.getName()) && super.equals(module);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() | this.getName().hashCode();
    }

    @Override
    public ICVSResource getChild(String path) throws CVSException {
        if (path.equals(".") || path.length() == 0) {
            return this;
        }
        if (this.referencedModules != null && !path.contains("/")) {
            ICVSRemoteResource[] iCVSRemoteResourceArray = this.referencedModules;
            int n = this.referencedModules.length;
            int n2 = 0;
            while (n2 < n) {
                ICVSRemoteResource referencedModule = iCVSRemoteResourceArray[n2];
                if (referencedModule.getName().equals(path)) {
                    return referencedModule;
                }
                ++n2;
            }
        }
        return super.getChild(path);
    }
}

