/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.cft.server.ui.internal.EventSource;
import org.eclipse.cft.server.ui.internal.IPartChangeListener;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.ServerValidator;
import org.eclipse.cft.server.ui.internal.ValidationStatus;
import org.eclipse.cft.server.ui.internal.wizards.WizardStatusHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;

public class ValidationEventHandler
implements IPartChangeListener {
    private ServerValidator validator;
    private Map<Integer, PartChangeEvent> trackedStatus = new HashMap<Integer, PartChangeEvent>();
    private Set<IPartChangeListener> listeners = new LinkedHashSet<IPartChangeListener>();
    private Set<WizardStatusHandler> statusHandlers = new LinkedHashSet<WizardStatusHandler>();

    public ValidationEventHandler(ServerValidator validator) {
        this.validator = validator;
    }

    public ValidationEventHandler() {
    }

    public synchronized void updateValidator(ServerValidator validator) {
        this.validator = validator;
    }

    public synchronized void addStatusHandler(WizardStatusHandler handler) {
        if (handler != null) {
            this.statusHandlers.add(handler);
        }
    }

    @Override
    public synchronized void handleChange(PartChangeEvent event) {
        if (this.validator == null || event == null) {
            return;
        }
        PartChangeEvent validationEvent = this.getValidationEvent(event);
        if (validationEvent != null) {
            this.fireValidationEvent(validationEvent);
            event = validationEvent;
        }
        this.trackEvent(event);
        this.handleStatus(event);
    }

    public synchronized void validate(IRunnableContext context) {
        this.handleChange(new PartChangeEvent(context, Status.OK_STATUS, null, 1002));
    }

    public synchronized void addValidationListener(IPartChangeListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public synchronized void removeValidationListener(IPartChangeListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized boolean isOK() {
        return this.getNextNonOKEvent() == null;
    }

    public synchronized IStatus getNextNonOKEvent() {
        PartChangeEvent event = this.getNextTrackedEvent();
        return event != null ? event.getStatus() : null;
    }

    protected void fireValidationEvent(PartChangeEvent event) {
        if (event == null) {
            return;
        }
        Object source = event.getSource() != null ? event.getSource().getSource() : null;
        for (IPartChangeListener listener : this.listeners) {
            if (source == listener) continue;
            listener.handleChange(event);
        }
    }

    protected PartChangeEvent getNextTrackedEvent() {
        Iterator<PartChangeEvent> iterator = this.trackedStatus.values().iterator();
        if (iterator.hasNext()) {
            PartChangeEvent event = iterator.next();
            return event;
        }
        return null;
    }

    protected ValidationStatus validate(IRunnableContext context, int eventType) {
        ValidationStatus status = null;
        switch (eventType) {
            case 1000: {
                status = this.validator.validate(false, false, context);
                break;
            }
            case 1002: {
                status = this.validator.validate(true, true, context);
                break;
            }
            case 1003: {
                status = this.validator.validate(false, true, context);
            }
        }
        return status;
    }

    protected void handleStatus(PartChangeEvent event) {
        PartChangeEvent errorEvent;
        if ((event == null || event.getStatus() == null || event.getStatus().isOK()) && (errorEvent = this.getNextTrackedEvent()) != null) {
            event = errorEvent;
        }
        for (WizardStatusHandler handler : this.statusHandlers) {
            handler.handleChange(event);
        }
    }

    protected PartChangeEvent getValidationEvent(PartChangeEvent event) {
        if (event.getStatus() == null || !event.getStatus().isOK()) {
            return null;
        }
        int eventType = event.getType();
        IRunnableContext context = event.getData() instanceof IRunnableContext ? (IRunnableContext)event.getData() : null;
        ValidationStatus validationStatus = this.validate(context, eventType);
        PartChangeEvent validationEvent = null;
        validationEvent = validationStatus instanceof IAdaptable ? (PartChangeEvent)((IAdaptable)validationStatus).getAdapter(PartChangeEvent.class) : new PartChangeEvent(null, validationStatus != null ? validationStatus.getStatus() : null, new EventSource<ValidationEventHandler>(this), 1003);
        return validationEvent;
    }

    protected void trackEvent(PartChangeEvent event) {
        IStatus status = event.getStatus();
        if (status != null) {
            if (!status.isOK()) {
                this.trackedStatus.put(event.getType(), event);
            } else {
                this.trackedStatus.remove(event.getType());
            }
        }
    }
}

