/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndicationWithMonitoring;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class ReplicateRepositoryRawIndication
extends CDOServerReadIndicationWithMonitoring {
    private int lastReplicatedBranchID;
    private long lastReplicatedCommitTime;

    public ReplicateRepositoryRawIndication(CDOServerProtocol protocol) {
        super(protocol, (short)43);
    }

    protected int getIndicatingWorkPercent() {
        return 1;
    }

    @Override
    protected void indicating(CDODataInput in, OMMonitor monitor) throws IOException {
        try {
            monitor.begin();
            this.lastReplicatedBranchID = in.readXInt();
            this.lastReplicatedCommitTime = in.readXLong();
        }
        finally {
            monitor.done();
        }
    }

    @Override
    protected void responding(CDODataOutput out, OMMonitor monitor) throws IOException {
        try {
            monitor.begin();
            OMMonitor.Async async = monitor.forkAsync();
            try {
                InternalRepository repository = this.getRepository();
                repository.replicateRaw(out, this.lastReplicatedBranchID, this.lastReplicatedCommitTime);
            }
            finally {
                async.stop();
            }
        }
        finally {
            monitor.done();
        }
    }
}

