/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.io.IOException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.ITraceMe;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

abstract class AbstractPoly
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath,
ITraceMe {
    private static final int EMF_POINT_COUNT_OFFSET = 16;
    private static final int EMF_POINT_ARRAY_START = 20;
    private static final int WMF_POINT_COUNT_OFFSET = 0;
    private static final int WMF_POINT_ARRAY_START = 2;
    private int m_count = 0;
    private int[] m_xPoints = null;
    private int[] m_yPoints = null;
    private boolean m_b16Bits = true;
    protected int[] m_xPointsConv = null;
    protected int[] m_yPointsConv = null;

    public AbstractPoly(boolean b16Bits) {
        this.m_b16Bits = b16Bits;
    }

    @Override
    public void readWMFRecord(Record emr) throws IOException {
        this.m_count = emr.getShortAt(0);
        this.readPoly(emr, 2);
    }

    @Override
    public void readEMFRecord(Record emr) throws IOException {
        this.m_count = emr.getIntAt(16);
        this.readPoly(emr, 20);
    }

    protected int getCount() {
        return this.m_count;
    }

    protected int[] getXPoints() {
        return this.m_xPoints;
    }

    protected int[] getYPoints() {
        return this.m_yPoints;
    }

    private boolean readPoly(Record emr, int pointOffset) throws IOException {
        this.m_xPoints = new int[this.m_count];
        this.m_yPoints = new int[this.m_count];
        int curPos = pointOffset;
        int i = 0;
        while (i < this.m_count) {
            if (this.m_b16Bits) {
                this.m_xPoints[i] = emr.getShortAt(curPos);
                this.m_yPoints[i] = emr.getShortAt(curPos + 2);
                curPos += 4;
            } else {
                this.m_xPoints[i] = emr.getIntAt(curPos);
                this.m_yPoints[i] = emr.getIntAt(curPos + 4);
                curPos += 8;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("cnt=" + this.m_count);
        this.dumpPoints(sb, ", Converted:", this.m_xPointsConv, this.m_yPointsConv);
        this.dumpPoints(sb, ", Original:", this.m_xPoints, this.m_yPoints);
        return sb.toString();
    }

    private void dumpPoints(StringBuffer sb, String what, int[] x, int[] y) {
        sb.append(what);
        if (x == null || y == null) {
            sb.append(" (null)");
        } else {
            int ix = 0;
            while (ix < this.m_count) {
                sb.append(" (" + x[ix] + ',' + y[ix] + ')');
                ++ix;
            }
        }
    }
}

