/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug.internal.breakpoints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;

public class OTBreakpoints {
    private static final String DEBUG_HOOKS = "org.eclipse.objectteams.runtime.DebugHooks";
    private static final int LINE_afterRedefineClasses = 30;

    public static enum Descriptor {
        TeamConstructor(".TeamBreakpoint.Constructor", 63),
        TeamActivate(".TeamBreakpoint.ActivateMethod", 166),
        TeamDeactivate(".TeamBreakpoint.DeactivateMethod", 197),
        TeamImplicitActivate(".TeamBreakpoint.ImplicitActivateMethod", 244),
        TeamImplicitDeactivate(".TeamBreakpoint.ImplicitDeactivateMethod", 279),
        TeamFinalize(".TeamBreakpoint.FinalizeMethod", 494),
        RedefineClasses(".InstrumentationBreakpoint.redefineClasses", 30){

            @Override
            public boolean isOOTBreakPoint() {
                return false;
            }

            @Override
            public String getTypeName() {
                return OTBreakpoints.DEBUG_HOOKS;
            }
        };

        String BP_ID;
        int lineNumber;

        private Descriptor(String id, int lineNumber) {
            this.BP_ID = "org.eclipse.objectteams.otdt.debug" + id;
            this.lineNumber = lineNumber;
        }

        public boolean isOOTBreakPoint() {
            return true;
        }

        public boolean matches(IBreakpoint breakpoint) throws CoreException {
            return breakpoint.getMarker().getAttribute(this.BP_ID) != null;
        }

        public String getTypeName() {
            return String.valueOf(IOTConstants.STR_ORG_OBJECTTEAMS_TEAM);
        }

        public void insertInto(IType type, Map<String, IBreakpoint> collected) throws CoreException {
            if (!collected.containsKey(this.BP_ID)) {
                collected.put(this.BP_ID, this.createBreakpoint(type));
            }
        }

        Map<String, Boolean> getBreakpointAttributes() {
            HashMap<String, Boolean> attrs = new HashMap<String, Boolean>();
            attrs.put("org.eclipse.objectteams.otdt.debug.SyntheticBreakpoint", Boolean.TRUE);
            return attrs;
        }

        IBreakpoint createBreakpoint(IType oot) throws CoreException {
            Map<String, Boolean> attributes = this.getBreakpointAttributes();
            attributes.put(this.BP_ID, Boolean.TRUE);
            return this.createLineBreakpoint(oot, this.lineNumber, attributes);
        }

        private IBreakpoint createLineBreakpoint(IType oot, int linenumber, Map attributes) throws CoreException {
            IResource teamResource = oot.getJavaProject().getResource();
            IJavaLineBreakpoint breakpoint = JDIDebugModel.createLineBreakpoint((IResource)teamResource, (String)oot.getFullyQualifiedName(), (int)linenumber, (int)-1, (int)-1, (int)0, (boolean)false, (Map)attributes);
            breakpoint.setPersisted(false);
            return breakpoint;
        }
    }
}

