/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractMethodMappingDeclaration;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CallinMappingDeclaration;
import org.eclipse.jdt.core.dom.CalloutMappingDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodSpec;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RoleTypeDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.jdt.internal.ui.text.correction.proposals.ChangeMethodSignatureProposal;
import org.eclipse.jdt.internal.ui.text.correction.proposals.LinkedCorrectionProposal;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ICommandAccess;
import org.eclipse.objectteams.otdt.internal.ui.assist.OTQuickFixes;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.ChangeModifierProposalSubProcessor;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.JavadocProposalSubProcessor;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.MappingProposalSubProcessor;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.PrecedenceProposalSubProcessor;
import org.eclipse.objectteams.otdt.internal.ui.text.correction.TypeProposalSubProcessor;
import org.eclipse.swt.graphics.Image;

public class QuickFixProcessor
implements IQuickFixProcessor {
    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        switch (problemId) {
            case 112102: 
            case 112103: 
            case 112104: 
            case 112107: 
            case 112108: 
            case 112202: 
            case 112207: 
            case 112209: 
            case 112210: 
            case 113105: 
            case 113111: 
            case 113112: 
            case 115002: 
            case 121210: 
            case 121211: 
            case 125001: 
            case 125002: 
            case 131004: 
            case 131005: 
            case 131008: 
            case 131009: 
            case 131014: 
            case 131015: 
            case 135012: 
            case 135013: 
            case 141005: 
            case 141006: 
            case 141008: 
            case 142005: 
            case 142006: 
            case 142007: 
            case 142008: 
            case 147001: 
            case 147002: 
            case 148001: 
            case 149001: 
            case 203303: {
                return true;
            }
            case 112506: 
            case 123403: {
                return true;
            }
        }
        return false;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        if (locations == null || locations.length == 0) {
            return null;
        }
        HashSet<Integer> handledProblems = new HashSet<Integer>(locations.length);
        ArrayList<ICommandAccess> resultingCollections = new ArrayList<ICommandAccess>();
        int i = 0;
        while (i < locations.length) {
            IProblemLocation curr = locations[i];
            Integer id = new Integer(curr.getProblemId());
            if (handledProblems.add(id)) {
                this.process(context, curr, resultingCollections);
            }
            ++i;
        }
        return resultingCollections.toArray(new IJavaCompletionProposal[resultingCollections.size()]);
    }

    private void process(IInvocationContext context, IProblemLocation problem, Collection<ICommandAccess> proposals) throws CoreException {
        int id = problem.getProblemId();
        if (id == 0) {
            return;
        }
        ICompilationUnit cu = context.getCompilationUnit();
        ASTNode selectedNode = problem.getCoveringNode(context.getASTRoot());
        if (selectedNode == null) {
            return;
        }
        ASTNode enclosingType = ASTResolving.findParentType((ASTNode)selectedNode);
        TypeDeclaration parentType = null;
        try {
            if (enclosingType != null) {
                parentType = (TypeDeclaration)ASTResolving.findParentType((ASTNode)enclosingType.getParent());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        ICommandAccess javaProposal = null;
        try {
            switch (id) {
                case 121210: {
                    javaProposal = TypeProposalSubProcessor.getMakeImportBase(selectedNode, cu);
                    break;
                }
                case 121211: {
                    javaProposal = TypeProposalSubProcessor.getImportBaseclass(selectedNode, cu);
                    break;
                }
                case 115002: {
                    if (parentType != null && parentType instanceof RoleTypeDeclaration) {
                        proposals.add((ICommandAccess)ChangeModifierProposalSubProcessor.getMakeTypeTeamProposal(cu, (RoleTypeDeclaration)parentType, 5));
                    }
                    break;
                }
                case 125001: 
                case 125002: {
                    if (parentType != null) {
                        proposals.add((ICommandAccess)ChangeModifierProposalSubProcessor.getMakeTypeAbstractProposal(cu, parentType, 8));
                    }
                    break;
                }
                case 112102: {
                    if (enclosingType instanceof RoleTypeDeclaration) {
                        RoleTypeDeclaration roleTypeDecl = (RoleTypeDeclaration)enclosingType;
                        proposals.add(ChangeModifierProposalSubProcessor.getChangeRoleVisibilityProposal(cu, roleTypeDecl, 4));
                        proposals.add(ChangeModifierProposalSubProcessor.getChangeRoleVisibilityProposal(cu, roleTypeDecl, 1));
                    }
                    break;
                }
                case 113111: {
                    RoleTypeDeclaration roleTypeDecl;
                    ITypeBinding[] tsupers;
                    if (enclosingType instanceof RoleTypeDeclaration && (tsupers = (roleTypeDecl = (RoleTypeDeclaration)enclosingType).resolveBinding().getSuperRoles()) != null) {
                        if (tsupers.length == 0) break;
                        int inheritedModifiers = tsupers[0].getModifiers() & 7;
                        proposals.add(ChangeModifierProposalSubProcessor.getChangeRoleVisibilityProposal(cu, roleTypeDecl, inheritedModifiers));
                    }
                    break;
                }
                case 113105: {
                    OTQuickFixes.instance().addOverrideAnnotationProposal(context, problem, proposals);
                    break;
                }
                case 131004: 
                case 141005: 
                case 141008: {
                    MappingProposalSubProcessor.addUnresolvedMethodSpecProposals(selectedNode, (TypeDeclaration)enclosingType, context, problem, proposals);
                    MappingProposalSubProcessor.getRemoveMethodMappingSignaturesProposal(cu, selectedNode, 10, proposals);
                    break;
                }
                case 131005: 
                case 141006: {
                    MappingProposalSubProcessor.getAddMethodMappingSignaturesProposal(cu, selectedNode, 10, proposals);
                    break;
                }
                case 131008: {
                    CalloutMappingDeclaration calloutMapping = (CalloutMappingDeclaration)QuickFixProcessor.getEnclosingMethodMapping(selectedNode);
                    if (calloutMapping != null) {
                        proposals.add(ChangeModifierProposalSubProcessor.getChangeCalloutKindProposal(cu, calloutMapping, true));
                    }
                    break;
                }
                case 131009: {
                    CalloutMappingDeclaration calloutMapping = (CalloutMappingDeclaration)QuickFixProcessor.getEnclosingMethodMapping(selectedNode);
                    if (calloutMapping != null) {
                        proposals.add(ChangeModifierProposalSubProcessor.getChangeCalloutKindProposal(cu, calloutMapping, false));
                    }
                    break;
                }
                case 142005: {
                    CallinMappingDeclaration callinMapping = (CallinMappingDeclaration)QuickFixProcessor.getEnclosingMethodMapping(selectedNode);
                    if (callinMapping != null) {
                        IMethodBinding roleMethod = ((MethodSpec)callinMapping.getRoleMappingElement()).resolveBinding();
                        ICommandAccess proposal = ChangeModifierProposalSubProcessor.getChangeMethodModifierProposal(context, null, roleMethod, Integer.MIN_VALUE, true);
                        if (proposal != null) {
                            proposals.add(proposal);
                        }
                        proposals.add(ChangeModifierProposalSubProcessor.getAddOrChangeCallinModifierProposal(cu, callinMapping));
                    }
                    break;
                }
                case 142006: {
                    CallinMappingDeclaration callinMapping = (CallinMappingDeclaration)QuickFixProcessor.getEnclosingMethodMapping(selectedNode);
                    if (callinMapping != null) {
                        IMethodBinding roleMethod = ((MethodSpec)callinMapping.getRoleMappingElement()).resolveBinding();
                        ICommandAccess proposal = ChangeModifierProposalSubProcessor.getChangeMethodModifierProposal(context, null, roleMethod, Integer.MIN_VALUE, false);
                        if (proposal != null) {
                            proposals.add(proposal);
                        }
                        proposals.add(ChangeModifierProposalSubProcessor.getAddOrChangeCallinModifierProposal(cu, callinMapping));
                    }
                    break;
                }
                case 142008: {
                    ICommandAccess proposal;
                    if (selectedNode instanceof MethodDeclaration && (proposal = ChangeModifierProposalSubProcessor.getChangeMethodModifierProposal(context, (MethodDeclaration)selectedNode, null, Integer.MIN_VALUE, true)) != null) {
                        proposals.add(proposal);
                    }
                    break;
                }
                case 142007: {
                    ICommandAccess proposal;
                    if (selectedNode instanceof MethodDeclaration && (proposal = ChangeModifierProposalSubProcessor.getChangeMethodModifierProposal(context, (MethodDeclaration)selectedNode, null, Integer.MIN_VALUE, false)) != null) {
                        proposals.add(proposal);
                    }
                    break;
                }
                case 147001: {
                    MethodSpec roleMSpec;
                    ICommandAccess proposal;
                    CallinMappingDeclaration callinMapping = (CallinMappingDeclaration)QuickFixProcessor.getEnclosingMethodMapping(selectedNode);
                    if (callinMapping != null && (proposal = ChangeModifierProposalSubProcessor.getChangeMethodModifierProposal(context, null, (roleMSpec = (MethodSpec)callinMapping.getRoleMappingElement()).resolveBinding(), 8, true)) != null) {
                        proposals.add(proposal);
                    }
                    break;
                }
                case 147002: {
                    MethodSpec roleMSpec;
                    ICommandAccess proposal;
                    CallinMappingDeclaration callinMapping = (CallinMappingDeclaration)QuickFixProcessor.getEnclosingMethodMapping(selectedNode);
                    if (callinMapping != null && (proposal = ChangeModifierProposalSubProcessor.getChangeMethodModifierProposal(context, null, (roleMSpec = (MethodSpec)callinMapping.getRoleMappingElement()).resolveBinding(), 8, false)) != null) {
                        proposals.add(proposal);
                    }
                    break;
                }
                case 203303: {
                    CallinMappingDeclaration callinMapping = (CallinMappingDeclaration)QuickFixProcessor.getEnclosingMethodMapping(selectedNode);
                    if (callinMapping != null) {
                        proposals.add(ChangeModifierProposalSubProcessor.getAddOrChangeCallinModifierProposal(cu, callinMapping));
                    }
                    break;
                }
                case 148001: {
                    if (enclosingType != null) {
                        PrecedenceProposalSubProcessor processor = new PrecedenceProposalSubProcessor(cu, enclosingType);
                        ICommandAccess proposal = processor.getAddBindingPrecedenceProposal((TypeDeclaration)enclosingType, problem.getProblemArguments());
                        if (proposal != null) {
                            proposals.add(proposal);
                        }
                        if (parentType != null) {
                            proposal = processor.getAddBindingPrecedenceToTeamProposal(parentType, problem.getProblemArguments());
                            if (proposal != null) {
                                proposals.add(proposal);
                            }
                            if ((proposal = processor.getAddRolePrecedenceToTeamProposal(parentType, problem.getProblemArguments())) != null) {
                                proposals.add(proposal);
                            }
                        }
                    }
                    break;
                }
                case 149001: {
                    javaProposal = MappingProposalSubProcessor.addTypeParameterToCallin(cu, selectedNode, (TypeDeclaration)enclosingType);
                    break;
                }
                case 112207: {
                    javaProposal = this.getMigratePathSyntaxProposal(cu, selectedNode);
                    break;
                }
                case 112209: 
                case 112210: {
                    javaProposal = ChangeModifierProposalSubProcessor.changeAnchorToFinalProposal(cu, selectedNode);
                    break;
                }
                case 112107: 
                case 112108: {
                    try {
                        OTQuickFixes.publicRequested = true;
                        ModifierCorrectionSubProcessor.addNonAccessibleReferenceProposal((IInvocationContext)context, (IProblemLocation)problem, proposals, (int)2, (int)10);
                        break;
                    }
                    finally {
                        OTQuickFixes.publicRequested = false;
                    }
                }
                case 112103: 
                case 112104: {
                    ModifierCorrectionSubProcessor.addNonAccessibleReferenceProposal((IInvocationContext)context, (IProblemLocation)problem, proposals, (int)2, (int)10);
                    break;
                }
                case 113112: {
                    ModifierCorrectionSubProcessor.addChangeOverriddenModifierProposal((IInvocationContext)context, (IProblemLocation)problem, proposals, (int)2);
                    break;
                }
                case 112202: {
                    VariableDeclarationStatement variable;
                    if (selectedNode instanceof VariableDeclarationStatement && (selectedNode = (variable = (VariableDeclarationStatement)selectedNode).getType()) instanceof SimpleType) {
                        SimpleType typeNode = (SimpleType)selectedNode;
                        selectedNode = typeNode.getName();
                    }
                    if (selectedNode instanceof Name) {
                        ITypeBinding teamType;
                        Name typeName = (Name)selectedNode;
                        ITypeBinding roleType = typeName.resolveTypeBinding();
                        if (roleType == null || (teamType = roleType.getDeclaringClass()) == null) break;
                        proposals.add((ICommandAccess)TypeProposalSubProcessor.changeTypeToAnchored(cu, roleType.getQualifiedName(), typeName, teamType.getQualifiedName()));
                    }
                    break;
                }
                case 135012: {
                    javaProposal = MappingProposalSubProcessor.getChangeAssignmentToCalloutCallProposal(cu, (TypeDeclaration)enclosingType, selectedNode);
                    break;
                }
                case 135013: {
                    javaProposal = MappingProposalSubProcessor.getChangeFieldReadToCalloutCallProposal(cu, (TypeDeclaration)enclosingType, selectedNode);
                    break;
                }
                case 131015: {
                    javaProposal = MappingProposalSubProcessor.getMaterializeInferredCalloutSelfCallProposal(cu, (TypeDeclaration)enclosingType, (MethodInvocation)selectedNode);
                    break;
                }
                case 131014: {
                    javaProposal = MappingProposalSubProcessor.getMaterializeInferredCalloutsInheritedProposal(cu, (TypeDeclaration)enclosingType, selectedNode);
                    break;
                }
                case 112506: {
                    javaProposal = JavadocProposalSubProcessor.addRoleTag(cu, problem.getProblemArguments(), (TypeDeclaration)enclosingType);
                    break;
                }
                case 123403: {
                    this.addUncaughtExceptionProposal(context, problem, selectedNode, proposals);
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (javaProposal != null) {
            proposals.add(javaProposal);
        }
    }

    static AbstractMethodMappingDeclaration getEnclosingMethodMapping(ASTNode current) {
        while (current != null) {
            switch (current.getNodeType()) {
                case 105: 
                case 106: {
                    return (AbstractMethodMappingDeclaration)current;
                }
                case 15: 
                case 55: 
                case 113: {
                    return null;
                }
            }
            current = current.getParent();
        }
        return null;
    }

    private ASTRewriteCorrectionProposal getMigratePathSyntaxProposal(ICompilationUnit cu, ASTNode selectedNode) {
        ArrayType type;
        if (selectedNode instanceof SingleVariableDeclaration) {
            selectedNode = ((SingleVariableDeclaration)selectedNode).getType();
        }
        ASTNode oldType = selectedNode;
        AST ast = oldType.getAST();
        String prefixPath = null;
        SimpleName typeName = null;
        int dimensions = 0;
        if (selectedNode.getNodeType() == 5) {
            type = (ArrayType)selectedNode;
            dimensions = type.getDimensions();
            oldType = type.getElementType();
        }
        if (oldType.getNodeType() == 43) {
            type = (SimpleType)oldType;
            oldType = type.getName();
        }
        if (oldType.getNodeType() == 40) {
            QualifiedName name = (QualifiedName)oldType;
            prefixPath = name.getQualifier().toString();
            typeName = name.getName();
        } else if (oldType.getNodeType() == 75) {
            type = (QualifiedType)oldType;
            prefixPath = type.getQualifier().toString();
            typeName = type.getName();
        }
        if (prefixPath != null) {
            if (prefixPath.equals("base")) {
                prefixPath = String.valueOf(this.baseQualifier(selectedNode, typeName)) + prefixPath;
            }
            SimpleType simpleType = ast.newSimpleType((Name)ASTNode.copySubtree((AST)ast, (ASTNode)typeName));
            ParameterizedType paramType = ast.newParameterizedType((Type)simpleType);
            paramType.typeArguments().add(ast.newTypeAnchor(ast.newName(prefixPath)));
            ParameterizedType newType = dimensions == 0 ? paramType : ast.newArrayType((Type)paramType, dimensions);
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            rewrite.replace(selectedNode, (ASTNode)newType, null);
            return new ASTRewriteCorrectionProposal(Messages.format((String)CorrectionMessages.OTQuickfix_migrateroletypesyntax_description, null), cu, rewrite, 17, JavaPluginImages.get((String)"org.eclipse.jdt.ui.correction_change.gif"));
        }
        return null;
    }

    private String baseQualifier(ASTNode selectedNode, SimpleName typeName) {
        RoleTypeDeclaration enclType = null;
        ASTNode current = selectedNode;
        while (enclType == null && current != null) {
            if (!((current = current.getParent()) instanceof RoleTypeDeclaration)) continue;
            enclType = (RoleTypeDeclaration)current;
        }
        RoleTypeDeclaration currentType = enclType;
        int depth = 0;
        while (currentType != null) {
            ITypeBinding baseclass = currentType.getBaseClassType().resolveBinding();
            while (baseclass != null) {
                ITypeBinding[] iTypeBindingArray = baseclass.getDeclaredTypes();
                int n = iTypeBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypeBinding member = iTypeBindingArray[n2];
                    if (member.getName().equals(typeName.getIdentifier())) {
                        if (depth <= 0) break;
                        return currentType.getName() + ".";
                    }
                    ++n2;
                }
                baseclass = baseclass.getSuperclass();
            }
            if (!(currentType.getParent() instanceof RoleTypeDeclaration)) break;
            currentType = (RoleTypeDeclaration)currentType.getParent();
            ++depth;
        }
        return "";
    }

    private void addUncaughtExceptionProposal(IInvocationContext context, IProblemLocation problem, ASTNode selectedNode, Collection<ICommandAccess> proposals) {
        IMethodBinding overriddenMethod;
        boolean isApplicable;
        while (selectedNode != null && !(selectedNode instanceof MethodDeclaration)) {
            selectedNode = selectedNode.getParent();
        }
        if (selectedNode == null) {
            return;
        }
        MethodDeclaration methodDecl = (MethodDeclaration)selectedNode;
        ICompilationUnit cu = context.getCompilationUnit();
        CompilationUnit astRoot = context.getASTRoot();
        IMethodBinding binding = methodDecl.resolveBinding();
        boolean bl = isApplicable = binding != null;
        if (isApplicable && (overriddenMethod = Bindings.findOverriddenMethod((IMethodBinding)binding, (boolean)true)) != null) {
            isApplicable = overriddenMethod.getDeclaringClass().isFromSource();
        }
        if (isApplicable) {
            ITypeBinding uncaughtException = astRoot.getAST().resolveWellKnownType("org.objectteams.LiftingFailedException");
            ChangeMethodSignatureProposal.ChangeDescription[] desc = new ChangeMethodSignatureProposal.ChangeDescription[]{new ChangeMethodSignatureProposal.InsertDescription(uncaughtException, "")};
            String label = org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages.LocalCorrectionsSubProcessor_addthrows_description;
            Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.jexception_obj.gif");
            ChangeMethodSignatureProposal proposal = new ChangeMethodSignatureProposal(label, cu, (ASTNode)astRoot, binding, null, desc, 8, image);
            QuickFixProcessor.addExceptionTypeLinkProposals((LinkedCorrectionProposal)proposal, uncaughtException, proposal.getExceptionTypeGroupId(1));
            proposal.setCommandId("org.eclipse.objectteams.otdt.jdt.ui.correction.addThrowsDecl");
            proposals.add((ICommandAccess)proposal);
        }
    }

    private static void addExceptionTypeLinkProposals(LinkedCorrectionProposal proposal, ITypeBinding exc, String key) {
        while (exc != null && !"java.lang.Object".equals(exc.getQualifiedName())) {
            proposal.addLinkedPositionProposal(key, exc);
            exc = exc.getSuperclass();
        }
    }
}

