/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.dialog.PasteImportStatusDialog;
import org.eclipse.papyrus.infra.nattable.manager.AbstractPasteImportInsertInNattableManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.provider.PasteInSelectionNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.provider.PasteInSelectionTreeNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.provider.PasteNattableCommandProvider;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.PapyrusNattableStatus;
import org.eclipse.papyrus.infra.nattable.utils.PasteEnablementStatus;
import org.eclipse.papyrus.infra.nattable.utils.PasteModeEnumeration;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractInsertImportInNattableManager
extends AbstractPasteImportInsertInNattableManager {
    public AbstractInsertImportInNattableManager(INattableModelManager tableManager, CSVPasteHelper pasteHelper, boolean useProgressMonitorDialog, boolean openDialog, int preferredUserAction) {
        this(tableManager, pasteHelper, useProgressMonitorDialog, openDialog, preferredUserAction, null);
    }

    public AbstractInsertImportInNattableManager(INattableModelManager tableManager, CSVPasteHelper pasteHelper, boolean useProgressMonitorDialog, boolean openDialog, int preferredUserAction, TableSelectionWrapper tableSelectionWrapper) {
        super(tableManager, pasteHelper, useProgressMonitorDialog, openDialog, preferredUserAction, tableSelectionWrapper);
    }

    @Override
    public IStatus doAction() {
        Status resultStatus = new Status(4, "org.eclipse.papyrus.infra.nattable", Messages.InsertInNattableManager_InsertNotYetManaged);
        PasteEnablementStatus pasteStatus = null;
        int maxDepth = Integer.MAX_VALUE;
        pasteStatus = this.findPasteModeFromTableConfiguration(this.tableManager);
        if (PasteModeEnumeration.PASTE_NO_CONFIGURATION != pasteStatus.getPasteMode() && PasteModeEnumeration.CANT_PASTE != pasteStatus.getPasteMode()) {
            pasteStatus = AbstractInsertImportInNattableManager.findPasteConfigurationAxisIdentifier(this.tableManager);
        }
        if (pasteStatus.getPasteMode() == PasteModeEnumeration.PASTE_EOBJECT_ROW_OR_COLUMN) {
            boolean value = MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)PasteImportStatusDialog.DIALOG_TITLE, (String)Messages.AbstractPasteImportInsertInNattableManager_WhatAreYouPasting);
            if (value) {
                pasteStatus.getColumnStatus().add((IStatus)new Status(8, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_TheUserChosesToPasteRows));
            } else {
                pasteStatus.getRowStatus().add((IStatus)new Status(8, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_TheUserChosesToPasteColumns));
            }
        }
        PasteModeEnumeration pasteMode = pasteStatus.getPasteMode();
        switch (pasteMode) {
            case PASTE_NO_CONFIGURATION: {
                resultStatus = new PapyrusNattableStatus(22, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_NoPasteConfiguration2);
                break;
            }
            case CANT_PASTE: {
                resultStatus = this.createCantInsertStatus(pasteStatus);
                break;
            }
            case PASTE_EOBJECT_ROW: {
                resultStatus = this.insertRow(this.tableManager, pasteStatus, this.pasteHelper, maxDepth);
                break;
            }
            case PASTE_EOBJECT_COLUMN: 
            case PASTE_EOBJECT_ROW_OR_COLUMN: {
                break;
            }
        }
        return resultStatus;
    }

    protected IStatus createCantInsertStatus(PasteEnablementStatus pasteStatus) {
        PapyrusNattableStatus resultStatus = new PapyrusNattableStatus(22, "org.eclipse.papyrus.infra.nattable", Messages.AbstractPasteImportInsertInNattableManager_NoPasteConfiguration2);
        MultiStatus rowStatus = pasteStatus.getRowStatus();
        MultiStatus columnStatus = pasteStatus.getColumnStatus();
        if (rowStatus == null && columnStatus != null) {
            resultStatus = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", this.getFirstNonOKStatus((IStatus)columnStatus).getMessage());
        } else if (columnStatus == null && rowStatus != null) {
            resultStatus = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", this.getFirstNonOKStatus((IStatus)rowStatus).getMessage());
        } else if (columnStatus != null && rowStatus != null) {
            StringBuffer buffer = new StringBuffer(Messages.AbstractPasteImportInsertInNattableManager_NoPasteConfiguration);
            buffer.append(Messages.InsertInNattableManager_InsertRowsError);
            buffer.append(this.getFirstNonOKStatus((IStatus)rowStatus).getMessage());
            buffer.append(Messages.InsertInNattableManager_InsertColumnsError);
            buffer.append(this.getFirstNonOKStatus((IStatus)columnStatus).getMessage());
            resultStatus = new PapyrusNattableStatus(100, "org.eclipse.papyrus.infra.nattable", buffer.toString());
        }
        return resultStatus;
    }

    private IStatus insertRow(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper, int maxDepth) {
        IStatus resultStatus = Status.OK_STATUS;
        resultStatus = TableHelper.isTreeTable(manager) ? (this.tableSelectionWrapper != null ? this.insertTreeRows(manager, pasteStatus, pasteHelper, this.tableSelectionWrapper) : this.insertTreeRows(manager, pasteStatus, pasteHelper, maxDepth)) : (this.tableSelectionWrapper != null ? this.insertNormalRows(manager, pasteStatus, pasteHelper, this.tableSelectionWrapper) : this.insertNormalRows(manager, pasteStatus, pasteHelper));
        return resultStatus;
    }

    private IStatus insertTreeRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper, TableSelectionWrapper tableSelectionWrapper) {
        IStatus status = Status.OK_STATUS;
        if (status.isOK()) {
            status = this.insertTree(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), tableSelectionWrapper, this.getDataSize());
        }
        return status;
    }

    private IStatus insertTreeRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper, int maxDepth) {
        IStatus status = this.checkTreeTableConfiguration(manager, maxDepth);
        if (status.isOK()) {
            status = this.insertTree(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), null, this.getDataSize());
        }
        return status;
    }

    private IStatus insertNormalRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper) {
        Reader reader = this.createReader();
        IStatus status = this.verifyColumnCountOnFirstLine(manager, reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        if (status.isOK()) {
            status = this.insert(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), null, this.getDataSize());
        }
        return status;
    }

    private IStatus insertNormalRows(INattableModelManager manager, PasteEnablementStatus pasteStatus, CSVPasteHelper pasteHelper, TableSelectionWrapper tableSelectionWrapper) {
        Reader reader = this.createReader();
        IStatus status = this.verifyColumnCountOnFirstLine(manager, reader);
        try {
            reader.close();
        }
        catch (IOException e) {
            Activator.log.error((Throwable)e);
        }
        if (status.isOK()) {
            status = this.insert(manager, pasteStatus, this.useProgressMonitorDialog, this.createReader(), tableSelectionWrapper, this.getDataSize());
        }
        return status;
    }

    private IStatus insertTree(INattableModelManager manager, PasteEnablementStatus status, boolean useProgressMonitorDialog, Reader reader, TableSelectionWrapper tableSelectionWrapper, long totalSize) {
        IStatus resultStatus = Status.OK_STATUS;
        PasteNattableCommandProvider commandProvider = null;
        switch (status.getPasteMode()) {
            case PASTE_EOBJECT_ROW: {
                commandProvider = new PasteInSelectionTreeNattableCommandProvider(manager, false, true, reader, this.pasteHelper, this.tableSelectionWrapper, this.preferredUserAction, totalSize);
                break;
            }
        }
        if (commandProvider != null) {
            resultStatus = commandProvider.executePasteFromStringCommand(useProgressMonitorDialog, this.openDialog);
        }
        return resultStatus;
    }

    private IStatus insert(INattableModelManager manager, PasteEnablementStatus status, boolean useProgressMonitorDialog, Reader reader, TableSelectionWrapper tableSelectionWrapper, long totalSize) {
        IStatus resultStatus = Status.OK_STATUS;
        PasteNattableCommandProvider commandProvider = null;
        switch (status.getPasteMode()) {
            case PASTE_EOBJECT_ROW: {
                commandProvider = new PasteInSelectionNattableCommandProvider(manager, false, true, reader, this.pasteHelper, tableSelectionWrapper, this.preferredUserAction, totalSize);
                break;
            }
        }
        if (commandProvider != null) {
            resultStatus = commandProvider.executePasteFromStringCommand(useProgressMonitorDialog, this.openDialog);
        }
        return resultStatus;
    }
}

