/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.core.editorHelp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionPrototypeSummaryImpl;
import org.eclipse.ptp.pldt.common.editorHelp.FunctionSummaryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPIDocXMLParser {
    public static void main(String[] args) {
        File file = new File(args[0]);
        try {
            List<FunctionSummaryImpl> functions = MPIDocXMLParser.parseDOM(new FileInputStream(file), "cname");
            System.out.println("num of functions gathered: " + functions.size());
            System.out.println("first function summary:");
            System.out.println(functions.iterator().next());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static List<FunctionSummaryImpl> parseDOM(InputStream xmlIn, String cOrCppName) {
        ArrayList<FunctionSummaryImpl> mpiFuncList = new ArrayList<FunctionSummaryImpl>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (xmlIn != null) {
                document = builder.parse(xmlIn);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (document != null) {
            NodeList functionList = document.getElementsByTagName("function");
            int i = 0;
            while (i < functionList.getLength()) {
                Node func = functionList.item(i);
                NodeList child = func.getChildNodes();
                String cname = null;
                String desc = null;
                FunctionPrototypeSummaryImpl prototypeSummary = null;
                int j = 0;
                while (j < child.getLength()) {
                    Node sub = child.item(j);
                    if (sub.getNodeName().equals(cOrCppName)) {
                        cname = sub.getTextContent();
                    } else if (sub.getNodeName().equals("description")) {
                        desc = sub.getTextContent();
                    } else if (sub.getNodeName().equals("prototype")) {
                        NodeList protoSub = sub.getChildNodes();
                        prototypeSummary = new FunctionPrototypeSummaryImpl(protoSub.item(3).getTextContent(), protoSub.item(1).getTextContent(), protoSub.item(5).getTextContent());
                    }
                    ++j;
                }
                FunctionSummaryImpl functionSummary = new FunctionSummaryImpl(cname, "", desc, prototypeSummary, null);
                mpiFuncList.add(functionSummary);
                ++i;
            }
        }
        return mpiFuncList;
    }
}

