/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.proxy.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.ptp.proxy.util.BitSetIterable;
import org.eclipse.ptp.proxy.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeSet
implements Iterable<String> {
    private final ArrayList<Range> rangeList = new ArrayList(0);
    private Iterator<Range> rangeListIter;
    private Iterator<String> rangeIter;

    public RangeSet() {
    }

    public RangeSet(BitSet indices) {
        int firstVal;
        if (indices.isEmpty()) {
            return;
        }
        BitSetIterable iitb = new BitSetIterable(indices);
        Iterator<Integer> iit = iitb.iterator();
        int low = firstVal = iit.next().intValue();
        int high = firstVal;
        while (iit.hasNext()) {
            int val = iit.next();
            if (val == high + 1) {
                ++high;
                continue;
            }
            this.add(low, high);
            low = val;
            high = val;
        }
        this.add(low, high);
    }

    public RangeSet(int val) {
        this(val, val);
    }

    public RangeSet(int min, int max) {
        this.rangeList.add(new Range(min, max));
    }

    public RangeSet(String str) {
        if (str != null) {
            String[] ranges;
            String[] stringArray = ranges = str.split(",");
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                String range = stringArray[n2];
                String[] vals = range.split("-");
                if (vals.length == 1) {
                    this.add(Integer.parseInt(vals[0]));
                } else {
                    this.add(Integer.parseInt(vals[0]), Integer.parseInt(vals[1]));
                }
                ++n2;
            }
        }
    }

    public BitSet getBits() {
        BitSet bits = new BitSet(this.size());
        for (Range r : this.rangeList) {
            bits.set(r.getMinValue(), r.getMaxValue());
        }
        return bits;
    }

    public void add(int val) {
        int pos = 0;
        if (this.rangeList.size() > 0) {
            pos = this.findIndex(val);
            if (pos >= 0) {
                return;
            }
            pos = -(pos + 1);
        }
        this.rangeList.add(pos, new Range(val));
        this.fixupRanges();
    }

    public void add(int min, int max) {
        this.internalAdd(min, max);
        this.fixupRanges();
    }

    public void add(RangeSet set) {
        for (Range range : set.getRanges()) {
            this.add(range.getMinValue(), range.getMaxValue());
        }
        this.fixupRanges();
    }

    public void clear() {
        this.rangeList.clear();
    }

    public boolean contains(int val) {
        return this.findIndex(val) >= 0;
    }

    private void contains(Range val, RangeSet set) {
        for (Range r : this.rangeList) {
            Range nr = r.contains(val);
            set.add(nr.getMinValue(), nr.getMaxValue());
        }
    }

    public RangeSet contains(RangeSet set) {
        RangeSet newSet = new RangeSet();
        for (Range r : set.getRanges()) {
            this.contains(r, newSet);
        }
        return newSet;
    }

    private int findIndex(int val) {
        int low = 0;
        int high = this.rangeList.size() - 1;
        while (low <= high) {
            int pos = low == high ? low : (low + high) / 2;
            Range r = this.rangeList.get(pos);
            if (r.contains(val)) {
                return pos;
            }
            if (val < r.getMinValue()) {
                high = pos - 1;
                continue;
            }
            if (val <= r.getMaxValue()) continue;
            low = pos + 1;
        }
        return -(low + 1);
    }

    private void fixupRanges() {
        int pos = this.rangeList.size() - 2;
        while (pos >= 0) {
            Range r1 = this.rangeList.get(pos);
            Range r2 = this.rangeList.get(pos + 1);
            if (r1.getMaxValue() >= r2.getMinValue() - 1) {
                r1.setMaxValue(r2.getMaxValue());
                this.rangeList.remove(pos + 1);
            }
            --pos;
        }
    }

    public List<Range> getRanges() {
        return this.rangeList;
    }

    private void internalAdd(int min, int max) {
        if (min == max) {
            this.add(min);
            return;
        }
        if (min > max) {
            return;
        }
        if (this.rangeList.size() == 0) {
            this.rangeList.add(new Range(min, max));
            return;
        }
        Range rlow = null;
        Range rhigh = null;
        int ilow = this.findIndex(min);
        int ihigh = this.findIndex(max);
        if (ilow >= 0) {
            if (ilow == ihigh) {
                return;
            }
            rlow = this.rangeList.get(ilow);
            if (ihigh >= 0) {
                rhigh = this.rangeList.get(ihigh);
                rlow.setMaxValue(rhigh.getMaxValue());
            } else {
                rlow.setMaxValue(max);
                ihigh = -(ihigh + 2);
            }
            while (ihigh != ilow) {
                this.rangeList.remove(ilow + 1);
                --ihigh;
            }
        } else {
            ilow = -(ilow + 1);
            if (ihigh >= 0) {
                rhigh = this.rangeList.get(ihigh);
                rhigh.setMinValue(min);
                while (ihigh != ilow) {
                    this.rangeList.remove(ilow);
                    --ihigh;
                }
            } else if (ilow == (ihigh = -(ihigh + 1))) {
                this.rangeList.add(ilow, new Range(min, max));
            } else {
                rlow = this.rangeList.get(ilow);
                rlow.setMinValue(min);
                rlow.setMaxValue(max);
                while (ihigh > ilow + 1) {
                    this.rangeList.remove(ilow + 1);
                    --ihigh;
                }
            }
        }
    }

    @Override
    public Iterator<String> iterator() {
        this.rangeListIter = this.rangeList.iterator();
        this.rangeIter = this.rangeListIter.hasNext() ? this.rangeListIter.next().iterator() : null;
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return RangeSet.this.rangeIter != null && (RangeSet.this.rangeIter.hasNext() || RangeSet.this.rangeListIter.hasNext());
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    if (!RangeSet.this.rangeIter.hasNext()) {
                        RangeSet.this.rangeIter = ((Range)RangeSet.this.rangeListIter.next()).iterator();
                    }
                    return (String)RangeSet.this.rangeIter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void remove(int val) {
        int pos = this.findIndex(val);
        if (pos >= 0) {
            Range r = this.rangeList.get(pos);
            int min = r.getMinValue();
            int max = r.getMaxValue();
            if (max == min) {
                this.rangeList.remove(pos);
            } else if (min == val) {
                r.setMinValue(val + 1);
            } else {
                r.setMaxValue(val - 1);
                if (max > val) {
                    Range r2 = new Range(val + 1, max);
                    this.rangeList.add(pos + 1, r2);
                }
            }
        }
    }

    public void remove(int from, int to) {
        ListIterator<Range> it = this.rangeList.listIterator();
        while (it.hasNext()) {
            Range r = it.next();
            int min = r.getMinValue();
            int max = r.getMaxValue();
            if (min >= from && max <= to) {
                it.remove();
                continue;
            }
            if (!r.contains(from) && !r.contains(to)) continue;
            if (from > min) {
                r.setMaxValue(from - 1);
                if (to >= max) continue;
                Range r2 = new Range(to + 1, max);
                it.add(r2);
                continue;
            }
            if (to >= max) continue;
            r.setMinValue(to + 1);
        }
    }

    public void remove(RangeSet set) {
        for (Range r : set.getRanges()) {
            this.remove(r.getMinValue(), r.getMaxValue());
        }
    }

    public int size() {
        int nels = 0;
        for (Range r : this.rangeList) {
            nels += r.size();
        }
        return nels;
    }

    public int[] toArray() {
        int elt = 0;
        int[] vals = new int[this.size()];
        for (Range r : this.rangeList) {
            int i = r.getMinValue();
            while (i <= r.getMaxValue()) {
                vals[elt++] = i++;
            }
        }
        return vals;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.rangeList.size()) {
            if (i > 0) {
                str = String.valueOf(str) + ",";
            }
            str = String.valueOf(str) + this.rangeList.get(i).toString();
            ++i;
        }
        return str;
    }
}

