/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.borders.ElseElseIfBorder;
import org.eclipse.bpel.ui.editparts.policies.BPELContainerEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.BPELOrderedLayoutEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.ElseHighlightEditPolicy;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.figures.ILayoutAware;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.resources.IMarker;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Image;

public class ElseIfEditPart
extends BPELEditPart
implements NodeEditPart,
ILayoutAware {
    private Image image;
    public Label nameLabel;
    private IFigure childFigure;
    private ElseElseIfBorder border;

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ElseHighlightEditPolicy(false, true));
        if (ModelHelper.isHorizontalLayout(this.getModel())) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ElseIfOrderedHorizontalLayoutEditPolicy());
        } else {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new BPELOrderedLayoutEditPolicy());
        }
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new BPELContainerEditPolicy());
    }

    public Label getNameLabel() {
        return this.nameLabel;
    }

    @Override
    public Label getLabelFigure() {
        return null;
    }

    @Override
    public String getLabelContent() {
        ILabeledElement element = BPELUtil.adapt(this.getModel(), ILabeledElement.class);
        return element.getLabel(this.getModel());
    }

    @Override
    protected IFigure createFigure() {
        ILabeledElement element = BPELUtil.adapt(this.getModel(), ILabeledElement.class);
        if (element == null) {
            return null;
        }
        boolean horizontal = ModelHelper.isHorizontalLayout(this.getModel());
        Figure figure = new Figure();
        ColorRegistry registry = BPELUIPlugin.INSTANCE.getColorRegistry();
        figure.setForegroundColor(registry.get("COLOR_BLACK"));
        FlowLayout layout = new FlowLayout();
        layout.setMinorAlignment(0);
        layout.setHorizontal(horizontal);
        layout.setMajorSpacing(14);
        layout.setMinorSpacing(14);
        layout.setHorizontal(horizontal);
        figure.setLayoutManager((LayoutManager)layout);
        this.nameLabel = new Label(element.getLabel(this.getModel()));
        this.border = new ElseElseIfBorder();
        this.border.setColor(registry.get("activityBorder"));
        this.nameLabel.setBorder((Border)this.border);
        figure.add((IFigure)this.nameLabel);
        this.childFigure = new Figure();
        this.childFigure.setForegroundColor(registry.get("COLOR_BLACK"));
        layout = new FlowLayout();
        layout.setMinorAlignment(0);
        layout.setMajorAlignment(0);
        layout.setMajorSpacing(14);
        layout.setMinorSpacing(14);
        layout.setHorizontal(horizontal);
        this.childFigure.setLayoutManager((LayoutManager)layout);
        figure.add(this.childFigure);
        if (!horizontal) {
            figure.setBorder((Border)new MarginBorder(0, 0, 6, 0));
        }
        return figure;
    }

    protected void unregisterVisuals() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.unregisterVisuals();
    }

    @Override
    protected void handleModelChanged() {
        ILabeledElement element = BPELUtil.adapt(this.getModel(), ILabeledElement.class);
        this.nameLabel.setText(element.getLabel(this.getModel()));
        super.handleModelChanged();
        this.refreshTargetConnections();
        this.refreshSourceConnections();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        return new CenteredConnectionAnchor(this.getFigure(), 1, 6);
    }

    @Override
    public ConnectionAnchor getConnectionAnchor(int location) {
        if (location == 4) {
            return new CenteredConnectionAnchor(this.getFigure(), location, 17);
        }
        if (location == 5) {
            return new CenteredConnectionAnchor(this.getFigure(), location, -16);
        }
        if (location == 2) {
            return new CenteredConnectionAnchor(this.getFigure(), 2, 0);
        }
        return new CenteredConnectionAnchor(this.getFigure(), location, 0);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        return new CenteredConnectionAnchor(this.getFigure(), 0, 0);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return null;
    }

    public IFigure getContentPane() {
        return this.childFigure;
    }

    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        this.refreshMarkerImages();
        this.getFigure().repaint();
    }

    protected void refreshMarkerImages() {
        IMarkerHolder holder;
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        if ((holder = BPELUtil.adapt(this.getModel(), IMarkerHolder.class)) != null) {
            IMarker[] markers = holder.getMarkers(this.getModel());
            int markerPriority = Integer.MIN_VALUE;
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                int priority = marker.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.priority", Integer.MIN_VALUE);
                if (priority > markerPriority) {
                    markerPriority = priority;
                    this.image = BPELUtil.getImage(marker);
                }
                ++i;
            }
        }
        this.border.setImage(this.image);
    }

    @Override
    public void switchLayout(boolean horizontal) {
        ((FlowLayout)this.figure.getLayoutManager()).setHorizontal(horizontal);
        ((FlowLayout)this.childFigure.getLayoutManager()).setHorizontal(horizontal);
        this.removeEditPolicy("LayoutEditPolicy");
        BPELOrderedLayoutEditPolicy newPolicy = null;
        if (horizontal) {
            newPolicy = new ElseIfOrderedHorizontalLayoutEditPolicy();
            this.figure.setBorder(null);
        } else {
            newPolicy = new BPELOrderedLayoutEditPolicy();
            this.figure.setBorder((Border)new MarginBorder(0, 0, 6, 0));
        }
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)newPolicy);
    }

    private class ElseIfOrderedHorizontalLayoutEditPolicy
    extends BPELOrderedLayoutEditPolicy {
        private ElseIfOrderedHorizontalLayoutEditPolicy() {
        }

        @Override
        protected ArrayList<PolylineConnection> createHorizontalConnections(BPELEditPart parent) {
            ArrayList<PolylineConnection> connections = new ArrayList<PolylineConnection>();
            List<BPELEditPart> children = this.getConnectionChildren(parent);
            CenteredConnectionAnchor sourceAnchor = null;
            ConnectionAnchor targetAnchor = null;
            sourceAnchor = new CenteredConnectionAnchor((IFigure)ElseIfEditPart.this.nameLabel, 3, 0);
            int i = 0;
            while (i < children.size()) {
                BPELEditPart targetPart;
                if (i == 0) {
                    targetPart = children.get(i);
                    targetAnchor = targetPart.getConnectionAnchor(2);
                }
                if (i < children.size() - 1) {
                    if (i > 0) {
                        BPELEditPart sourcePart = children.get(i);
                        sourceAnchor = sourcePart.getConnectionAnchor(3);
                    }
                    targetPart = children.get(i + 1);
                    targetAnchor = targetPart.getConnectionAnchor(2);
                }
                if (sourceAnchor != null && targetAnchor != null) {
                    connections.add(this.createConnection((ConnectionAnchor)sourceAnchor, targetAnchor, this.arrowColor));
                }
                ++i;
            }
            return connections;
        }
    }
}

