/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.msw.build.core;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsEditableProvider;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractBuildCommandParser;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractLanguageSettingsOutputScanner;

public class MSVCBuildCommandParser
extends AbstractBuildCommandParser
implements ILanguageSettingsEditableProvider {
    private static final String DOUBLE_BACKSLASH = "\\\\";
    private static final Pattern DOUBLE_BACKSLASH_PATTERN = Pattern.compile(Pattern.quote("\\\\"));
    private static final String BACKSLASH_REPLACEMENT_STRING = "\\\\";
    private static final String BACKSLASH_QUOTE = "\\\"";
    private static final Pattern BACKSLASH_QUOTE_PATTERN = Pattern.compile(Pattern.quote("\\\""));
    private static final String QUOTE_REPLACEMENT_STRING = "\"";
    static final AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] optionParsers = new AbstractLanguageSettingsOutputScanner.AbstractOptionParser[]{new MSVCIncludePathOptionParser("(-|/)I\\s*\"(.*)\"", "$2"), new MSVCIncludePathOptionParser("(-|/)I\\s*([^\\s\"]*)", "$2"), new MSVCForceIncludePathOptionParser("(-|/)FI\\s*\"(.*)\"", "$2"), new MSVCForceIncludePathOptionParser("(-|/)FI\\s*([^\\s\"]*)", "$2"), new ClangCLMSVCSystemPathOptionParser("(-|/)imsvc\\s*\"(.*)\"", "$2"), new ClangCLMSVCSystemPathOptionParser("(-|/)imsvc\\s*([^\\s\"]*)", "$2"), new MSVCMacroOptionParser("(-|/)D\\s*\"([^=]+)=(.*)\"", "$2", "$3"), new MSVCMacroOptionParser("(-|/)D\\s*([^\\s=\"]+)=\"(.*?)(?<!\\\\)\"", "$2", "$3"), new MSVCMacroOptionParser("(-|/)D\\s*([^\\s=\"]+)=([^\\s\"][^\\s]*)?", "$2", "$3"), new MSVCMacroOptionParser("(-|/)D\\s*([^\\s=\"]+)", "$2", "1"), new MSVCMacroOptionParser("(-|/)D\\s*\"([^\\s=\"]+)\"", "$2", "1"), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("(-|/)U\\s*([^\\s=\"]+)", "$2", 32), new AbstractLanguageSettingsOutputScanner.MacroOptionParser("(-|/)U\\s*\"(.*?)\"", "$2", 32)};
    private static final String QUOTE = "(\".*?(?<!\\\\)(\\\\\\\\)?\")";
    private static final Pattern OPTIONS_PATTERN = Pattern.compile("(-|/)[^\\s\"\\\\]*(\\s*[^-/\\s\"\\\\]*((\".*?(?<!\\\\)(\\\\\\\\)?\")|([^-/\\s][^\\s]+)))?");
    private static final int OPTION_GROUP = 0;

    private static String unescapeString(String value) {
        if (value.contains("\\\\")) {
            value = DOUBLE_BACKSLASH_PATTERN.matcher(value).replaceAll("\\\\");
        }
        if (value.contains(BACKSLASH_QUOTE)) {
            value = BACKSLASH_QUOTE_PATTERN.matcher(value).replaceAll(QUOTE_REPLACEMENT_STRING);
        }
        return value;
    }

    protected List<String> parseOptions(String line) {
        if (line == null || this.currentResource == null) {
            return null;
        }
        ArrayList<String> options = new ArrayList<String>();
        Matcher optionMatcher = OPTIONS_PATTERN.matcher(line);
        while (optionMatcher.find()) {
            String option = optionMatcher.group(0);
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    protected AbstractLanguageSettingsOutputScanner.AbstractOptionParser[] getOptionParsers() {
        return optionParsers;
    }

    public MSVCBuildCommandParser cloneShallow() throws CloneNotSupportedException {
        return (MSVCBuildCommandParser)super.cloneShallow();
    }

    public MSVCBuildCommandParser clone() throws CloneNotSupportedException {
        return (MSVCBuildCommandParser)super.clone();
    }

    private static class ClangCLMSVCSystemPathOptionParser
    extends AbstractLanguageSettingsOutputScanner.IncludePathOptionParser {
        public ClangCLMSVCSystemPathOptionParser(String pattern, String nameExpression) {
            super(pattern, nameExpression);
        }

        public ICLanguageSettingEntry createEntry(String name, String value, int flag) {
            return super.createEntry(name, MSVCBuildCommandParser.unescapeString(value), flag);
        }
    }

    private static class MSVCForceIncludePathOptionParser
    extends AbstractLanguageSettingsOutputScanner.IncludeFileOptionParser {
        public MSVCForceIncludePathOptionParser(String pattern, String nameExpression) {
            super(pattern, nameExpression);
        }

        public ICLanguageSettingEntry createEntry(String name, String value, int flag) {
            return super.createEntry(name, MSVCBuildCommandParser.unescapeString(value), flag);
        }
    }

    private static class MSVCIncludePathOptionParser
    extends AbstractLanguageSettingsOutputScanner.IncludePathOptionParser {
        public MSVCIncludePathOptionParser(String pattern, String nameExpression) {
            super(pattern, nameExpression);
        }

        public ICLanguageSettingEntry createEntry(String name, String value, int flag) {
            return super.createEntry(name, MSVCBuildCommandParser.unescapeString(value), flag);
        }
    }

    private static class MSVCMacroOptionParser
    extends AbstractLanguageSettingsOutputScanner.MacroOptionParser {
        public MSVCMacroOptionParser(String pattern, String nameExpression, String valueExpression) {
            super(pattern, nameExpression, valueExpression);
        }

        public ICLanguageSettingEntry createEntry(String name, String value, int flag) {
            return super.createEntry(name, MSVCBuildCommandParser.unescapeString(value), flag);
        }
    }
}

