/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.log.core.manager;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.tcf.log.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.log.core.events.MonitorEvent;
import org.eclipse.tcf.te.tcf.log.core.internal.nls.Messages;

public final class LogManager {
    public final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final Map<String, FileWriter> fileWriterMap = new HashMap<String, FileWriter>();
    private long maxFileSize;
    private int maxInCycle;

    LogManager() {
        this.initializeFromPreferences();
    }

    public static LogManager getInstance() {
        return LazyInstance.instance;
    }

    public void dispose() {
        for (FileWriter writer : this.fileWriterMap.values()) {
            try {
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {}
        }
        this.fileWriterMap.clear();
    }

    private void initializeFromPreferences() {
        String fileSize = CoreBundleActivator.getScopedPreferences().getString("te.tcf.log.core.limits.fileSize");
        if (fileSize == null) {
            fileSize = "5M";
        }
        try {
            char lastChar = fileSize.toUpperCase().charAt(fileSize.length() - 1);
            if ('K' == lastChar || 'M' == lastChar || 'G' == lastChar) {
                this.maxFileSize = Long.parseLong(fileSize.substring(0, fileSize.length() - 1));
                switch (lastChar) {
                    case 'K': {
                        this.maxFileSize *= 1024L;
                        break;
                    }
                    case 'M': {
                        this.maxFileSize = this.maxFileSize * 1024L * 1024L;
                        break;
                    }
                    case 'G': {
                        this.maxFileSize = this.maxFileSize * 1024L * 1024L * 1024L;
                    }
                }
            } else {
                this.maxFileSize = Long.parseLong(fileSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.maxFileSize = 0x500000L;
        }
        this.maxInCycle = CoreBundleActivator.getScopedPreferences().getInt("te.tcf.log.core.limits.inCycle");
        if (this.maxInCycle <= 0) {
            this.maxInCycle = 5;
        }
    }

    public FileWriter getWriter(String logname, IPeer peer) {
        IPath path;
        FileWriter writer;
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)ExecutorsUtil.isExecutorThread(), (String)"Illegal Thread Access");
        this.checkLimits(logname, peer);
        if (logname == null) {
            logname = this.getLogName(peer);
        }
        FileWriter fileWriter = writer = logname != null ? this.fileWriterMap.get(logname) : null;
        if (writer == null && logname != null && (path = this.getLogDir()) != null) {
            path = path.append(String.valueOf(logname) + ".log");
            try {
                writer = new FileWriter(path.toFile(), true);
                this.fileWriterMap.put(logname, writer);
            }
            catch (IOException iOException) {}
        }
        return writer;
    }

    public void closeWriter(String logname, IPeer peer, String message) {
        block14: {
            FileWriter writer;
            Assert.isNotNull((Object)peer);
            Assert.isTrue((boolean)ExecutorsUtil.isExecutorThread(), (String)"Illegal Thread Access");
            if (logname == null) {
                logname = this.getLogName(peer);
            }
            FileWriter fileWriter = writer = logname != null ? this.fileWriterMap.remove(logname) : null;
            if (writer != null) {
                try {
                    try {
                        if (message != null) {
                            writer.write(message);
                            writer.write("\n");
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            writer.flush();
                            writer.close();
                        }
                        catch (IOException iOException2) {}
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getLogName(IPeer peer) {
        Assert.isNotNull((Object)peer);
        String logName = null;
        logName = peer.getName();
        if (logName != null) {
            String ip = (String)peer.getAttributes().get("Host");
            if (ip == null || "".equals(ip.trim())) {
                ip = peer.getID();
            }
            if (ip != null && !"".equals(ip.trim())) {
                logName = String.valueOf(logName) + " " + ip.trim();
            }
            logName = this.makeValid(logName);
        }
        return logName;
    }

    public String makeValid(String name) {
        Assert.isNotNull((Object)name);
        String result = name.replaceAll("\\s", "_");
        result = result.replaceAll("[:/\\;,\\[\\]\\(\\)]", "_");
        return result;
    }

    public IPath getLogDir() {
        boolean exists;
        File file;
        Path logDir = null;
        if (CoreBundleActivator.getDefault() == null) {
            return logDir;
        }
        try {
            file = CoreBundleActivator.getDefault().getStateLocation().append(".logs").toFile();
            exists = file.exists();
            if (!exists) {
                exists = file.mkdirs();
            }
            if (exists && file.canRead() && file.isDirectory()) {
                logDir = new Path(file.toString());
            }
        }
        catch (IllegalStateException illegalStateException) {}
        if (logDir == null) {
            file = new Path(System.getProperty("user.home")).append(".tcf/.logs").toFile();
            exists = file.exists();
            if (!exists) {
                exists = file.mkdirs();
            }
            if (exists && file.canRead() && file.isDirectory()) {
                logDir = new Path(file.toString());
            }
        }
        if (logDir == null) {
            file = new Path(System.getProperty("java.io.tmpdir")).append(".tcf/.logs").toFile();
            exists = file.exists();
            if (!exists) {
                exists = file.mkdirs();
            }
            if (exists && file.canRead() && file.isDirectory()) {
                logDir = new Path(file.toString());
            }
        }
        return logDir;
    }

    private void checkLimits(String logname, IPeer peer) {
        long size;
        IPath fullPath;
        File file;
        IPath path;
        Assert.isNotNull((Object)peer);
        String logName = this.getLogName(peer);
        if (logName != null && !"".equals(logName.trim()) && (path = this.getLogDir()) != null && (file = (fullPath = path.append(String.valueOf(logName) + ".log")).toFile()).exists() && (size = file.length()) >= this.maxFileSize) {
            this.closeWriter(logname, peer, null);
            File maxFileInCycle = path.append(String.valueOf(logName) + "_" + this.maxInCycle + ".log").toFile();
            if (maxFileInCycle.exists()) {
                int no = 1;
                File fileInCycle = path.append(String.valueOf(logName) + "_" + no + ".log").toFile();
                boolean rc = fileInCycle.delete();
                if (rc) {
                    while (no <= this.maxInCycle) {
                        File renameTo;
                        fileInCycle = path.append(String.valueOf(logName) + "_" + ++no + ".log").toFile();
                        rc = fileInCycle.renameTo(renameTo = path.append(String.valueOf(logName) + "_" + (no - 1) + ".log").toFile());
                        if (!rc) break;
                    }
                    boolean bl = rc = rc ? file.renameTo(maxFileInCycle) : file.delete();
                    if (!rc && Platform.inDebugMode()) {
                        System.err.println(NLS.bind((String)Messages.LogManager_error_renameFailed, (Object)fullPath.toOSString(), (Object)maxFileInCycle.getAbsolutePath()));
                    }
                }
            } else {
                int no = 1;
                File fileInCycle = path.append(String.valueOf(logName) + "_" + no + ".log").toFile();
                while (fileInCycle.exists()) {
                    fileInCycle = path.append(String.valueOf(logName) + "_" + ++no + ".log").toFile();
                }
                Assert.isTrue((no <= this.maxInCycle ? 1 : 0) != 0);
                boolean rc = file.renameTo(fileInCycle);
                if (!rc && Platform.inDebugMode()) {
                    System.err.println(NLS.bind((String)Messages.LogManager_error_renameFailed, (Object)fullPath.toOSString(), (Object)fileInCycle.getAbsolutePath()));
                }
            }
        }
    }

    public void monitor(IPeer peer, MonitorEvent.Type type, MonitorEvent.Message message) {
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)((Object)type));
        Assert.isNotNull((Object)message);
        Assert.isTrue((boolean)ExecutorsUtil.isExecutorThread(), (String)"Illegal Thread Access");
        if (!CoreBundleActivator.getScopedPreferences().getBoolean("te.tcf.log.core.monitor.enabled")) {
            return;
        }
        MonitorEvent event = new MonitorEvent(peer, type, message);
        EventManager.getInstance().fireEvent((EventObject)event);
    }

    private static class LazyInstance {
        public static LogManager instance = new LogManager();

        private LazyInstance() {
        }
    }
}

