"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
const vscode_languageserver_1 = require("vscode-languageserver");
const yamlLanguageService_1 = require("../src/languageservice/yamlLanguageService");
const testHelper_1 = require("./utils/testHelper");
const assert = require("assert");
const path = require("path");
const languageService = yamlLanguageService_1.getLanguageService(testHelper_1.schemaRequestService, testHelper_1.workspaceContext, [], null);
const languageSettings = {
    schemas: [],
    completion: true
};
const uri = testHelper_1.toFsPath(path.join(__dirname, './fixtures/testArrayMaxProperties.json'));
const fileMatch = ['*.yml', '*.yaml'];
languageSettings.schemas.push({ uri, fileMatch: fileMatch });
languageService.configure(languageSettings);
suite('Auto Completion Tests', () => {
    describe('yamlCompletion with array having maxProperties set', function () {
        describe('doComplete', function () {
            function setup(content) {
                return vscode_languageserver_1.TextDocument.create('file://~/Desktop/vscode-k8s/test.yaml', 'yaml', 0, content);
            }
            function parseSetup(content, position) {
                const testTextDocument = setup(content);
                return languageService.doComplete(testTextDocument, testTextDocument.positionAt(position), false);
            }
            it('Provide the 3 types when none provided', done => {
                const content = '- ';
                const completion = parseSetup(content, content.length);
                completion.then(function (result) {
                    assert.equal(result.items.length, 3);
                }).then(done, done);
            });
            it('Provide the 3 types when one is provided', done => {
                const content = '- prop1:\n  ';
                const completion = parseSetup(content, content.length);
                completion.then(function (result) {
                    assert.equal(result.items.length, 2);
                }).then(done, done);
            });
            it('Provide no completion when maxProperties reached', done => {
                const content = '- prop1:\n  prop2:\n  ';
                const completion = parseSetup(content, content.length);
                completion.then(function (result) {
                    assert.equal(result.items.length, 0);
                }).then(done, done);
            });
        });
    });
});
//# sourceMappingURL=autoCompletion.maxproperties.test.js.map