/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.ComponentNotFoundException;
import org.eclipse.jubula.rc.common.listener.AUTEventListener;
import org.eclipse.jubula.rc.common.listener.BaseAUTListener;
import org.eclipse.jubula.rc.swt.driver.RobotFactoryConfig;
import org.eclipse.jubula.rc.swt.driver.RobotFactorySwtImpl;
import org.eclipse.jubula.rc.swt.driver.RobotSwtImpl;
import org.eclipse.jubula.rc.swt.listener.AbstractAutSwtEventListener;
import org.eclipse.jubula.rc.swt.listener.CheckListener;
import org.eclipse.jubula.rc.swt.listener.ComponentHandler;
import org.eclipse.jubula.rc.swt.listener.FocusTracker;
import org.eclipse.jubula.rc.swt.listener.MappingListener;
import org.eclipse.jubula.rc.swt.listener.RecordListener;
import org.eclipse.jubula.rc.swt.listener.TableSelectionTracker;
import org.eclipse.jubula.rc.swt.utils.KeyConverter;
import org.eclipse.jubula.tools.internal.objects.IComponentIdentifier;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwtAUTServer
extends AUTServer {
    private static final Logger LOG = LoggerFactory.getLogger(SwtAUTServer.class);
    private Display m_display = null;
    private RobotSwtImpl m_robot = null;

    public SwtAUTServer() {
        super((AUTEventListener)new MappingListener(), (AUTEventListener)new RecordListener(), (AUTEventListener)new CheckListener());
    }

    public void startAUT() {
        if (this.isRcpAccessible()) {
            return;
        }
        super.startAUT();
        this.getAutDisplay();
        if (!this.isAgentSet()) {
            super.addToolKitEventListenerToAUT();
        }
    }

    public Display getAutDisplay() {
        if (this.isRcpAccessible()) {
            while (this.m_display == null) {
                this.m_display = Display.findDisplay((Thread)Thread.currentThread());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            return this.getSwtAutDisplay();
        }
        return this.m_display;
    }

    private Display getSwtAutDisplay() {
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getAutThread().getContextClassLoader());
            while (this.m_display == null) {
                this.m_display = Display.findDisplay((Thread)this.getAutThread());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            Display display = this.m_display;
            return display;
        }
        finally {
            if (this.m_display == null) {
                LOG.error("SWT Display not found");
            }
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    protected void addToolkitEventListeners() {
        this.addToolkitEventListener(new ComponentHandler());
        this.addToolkitEventListener(new FocusTracker());
        this.addToolkitEventListener(TableSelectionTracker.getInstance());
    }

    protected void addToolkitEventListener(final BaseAUTListener listener) {
        try {
            this.getAutDisplay().syncExec(new Runnable(){

                public void run() {
                    long[] mask = listener.getEventMask();
                    int i = 0;
                    while (i < mask.length) {
                        SwtAUTServer.this.getAutDisplay().addFilter((int)mask[i], (Listener)listener);
                        ++i;
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info("installing SWTEventListener " + listener.toString());
                    }
                }
            });
        }
        catch (NullPointerException se) {
            LOG.error(se.getLocalizedMessage(), (Throwable)se);
            System.exit(21);
        }
    }

    protected void removeToolkitEventListener(final BaseAUTListener listener) {
        try {
            this.getAutDisplay().syncExec(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < ((AbstractAutSwtEventListener)listener).getEventMask().length) {
                        SwtAUTServer.this.getAutDisplay().removeFilter((int)((AbstractAutSwtEventListener)listener).getEventMask()[i], (Listener)((AbstractAutSwtEventListener)listener));
                        if (LOG.isInfoEnabled()) {
                            LOG.info("uninstalling SWTEventListener " + listener.toString());
                        }
                        ++i;
                    }
                }
            });
        }
        catch (NullPointerException se) {
            LOG.error(se.getLocalizedMessage(), (Throwable)se);
            System.exit(21);
        }
    }

    protected void startTasks() throws ExceptionInInitializerError, InvocationTargetException, NoSuchMethodException {
        super.invokeAUT();
        if (this.getCommunicator() != null) {
            this.getCommunicator().close();
        }
    }

    public synchronized IRobot getRobot() {
        if (this.m_robot == null) {
            RobotFactorySwtImpl robotFactory = new RobotFactoryConfig().getRobotFactory();
            this.m_robot = (RobotSwtImpl)robotFactory.getRobot();
        }
        return this.m_robot;
    }

    public void setDisplay(Display display) {
        this.m_display = display;
    }

    public Object findComponent(IComponentIdentifier ci, int timeout) throws ComponentNotFoundException, IllegalArgumentException {
        return ComponentHandler.findComponent(ci, true, timeout);
    }

    public boolean isComponentDisappeared(IComponentIdentifier ci, int timeout) throws ComponentNotFoundException, IllegalArgumentException {
        return ComponentHandler.isComponentDisappeared(ci, timeout);
    }

    public void setMode(int newMode) {
        this.convertMappingKeys();
        super.setMode(newMode);
    }

    private void convertMappingKeys() {
        AUTServerConfiguration config = AUTServerConfiguration.getInstance();
        int mappingKey = config.getMappingKey();
        config.setMappingKey(KeyConverter.convertSwingToSwt(mappingKey));
        int mappingMod = config.getMappingKeyMod();
        config.setMappingKeyMod(KeyConverter.convertSwingStateMask(mappingMod));
        int checkModeKey = config.getCheckModeKey();
        config.setCheckModeKey(KeyConverter.convertSwingToSwt(checkModeKey));
        int checkModeMod = config.getCheckModeKeyMod();
        config.setCheckModeKeyMod(KeyConverter.convertSwingStateMask(checkModeMod));
        int checkCompKey = config.getCheckCompKey();
        config.setCheckCompKey(KeyConverter.convertSwingToSwt(checkCompKey));
        int checkCompKeyMod = config.getCheckCompKeyMod();
        config.setCheckModeKeyMod(KeyConverter.convertSwingStateMask(checkCompKeyMod));
    }
}

