/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.nio.channels.SeekableByteChannel;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mat.hprof.GZIPInputStream2;
import org.eclipse.mat.hprof.HprofPlugin;
import org.eclipse.mat.util.MessageUtil;

public class SeekableStream
extends InputStream
implements Closeable,
AutoCloseable {
    Supplier<InputStream> genstream;
    long nextseq = 0L;
    int cleanup;
    TreeSet<PosStream> ts = new TreeSet();
    PosStream tail = new PosStream(0L, -2L);
    PosStream head;
    PosStream current;
    int cachesize;
    long estlen;
    long lastpos;
    long totalseek;
    RandomAccessInputStream underlying;
    SeekableByteChannel underlyingChannel;
    private final boolean verbose;
    private static final long READ0COST = 80000L;

    public SeekableStream(Supplier<InputStream> genstream, RandomAccessInputStream underlying, int cachesize, long estlen) throws IOException {
        this.tail.next = this.head = new PosStream(Long.MAX_VALUE, -1L);
        this.head.prev = this.tail;
        this.verbose = Platform.inDebugMode() && HprofPlugin.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mat.hprof/debug/gzip"));
        this.genstream = genstream;
        this.cachesize = cachesize;
        this.estlen = estlen;
        this.underlying = underlying;
        this.cleanup = this.initcleanup();
        this.seek(0L);
    }

    private int initcleanup() {
        return (int)Math.pow(this.cachesize + 1, 0.75);
    }

    public SeekableStream(Supplier<InputStream> genstream, SeekableByteChannel underlying, int cachesize, long estlen) throws IOException {
        this.tail.next = this.head = new PosStream(Long.MAX_VALUE, -1L);
        this.head.prev = this.tail;
        this.verbose = Platform.inDebugMode() && HprofPlugin.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mat.hprof/debug/gzip"));
        this.genstream = genstream;
        this.cachesize = cachesize;
        this.estlen = estlen;
        this.underlyingChannel = underlying;
        this.cleanup = this.initcleanup();
        this.seek(0L);
    }

    public SeekableStream(Supplier<InputStream> genstream, int cachesize) throws IOException {
        this.tail.next = this.head = new PosStream(Long.MAX_VALUE, -1L);
        this.head.prev = this.tail;
        this.verbose = Platform.inDebugMode() && HprofPlugin.getDefault().isDebugging() && Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.mat.hprof/debug/gzip"));
        this.genstream = genstream;
        this.cachesize = cachesize;
        this.cleanup = this.initcleanup();
        this.seek(0L);
    }

    long underlyingPosition() throws IOException {
        if (this.underlying != null) {
            return this.underlying.position();
        }
        if (this.underlyingChannel != null) {
            return this.underlyingChannel.position();
        }
        return -1L;
    }

    void underlyingPosition(long pos) throws IOException {
        if (this.underlying != null) {
            this.underlying.seek(pos);
        } else if (this.underlyingChannel != null) {
            this.underlyingChannel.position(pos);
        }
    }

    boolean underlyingClose() throws IOException {
        if (this.underlying != null) {
            this.underlying.close();
            return true;
        }
        if (this.underlyingChannel != null) {
            this.underlyingChannel.close();
            return true;
        }
        return false;
    }

    void streamClose(PosStream pos) throws IOException {
        pos.close();
    }

    boolean underlying() {
        if (this.underlying != null) {
            return true;
        }
        return this.underlyingChannel != null;
    }

    boolean add(PosStream toAdd) {
        if (this.ts.add(toAdd)) {
            toAdd.prev = this.head.prev;
            toAdd.next = this.head;
            toAdd.decay = 0L;
            this.head.prev.next = toAdd;
            this.head.prev = toAdd;
            return true;
        }
        PosStream existing = this.ts.floor(toAdd);
        if (existing != null) {
            existing.prev.next = existing.next;
            existing.next.prev = existing.prev;
            existing.prev = this.head.prev;
            existing.next = this.head;
            existing.decay = 0L;
            this.head.prev.next = existing;
            this.head.prev = existing;
        }
        return false;
    }

    boolean remove(PosStream toRemove) {
        if (this.ts.remove(toRemove)) {
            toRemove.prev.next = toRemove.next;
            toRemove.next.prev = toRemove.prev;
            toRemove.prev = null;
            toRemove.next = null;
            return true;
        }
        return false;
    }

    void clearEntry() throws IOException {
        PosStream toremove;
        if (this.ts.isEmpty()) {
            return;
        }
        if (this.nextseq % (long)this.cleanup == 0L) {
            this.clearClosest();
            this.clearClosest();
            return;
        }
        int iterations = 10;
        if (iterations <= 1 && this.remove(toremove = this.tail.next)) {
            this.streamClose(toremove);
            return;
        }
        PosStream test = this.tail.next;
        PosStream toremove2 = null;
        int factor = 10;
        long okaygap = this.lastpos > 0L ? this.lastpos / (long)this.cachesize * (long)factor : (this.estlen > 0L ? this.estlen / (long)this.cachesize * (long)factor : 0L);
        long bestgap = Long.MAX_VALUE;
        long firstgap = 0L;
        int i = 0;
        while (i < iterations && test != this.head && bestgap > okaygap) {
            long gap;
            PosStream prev = this.ts.lower(test);
            long l = gap = prev == null ? test.pos + 80000L : test.pos - prev.pos;
            if ((gap -= test.decay) < bestgap) {
                bestgap = gap;
                toremove2 = test;
            }
            if (i == 0) {
                firstgap = gap;
            }
            ++i;
            test = test.next;
        }
        if (toremove2 != null) {
            long adjust = (long)((double)bestgap * (double)bestgap / (double)firstgap);
            PosStream skipped = this.tail.next;
            while (skipped != toremove2) {
                skipped.decay += adjust;
                skipped = skipped.next;
            }
            this.remove(toremove2);
            this.streamClose(toremove2);
        }
    }

    void clearClosest() throws IOException {
        if (this.ts.size() == 0) {
            return;
        }
        long pos = 0L;
        PosStream best = null;
        long bestgap = Long.MAX_VALUE;
        long gaptotal = 0L;
        long gapstotal = 0L;
        int n = 0;
        Iterator<PosStream> ip = this.ts.iterator();
        while (ip.hasNext()) {
            PosStream p = ip.next();
            if (p.isCleared()) {
                p.prev.next = p.next;
                p.next.prev = p.prev;
                p.prev = null;
                p.next = null;
                ip.remove();
                continue;
            }
            long gap = p.position() - pos;
            if (gap < bestgap) {
                best = p;
                bestgap = gap;
            }
            gaptotal += gap;
            gapstotal += gap * gap;
            ++n;
            pos = p.position();
        }
        if (best != null) {
            this.remove(best);
            this.streamClose(best);
        }
    }

    void dump() {
        if (this.ts.size() == 0) {
            return;
        }
        long pos = -80000L;
        PosStream best = null;
        long bestgap = Long.MAX_VALUE;
        long gaptotal = 0L;
        long gapstotal = 0L;
        int n = 0;
        for (PosStream p : this.ts) {
            long gap;
            if (p.isCleared()) {
                gap = p.position() - pos;
                System.out.println(String.valueOf(n) + "," + p.position() + "," + p.seq + "," + gap + "," + p.decay + ",cleared");
                continue;
            }
            gap = p.position() - pos;
            System.out.println(String.valueOf(n) + "," + p.position() + "," + p.seq + "," + gap + "," + p.decay);
            if (gap < bestgap) {
                best = p;
                bestgap = gap;
            }
            gaptotal += gap;
            gapstotal += gap * gap;
            ++n;
            pos = p.position();
        }
        if (this.verbose && n > 0 && bestgap < 64L) {
            System.out.println("n=" + n + " avg=" + gaptotal / (long)n + " rms=" + Math.sqrt(gapstotal / (long)n) + " smallest=" + bestgap + " pos=" + best.pos);
        }
    }

    public void seek(long pos) throws IOException {
        long toSkip;
        PosStream found;
        long then = System.currentTimeMillis();
        if (this.current != null) {
            this.current.basepos = this.underlyingPosition();
            this.current.setActive(false);
            if (!this.add(this.current)) {
                this.streamClose(this.current);
                this.current = null;
            }
        }
        PosStream dummy = new PosStream(pos, this.nextseq);
        while ((found = this.ts.floor(dummy)) != null && this.remove(found) && !found.setActive(true)) {
        }
        if (found != null) {
            PosStream copy = found.copy(this.nextseq);
            if (copy != null) {
                ++this.nextseq;
                copy.setActive(false);
                this.add(copy);
                if (this.ts.size() > this.cachesize) {
                    this.clearEntry();
                }
            }
            this.underlyingPosition(found.basepos);
        } else {
            if (this.ts.size() > this.cachesize) {
                this.clearEntry();
            }
            this.underlyingPosition(0L);
            try {
                found = new PosStream(this.genstream.get(), this.nextseq++);
            }
            catch (UncheckedIOException e) {
                if (this.current != null) {
                    this.remove(this.current);
                    this.underlyingPosition(this.current.basepos);
                    if (!this.current.setActive(true)) {
                        this.current = null;
                    }
                }
                throw e.getCause();
            }
        }
        this.current = found;
        long toSkip1 = toSkip = pos - found.position();
        if (this.ts.size() >= this.cachesize && this.cachesize > 0) {
            int factor = 10;
            if (this.lastpos > 0L && toSkip / (long)factor > this.lastpos / (long)this.cachesize || this.estlen > 0L && toSkip / (long)factor > this.estlen / (long)this.cachesize || this.lastpos == 0L && this.estlen == 0L && toSkip / (long)factor > 0x7D00000000L / (long)this.cachesize) {
                this.clearEntry();
            }
        }
        while (toSkip > 0L) {
            long skipped;
            long skipNow;
            if (this.ts.size() < this.cachesize) {
                int space = this.cachesize - this.ts.size();
                skipNow = this.lastpos > 0L ? Math.min(toSkip, this.lastpos / (long)(this.cachesize + 1)) : (this.estlen > 0L ? Math.min(toSkip, this.estlen / (long)(this.cachesize + 1)) : Math.min(toSkip, 0x40000000L));
                int fewleft = 2;
                if (space <= fewleft) {
                    skipNow = (toSkip + (long)space) / (long)(space + 1);
                }
            } else {
                skipNow = toSkip;
            }
            if ((skipped = this.skip(skipNow)) == 0L) {
                if (this.current == null) {
                    throw new EOFException(Long.toString(this.position()));
                }
                throw new IOException(Long.toString(this.position()));
            }
            if ((toSkip -= skipped) <= 0L || this.ts.size() >= this.cachesize || this.current == null) continue;
            this.current.basepos = this.underlyingPosition();
            PosStream extra = this.current.copy(this.nextseq);
            if (extra == null) continue;
            ++this.nextseq;
            extra.setActive(false);
            this.add(extra);
        }
        long now = System.currentTimeMillis();
        this.totalseek += now - then;
        if (this.verbose && now - then > 1000L) {
            this.dump();
            System.out.println(MessageUtil.format((String)"Slow gzip seek to offset {0} from {1} by {2} cache size {3} took {4}ms", (Object[])new Object[]{pos, pos - toSkip1, toSkip1, this.ts.size(), now - then}));
        }
    }

    public long position() {
        return this.current != null ? this.current.pos : this.lastpos;
    }

    @Override
    public int read() throws IOException {
        if (this.current == null) {
            return -1;
        }
        int r = this.current.read();
        if (this.current.position() > this.estlen && this.estlen > 0L) {
            this.estlen = this.current.position();
        }
        if (r < 0) {
            this.estlen = this.lastpos = this.current.position();
            this.streamClose(this.current);
            this.current = null;
        }
        return r;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.current == null) {
            return -1;
        }
        int r = this.current.read(buffer, offset, length);
        if (this.current.position() > this.estlen && this.estlen > 0L) {
            this.estlen = this.current.position();
        }
        if (r < 0) {
            this.estlen = this.lastpos = this.current.position();
            this.streamClose(this.current);
            this.current = null;
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        Iterator<PosStream> it = this.ts.iterator();
        while (it.hasNext()) {
            PosStream ps = it.next();
            this.streamClose(ps);
            ps.prev.next = ps.next;
            ps.next.prev = ps.prev;
            ps.prev = null;
            ps.next = null;
            it.remove();
        }
        if (this.current != null) {
            this.estlen = this.lastpos = this.current.position();
            this.streamClose(this.current);
        }
        this.current = null;
        if (this.verbose) {
            System.out.println("Total seek time " + this.totalseek + "ms");
        }
    }

    public String toString() {
        long pos = this.current != null ? this.current.position() : this.lastpos;
        return String.valueOf(this.getClass().getName()) + " " + pos + " " + this.ts;
    }

    static class PosStream
    extends FilterInputStream
    implements Comparable<PosStream> {
        private long pos;
        long seq;
        long basepos;
        boolean eof;
        SoftReference<InputStream> savedStream;
        PosStream prev;
        PosStream next;
        long decay;

        protected PosStream(InputStream in, long seq1) {
            super(in);
            this.seq = seq1;
            this.savedStream = new SoftReference<InputStream>(in);
        }

        protected PosStream(long pos, long seq1) {
            super(null);
            this.pos = pos;
            this.seq = seq1;
        }

        protected PosStream copy(long seq) throws IOException {
            if (this.in instanceof GZIPInputStream2) {
                PosStream ret = new PosStream(new GZIPInputStream2((GZIPInputStream2)this.in), seq);
                ret.basepos = this.basepos;
                ret.pos = this.pos;
                return ret;
            }
            return null;
        }

        @Override
        public int read() throws IOException {
            int r = super.read();
            if (r != -1) {
                ++this.pos;
            } else {
                this.eof = true;
            }
            return r;
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            int r = super.read(buf, off, len);
            if (r != -1) {
                this.pos += (long)r;
            } else {
                this.eof = true;
            }
            return r;
        }

        @Override
        public int compareTo(PosStream o) {
            if (this.pos < o.pos) {
                return -1;
            }
            if (this.pos > o.pos) {
                return 1;
            }
            return Long.compare(this.seq, o.seq);
        }

        public boolean equals(Object o) {
            return o instanceof PosStream && this.compareTo((PosStream)o) == 0;
        }

        public int hashCode() {
            return (int)this.pos ^ (int)this.seq;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " " + this.pos + " (" + this.seq + ")" + (this.eof ? "EOF" : "");
        }

        long position() {
            return this.pos;
        }

        void position(long pos) {
            this.pos = pos;
        }

        boolean setActive(boolean state) {
            if (state) {
                if (this.savedStream == null) {
                    return false;
                }
                this.in = this.savedStream.get();
                return this.in != null;
            }
            return true;
        }

        boolean isCleared() {
            return this.savedStream.get() == null;
        }

        @Override
        public void close() throws IOException {
            if (this.setActive(true)) {
                super.close();
            }
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    public static abstract class RandomAccessInputStream
    extends FilterInputStream {
        protected RandomAccessInputStream(InputStream in) {
            super(in);
        }

        abstract long position() throws IOException;

        abstract void seek(long var1) throws IOException;
    }

    public static class UnclosableInputStream
    extends FilterInputStream {
        public UnclosableInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() {
        }
    }
}

