/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaComplexType;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.PluginBaseNode;
import org.eclipse.pde.internal.core.text.plugin.PluginExtensionNode;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.actions.CollapseAction;
import org.eclipse.pde.internal.ui.editor.actions.FilterRelatedExtensionsAction;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.actions.ToggleExpandStateAction;
import org.eclipse.pde.internal.ui.editor.contentassist.XMLElementProposalComputer;
import org.eclipse.pde.internal.ui.editor.plugin.FormFilteredTree;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.plugin.NewElementAction;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.pde.internal.ui.search.ExtensionsPatternFilter;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.util.AcceleratedTreeScrolling;
import org.eclipse.pde.internal.ui.util.ExtensionsFilterUtil;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.extension.ExtensionEditorWizard;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionWizard;
import org.eclipse.pde.ui.IExtensionEditorWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.WorkbenchJob;

public class ExtensionsSection
extends TreeSection
implements IPropertyChangeListener {
    private static final int REFRESHJOB_DELAY_TIME = 1200;
    private static final int ACCELERATED_SCROLLING = 15;
    private static final int BUTTON_MOVE_DOWN = 4;
    private static final int BUTTON_MOVE_UP = 3;
    private static final int BUTTON_EDIT = 2;
    private static final int BUTTON_REMOVE = 1;
    private static final int BUTTON_ADD = 0;
    private TreeViewer fExtensionTree;
    private Image fExtensionImage;
    private Image fGenericElementImage;
    private FormFilteredTree fFilteredTree;
    private ExtensionsPatternFilter fPatternFilter;
    private SchemaRegistry fSchemaRegistry;
    private Hashtable<String, ArrayList<IConfigurationElement>> fEditorWizards;
    private SortAction fSortAction;
    private CollapseAction fCollapseAction;
    private ToggleExpandStateAction fExpandAction;
    private FilterRelatedExtensionsAction fFilterRelatedAction;
    private boolean fBypassFilterDelay = false;
    public static final String[] COMMON_LABEL_ATTRIBUTES = new String[]{"label", "name", "locationURI", "class", "id", "commandId", "property", "activityId", "attribute", "value"};
    private static final String[] VALID_IMAGE_TYPES = new String[]{"png", "bmp", "ico", "gif", "jpg", "tiff"};
    private static final String MENU_NEW_ID = "NewMenu";

    public ExtensionsSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128, new String[]{PDEUIMessages.ManifestEditor_DetailExtension_new, PDEUIMessages.ManifestEditor_DetailExtension_remove, PDEUIMessages.ManifestEditor_DetailExtension_edit, PDEUIMessages.ManifestEditor_DetailExtension_up, PDEUIMessages.ManifestEditor_DetailExtension_down});
        this.fHandleDefaultButton = false;
    }

    private static void addItemsForExtensionWithSchema(MenuManager menu, IPluginExtension extension, IPluginParent parent) {
        ISchema schema = ExtensionsSection.getSchema(extension);
        ISchemaElement elementInfo = null;
        if (schema.getIncludes().length == 0 || parent == extension) {
            String tagName = parent == extension ? "extension" : parent.getName();
            elementInfo = schema.findElement(tagName);
        } else {
            ArrayDeque<String> stack = new ArrayDeque<String>();
            IPluginParent parentParent = parent;
            while (parentParent != extension && parentParent != null) {
                stack.push(parentParent.getName());
                parentParent = (IPluginParent)parentParent.getParent();
            }
            while (!stack.isEmpty()) {
                elementInfo = schema.findElement((String)stack.pop());
                schema = elementInfo.getSchema();
            }
        }
        if (elementInfo != null && elementInfo.getType() instanceof ISchemaComplexType && parent instanceof IDocumentElementNode) {
            NewElementAction action;
            TreeSet<ISchemaElement> elementSet = XMLElementProposalComputer.computeElementProposal(elementInfo, (IDocumentElementNode)parent);
            for (ISchemaElement element : elementSet) {
                if (element.isDeprecated()) continue;
                action = new NewElementAction(element, parent);
                menu.add((IAction)action);
            }
            menu.add((IContributionItem)new Separator());
            for (ISchemaElement element : elementSet) {
                if (!element.isDeprecated()) continue;
                action = new NewElementAction(element, parent);
                menu.add((IAction)action);
            }
        }
    }

    private static ISchema getSchema(IPluginParent parent) {
        if (parent instanceof IPluginExtension) {
            return ExtensionsSection.getSchema((IPluginExtension)parent);
        }
        if (parent instanceof IPluginElement) {
            return ExtensionsSection.getSchema((IPluginElement)parent);
        }
        return null;
    }

    private static ISchema getSchema(IPluginExtension extension) {
        String point = extension.getPoint();
        SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
        return registry.getSchema(point);
    }

    static ISchemaElement getSchemaElement(IPluginElement element) {
        ISchema schema = ExtensionsSection.getSchema(element);
        if (schema != null) {
            return schema.findElement(element.getName());
        }
        return null;
    }

    private static ISchema getSchema(IPluginElement element) {
        IPluginObject parent = element.getParent();
        while (parent != null && !(parent instanceof IPluginExtension)) {
            parent = parent.getParent();
        }
        if (parent != null) {
            return ExtensionsSection.getSchema((IPluginExtension)parent);
        }
        return null;
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        this.initializeImages();
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 2050, 2, toolkit);
        this.fExtensionTree = treePart.getTreeViewer();
        this.fExtensionTree.setContentProvider((IContentProvider)new ExtensionContentProvider());
        this.fExtensionTree.setLabelProvider((IBaseLabelProvider)new ExtensionLabelProvider());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setDescription(PDEUIMessages.ExtensionsSection_sectionDescExtensionsMaster);
        section.setText(PDEUIMessages.ManifestEditor_DetailExtension_title);
        this.initialize((IPluginModelBase)this.getPage().getModel());
        this.createSectionToolbar(section, toolkit);
        this.fFilteredTree.addMouseWheelListener(new AcceleratedTreeScrolling(this.fExtensionTree.getTree(), 15));
        toolkit.paintBordersFor(this.fFilteredTree.getParent());
        this.fFilteredTree.createUIListenerEntryFilter(this);
        Text filterText = this.fFilteredTree.getFilterControl();
        if (filterText != null) {
            filterText.addModifyListener(e -> {
                StructuredViewer viewer = this.getStructuredViewerPart().getViewer();
                IStructuredSelection ssel = viewer.getStructuredSelection();
                this.updateButtons(ssel.size() != 1 ? null : ssel);
            });
        }
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fSortAction = new SortAction((StructuredViewer)this.fExtensionTree, PDEUIMessages.ExtensionsPage_sortAlpha, null, null, this){

            @Override
            public void run() {
                Object[] expanded = ExtensionsSection.this.fFilteredTree.getViewer().getVisibleExpandedElements();
                try {
                    ExtensionsSection.this.fFilteredTree.setRedraw(false);
                    super.run();
                    ExtensionsSection.this.fFilteredTree.getViewer().setExpandedElements(expanded);
                }
                finally {
                    ExtensionsSection.this.fFilteredTree.setRedraw(true);
                }
            }
        };
        toolBarManager.add((IAction)this.fSortAction);
        this.fExpandAction = new ToggleExpandStateAction(this.fFilteredTree, this.fExtensionTree);
        toolBarManager.add((IAction)this.fExpandAction);
        this.fCollapseAction = new CollapseAction((AbstractTreeViewer)this.fExtensionTree, PDEUIMessages.ExtensionsPage_collapseAll);
        toolBarManager.add((IAction)this.fCollapseAction);
        this.fFilterRelatedAction = new FilterRelatedExtensionsAction(this.fExtensionTree, this.fFilteredTree, this);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateButtons(selection);
        this.getTreePart().getButton(2).setVisible(this.isSelectionEditable(selection));
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 1: {
                this.handleDelete();
                break;
            }
            case 2: {
                this.handleEdit();
                break;
            }
            case 3: {
                this.handleMove(true);
                break;
            }
            case 4: {
                this.handleMove(false);
            }
        }
    }

    public void dispose() {
        if (this.fFilteredTree != null) {
            this.fFilteredTree.dispose();
        }
        this.fEditorWizards = null;
        IPluginModelBase model = (IPluginModelBase)this.getPage().getPDEEditor().getAggregateModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.FIND.getId()) && this.fFilterRelatedAction != null) {
            this.fFilterRelatedAction.run();
            return true;
        }
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            if (this.isSingleSelection()) {
                this.handleDelete();
            }
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            if (this.isSingleSelection()) {
                this.doPaste();
            }
            return true;
        }
        return super.doGlobalAction(actionId);
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IPluginExtension || object instanceof IPluginElement) {
            this.fExtensionTree.setSelection((ISelection)new StructuredSelection(object), true);
            return true;
        }
        return false;
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        ITreeSelection selection = this.fExtensionTree.getStructuredSelection();
        if (selection.size() == 1) {
            IPluginParent parent;
            Object object = selection.getFirstElement();
            if (object instanceof IPluginParent && (parent = (IPluginParent)object).getModel().getUnderlyingResource() != null) {
                boolean removeEnabled = !this.fFilteredTree.isFiltered() || this.isRemoveEnabled((IStructuredSelection)selection);
                ExtensionsSection.fillContextMenu(this.getPage(), parent, manager, false, removeEnabled);
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IContributionItem)new Separator());
            if (object instanceof IPluginExtension) {
                PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
                actionGroup.setContext(new ActionContext((ISelection)selection));
                actionGroup.fillContextMenu(manager);
                manager.add((IContributionItem)new Separator());
            }
        } else if (selection.size() > 1) {
            Action delAction = new Action(){

                public ImageDescriptor getImageDescriptor() {
                    return PDEPluginImages.DESC_DELETE;
                }

                public ImageDescriptor getDisabledImageDescriptor() {
                    return PDEPluginImages.DESC_REMOVE_ATT_DISABLED;
                }

                public void run() {
                    ExtensionsSection.this.handleDelete();
                }
            };
            delAction.setText(PDEUIMessages.ExtensionsSection_Remove);
            manager.add((IAction)delAction);
            manager.add((IContributionItem)new Separator());
            delAction.setEnabled(this.isEditable() && this.isRemoveEnabled((IStructuredSelection)selection));
        }
        if (!selection.isEmpty() && ExtensionsFilterUtil.isFilterRelatedEnabled((IStructuredSelection)selection)) {
            manager.add((IAction)this.fFilterRelatedAction);
        }
        if (this.fFilteredTree.isFiltered()) {
            manager.add((IAction)new Action(){

                public String getText() {
                    return PDEUIMessages.ShowAllExtensionsAction_label;
                }

                public void run() {
                    Text filterText = ExtensionsSection.this.fFilteredTree.getFilterControl();
                    ExtensionsSection.this.setBypassFilterDelay(true);
                    filterText.setText("");
                }
            });
        }
        manager.add((IContributionItem)new Separator());
        if (selection.size() < 2) {
            this.getPage().getPDEEditor().getContributor().addClipboardActions(manager);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager, false);
        this.fFilteredTree.update();
    }

    static IMenuManager fillContextMenu(PDEFormPage page, IPluginParent parent, IMenuManager manager) {
        return ExtensionsSection.fillContextMenu(page, parent, manager, false);
    }

    static IMenuManager fillContextMenu(PDEFormPage page, IPluginParent parent, IMenuManager manager, boolean addSiblingItems) {
        return ExtensionsSection.fillContextMenu(page, parent, manager, addSiblingItems, true);
    }

    static IMenuManager fillContextMenu(PDEFormPage page, final IPluginParent parent, IMenuManager manager, boolean addSiblingItems, boolean fullMenu) {
        MenuManager menu = new MenuManager(PDEUIMessages.Menus_new_label, MENU_NEW_ID);
        IPluginExtension extension = ExtensionsSection.getExtension(parent);
        ISchema schema = ExtensionsSection.getSchema(extension);
        if (schema == null) {
            menu.add((IAction)new NewElementAction(null, parent));
        } else {
            IPluginObject parentsParent;
            ExtensionsSection.addItemsForExtensionWithSchema(menu, extension, parent);
            if (addSiblingItems && !((parentsParent = parent.getParent()) instanceof IPluginExtension)) {
                IPluginParent pparent = (IPluginParent)parentsParent;
                menu.add((IContributionItem)new Separator());
                ExtensionsSection.addItemsForExtensionWithSchema(menu, extension, pparent);
            }
        }
        manager.add((IContributionItem)menu);
        manager.add((IContributionItem)new Separator());
        if (fullMenu) {
            Action deleteAction = new Action(PDEUIMessages.ExtensionsSection_Remove){

                public void run() {
                    try {
                        IPluginObject parentsParent = parent.getParent();
                        if (parent instanceof IPluginExtension) {
                            IPluginBase plugin = (IPluginBase)parentsParent;
                            plugin.remove((IPluginExtension)parent);
                        } else {
                            IPluginParent parentElement = (IPluginParent)parent.getParent();
                            parentElement.remove((IPluginObject)parent);
                        }
                    }
                    catch (CoreException coreException) {}
                }

                public ImageDescriptor getImageDescriptor() {
                    return PDEPluginImages.DESC_DELETE;
                }

                public ImageDescriptor getDisabledImageDescriptor() {
                    return PDEPluginImages.DESC_REMOVE_ATT_DISABLED;
                }
            };
            deleteAction.setEnabled(page.getModel().isEditable());
            manager.add((IAction)deleteAction);
        }
        return menu;
    }

    static IPluginExtension getExtension(IPluginParent parent) {
        while (parent != null && !(parent instanceof IPluginExtension)) {
            parent = (IPluginParent)parent.getParent();
        }
        return (IPluginExtension)parent;
    }

    private void handleDelete() {
        ITreeSelection sel = this.fExtensionTree.getStructuredSelection();
        if (sel.isEmpty()) {
            return;
        }
        for (IPluginObject object : sel) {
            try {
                int index;
                int index2;
                boolean sorted;
                StructuredSelection newSelection = null;
                boolean bl = sorted = this.fSortAction != null && this.fSortAction.isChecked();
                if (object instanceof IPluginElement) {
                    IPluginElement ee = (IPluginElement)object;
                    IPluginParent parent = (IPluginParent)ee.getParent();
                    if (!sorted) {
                        index2 = this.getNewSelectionIndex(parent.getIndexOf((IPluginObject)ee), parent.getChildCount());
                        newSelection = index2 == -1 ? new StructuredSelection((Object)parent) : new StructuredSelection((Object)parent.getChildren()[index2]);
                    } else {
                        Object[] objects = (IPluginObject[])parent.getChildren().clone();
                        this.fExtensionTree.getComparator().sort((Viewer)this.fExtensionTree, objects);
                        index = this.getNewSelectionIndex(this.getArrayIndex(objects, ee), objects.length);
                        newSelection = index == -1 ? new StructuredSelection((Object)parent) : new StructuredSelection(objects[index]);
                    }
                    parent.remove((IPluginObject)ee);
                } else if (object instanceof IPluginExtension) {
                    IPluginExtension extension = (IPluginExtension)object;
                    IPluginBase plugin = extension.getPluginBase();
                    if (!sorted) {
                        index2 = this.getNewSelectionIndex(plugin.getIndexOf(extension), plugin.getExtensions().length);
                        if (index2 != -1) {
                            newSelection = new StructuredSelection((Object)plugin.getExtensions()[index2]);
                        }
                    } else {
                        Object[] extensions = (IPluginExtension[])plugin.getExtensions().clone();
                        this.fExtensionTree.getComparator().sort((Viewer)this.fExtensionTree, extensions);
                        index = this.getNewSelectionIndex(this.getArrayIndex(extensions, extension), extensions.length);
                        if (index != -1) {
                            newSelection = new StructuredSelection(extensions[index]);
                        }
                    }
                    plugin.remove(extension);
                }
                if (newSelection == null) continue;
                this.fExtensionTree.setSelection(newSelection);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public FormFilteredTree getFormFilteredTree() {
        return this.fFilteredTree;
    }

    public void addAttributeToFilter(String attributeValue, boolean clearFilterText) {
        String trimmedValue;
        Text filterControl = this.fFilteredTree.getFilterControl();
        if (filterControl != null && attributeValue != null && (trimmedValue = attributeValue.trim()).length() > 0 && !ExtensionsFilterUtil.isBoolean(trimmedValue)) {
            String filterPattern;
            if (trimmedValue.startsWith("%")) {
                IPluginModelBase model = this.getPluginModelBase();
                trimmedValue = (model != null ? model.getResourceString(trimmedValue) : trimmedValue).replaceAll("\"", "");
            }
            if (clearFilterText) {
                filterPattern = trimmedValue;
            } else {
                filterPattern = filterControl.getText();
                if (filterPattern.length() > 0 && !filterPattern.endsWith("/")) {
                    filterPattern = String.valueOf(filterPattern) + "/";
                }
                filterPattern = String.valueOf(filterPattern) + trimmedValue;
            }
            if (filterPattern.indexOf(47) != -1) {
                filterPattern = "\"" + filterPattern + "\"";
            }
            this.setBypassFilterDelay(true);
            filterControl.setText(filterPattern);
        }
    }

    private void handleNew() {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        BusyIndicator.showWhile((Display)this.fExtensionTree.getTree().getDisplay(), () -> {
            ((ManifestEditor)this.getPage().getEditor()).ensurePluginContextPresence();
            NewExtensionWizard wizard = new NewExtensionWizard(project, (IPluginModelBase)this.getPage().getModel(), (ManifestEditor)this.getPage().getPDEEditor()){

                @Override
                public boolean performFinish() {
                    return super.performFinish();
                }
            };
            WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
            dialog.create();
            SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
            dialog.open();
        });
    }

    private void handleEdit(IConfigurationElement element, IStructuredSelection selection) {
        IProject project = this.getPage().getPDEEditor().getCommonProject();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        try {
            IExtensionEditorWizard wizard = (IExtensionEditorWizard)element.createExecutableExtension("class");
            wizard.init(project, model, selection);
            BusyIndicator.showWhile((Display)this.fExtensionTree.getTree().getDisplay(), () -> {
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                dialog.open();
            });
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleEdit() {
        ITreeSelection selection = this.fExtensionTree.getStructuredSelection();
        ArrayList<?> editorWizards = this.getEditorWizards((IStructuredSelection)selection);
        if (editorWizards == null) {
            return;
        }
        if (editorWizards.size() == 1) {
            this.handleEdit((IConfigurationElement)editorWizards.get(0), (IStructuredSelection)selection);
        } else {
            IProject project = this.getPage().getPDEEditor().getCommonProject();
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            ExtensionEditorWizard wizard = new ExtensionEditorWizard(project, model, (IStructuredSelection)selection);
            BusyIndicator.showWhile((Display)this.fExtensionTree.getTree().getDisplay(), () -> {
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                dialog.open();
            });
        }
    }

    @Override
    protected void handleSelectAll() {
        this.fExtensionTree.getTree().selectAll();
        this.updateButtons(this.fFilteredTree.getViewer().getSelection());
    }

    private ArrayList<?> getEditorWizards(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object obj = selection.getFirstElement();
        String pointId = null;
        if (obj instanceof IPluginExtension) {
            pointId = ((IPluginExtension)obj).getPoint();
        } else if (obj instanceof IPluginElement) {
            IPluginObject parent = ((IPluginElement)obj).getParent();
            while (parent != null) {
                if (parent instanceof IPluginExtension) {
                    pointId = ((IPluginExtension)parent).getPoint();
                    break;
                }
                parent = parent.getParent();
            }
        }
        if (pointId == null) {
            return null;
        }
        if (this.fEditorWizards == null) {
            this.loadExtensionWizards();
        }
        return this.fEditorWizards.get(pointId);
    }

    private void loadExtensionWizards() {
        IConfigurationElement[] elements;
        this.fEditorWizards = new Hashtable();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.ui.newExtension");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String pointId;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("editorWizard") && (pointId = element.getAttribute("point")) != null) {
                ArrayList<Object> list = this.fEditorWizards.get(pointId);
                if (list == null) {
                    list = new ArrayList();
                    this.fEditorWizards.put(pointId, list);
                }
                list.add(element);
            }
            ++n2;
        }
    }

    private boolean isSelectionEditable(IStructuredSelection selection) {
        if (!this.getPage().getModel().isEditable()) {
            return false;
        }
        return this.getEditorWizards(selection) != null;
    }

    public void initialize(IPluginModelBase model) {
        this.fExtensionTree.setInput((Object)model.getPluginBase());
        this.selectFirstExtension();
        boolean editable = model.isEditable();
        TreePart treePart = this.getTreePart();
        treePart.setButtonEnabled(0, editable);
        treePart.setButtonEnabled(1, false);
        treePart.setButtonEnabled(2, false);
        treePart.setButtonEnabled(3, false);
        treePart.setButtonEnabled(4, false);
        model.addModelChangedListener((IModelChangedListener)this);
    }

    private void selectFirstExtension() {
        Tree tree = this.fExtensionTree.getTree();
        TreeItem[] items = tree.getItems();
        if (items.length == 0) {
            return;
        }
        TreeItem firstItem = items[0];
        Object obj = firstItem.getData();
        this.fExtensionTree.setSelection((ISelection)new StructuredSelection(obj));
    }

    void fireSelection() {
        this.fExtensionTree.setSelection(this.fExtensionTree.getSelection());
    }

    public void initializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.fExtensionImage = provider.get(PDEPluginImages.DESC_EXTENSION_OBJ);
        this.fGenericElementImage = provider.get(PDEPluginImages.DESC_GENERIC_XML_OBJ);
    }

    public void refresh() {
        Object[] expanded = this.fExtensionTree.getExpandedElements();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        int[] indexPath = ExtensionsSection.getTreeIndexPath(this.fExtensionTree.getTree());
        try {
            this.fExtensionTree.getControl().setRedraw(false);
            this.fExtensionTree.setInput((Object)model.getPluginBase());
            this.fExtensionTree.setExpandedElements(expanded);
            this.reportMissingExtensionPointSchemas(model.getPluginBase());
            this.getManagedForm().fireSelectionChanged((IFormPart)this, this.fExtensionTree.getSelection());
            super.refresh();
            if (indexPath != null) {
                ExtensionsSection.revealTopItem(this.fExtensionTree.getTree(), indexPath);
            }
        }
        finally {
            this.fExtensionTree.getControl().setRedraw(true);
        }
    }

    private static int[] getTreeIndexPath(Tree tree) {
        int[] indexPath = null;
        if (tree != null) {
            TreeItem item = tree.getTopItem();
            int count = 1;
            while (item != null && (item = item.getParentItem()) != null) {
                ++count;
            }
            indexPath = new int[count];
            int index = 0;
            item = tree.getTopItem();
            while (item != null && index < count) {
                TreeItem parent = item.getParentItem();
                indexPath[index++] = parent != null ? parent.indexOf(item) : tree.indexOf(item);
                item = parent;
            }
        }
        return indexPath;
    }

    private static void revealTopItem(Tree tree, int[] indexPath) {
        TreeItem itemFound = null;
        int i = indexPath.length - 1;
        while (i >= 0) {
            int index = indexPath[i];
            if (itemFound != null) {
                itemFound = itemFound.getItemCount() > index ? itemFound.getItem(indexPath[i]) : null;
            } else if (i == indexPath.length - 1) {
                itemFound = tree.getItemCount() > index ? tree.getItem(indexPath[i]) : null;
            }
            --i;
        }
        if (itemFound != null) {
            tree.setTopItem(itemFound);
        }
    }

    @Override
    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginBase && event.getChangeType() == 3 && event.getChangedProperty().equals("extension_order")) {
            ITreeSelection sel = this.fExtensionTree.getStructuredSelection();
            IPluginExtension extension = (IPluginExtension)sel.getFirstElement();
            this.fExtensionTree.refresh();
            this.fExtensionTree.setSelection((ISelection)new StructuredSelection((Object)extension));
            return;
        }
        if (changeObject instanceof IPluginExtension || changeObject instanceof IPluginElement && ((IPluginElement)changeObject).getParent() instanceof IPluginParent) {
            IPluginObject parent;
            IPluginObject pobj = (IPluginObject)changeObject;
            Object object = parent = changeObject instanceof IPluginExtension ? ((IPluginModelBase)this.getPage().getModel()).getPluginBase() : pobj.getParent();
            if (event.getChangeType() == 1) {
                IPluginExtension ext;
                if (this.fFilteredTree.isFiltered()) {
                    Object[] inserted;
                    Object[] objectArray = inserted = event.getChangedObjects();
                    int n = inserted.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object insertedObject = objectArray[n2];
                        this.fPatternFilter.addElement(insertedObject);
                        ++n2;
                    }
                    if (inserted.length == 1) {
                        this.fFilteredTree.getViewer().setSelection((ISelection)new StructuredSelection(inserted[0]));
                    }
                }
                this.fExtensionTree.refresh((Object)parent);
                if (changeObject instanceof IPluginExtension && (ext = (IPluginExtension)changeObject).getSchema() == null) {
                    this.reportMissingExtensionPointSchema(ext.getPoint());
                }
                this.fExtensionTree.setSelection((ISelection)new StructuredSelection(changeObject), true);
                this.fExtensionTree.getTree().setFocus();
            } else if (event.getChangeType() == 2) {
                if (changeObject instanceof IPluginExtension) {
                    IPluginExtension ext = (IPluginExtension)changeObject;
                    IPluginExtension[] extensions = ((IPluginBase)parent).getExtensions();
                    boolean found = false;
                    IPluginExtension[] iPluginExtensionArray = extensions;
                    int n = extensions.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IPluginExtension extension = iPluginExtensionArray[n3];
                        String point = extension.getPoint();
                        if (ext.getPoint().equals(point)) {
                            found = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!found) {
                        this.getManagedForm().getMessageManager().removeMessage((Object)ext.getPoint());
                    }
                }
                this.fExtensionTree.remove((Object)pobj);
            } else if (event.getChangedProperty().equals("sibling_order")) {
                ITreeSelection sel = this.fExtensionTree.getStructuredSelection();
                IPluginObject child = (IPluginObject)sel.getFirstElement();
                this.fExtensionTree.refresh((Object)child.getParent());
                this.fExtensionTree.setSelection((ISelection)new StructuredSelection((Object)child));
            } else {
                this.fExtensionTree.update(changeObject, null);
            }
        }
    }

    private Image resolveObjectImage(Object obj) {
        if (obj instanceof IPluginExtension) {
            return this.fExtensionImage;
        }
        Image elementImage = this.fGenericElementImage;
        if (obj instanceof IPluginElement) {
            IPluginElement element = (IPluginElement)obj;
            Image customImage = ExtensionsSection.getCustomImage(element);
            if (customImage == null) {
                customImage = PDEPlugin.getDefault().getLabelProvider().getImage(obj);
            }
            if (customImage != null) {
                elementImage = customImage;
            }
        }
        return elementImage;
    }

    private static boolean isStorageModel(IPluginObject object) {
        IPluginModelBase modelBase = object.getPluginModel();
        return modelBase.getInstallLocation() == null;
    }

    static Image getCustomImage(IPluginElement element) {
        if (ExtensionsSection.isStorageModel((IPluginObject)element)) {
            return null;
        }
        ISchemaElement elementInfo = ExtensionsSection.getSchemaElement(element);
        if (elementInfo != null && elementInfo.getIconProperty() != null) {
            String iconProperty = elementInfo.getIconProperty();
            IPluginAttribute att = element.getAttribute(iconProperty);
            String iconPath = null;
            if (att != null && att.getValue() != null) {
                iconPath = att.getValue();
            }
            if (iconPath != null) {
                String ext = new Path(iconPath).getFileExtension();
                if (ext == null) {
                    return null;
                }
                boolean valid = false;
                String[] stringArray = VALID_IMAGE_TYPES;
                int n = VALID_IMAGE_TYPES.length;
                int n2 = 0;
                while (n2 < n) {
                    String imageType = stringArray[n2];
                    if (ext.equalsIgnoreCase(imageType)) {
                        valid = true;
                        break;
                    }
                    ++n2;
                }
                return valid ? ExtensionsSection.getImageFromPlugin(element, iconPath) : null;
            }
        }
        return null;
    }

    private static Image getImageFromPlugin(IPluginElement element, String iconPathName) {
        if (iconPathName.startsWith("%")) {
            return null;
        }
        IPluginModelBase model = element.getPluginModel();
        if (model == null) {
            return null;
        }
        return PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(model, iconPathName);
    }

    private String resolveObjectName(Object obj) {
        return ExtensionsSection.resolveObjectName(this.getSchemaRegistry(), obj);
    }

    private SchemaRegistry getSchemaRegistry() {
        if (this.fSchemaRegistry == null) {
            this.fSchemaRegistry = PDECore.getDefault().getSchemaRegistry();
        }
        return this.fSchemaRegistry;
    }

    public static String resolveObjectName(SchemaRegistry schemaRegistry, Object obj) {
        boolean fullNames = PDEPlugin.isFullNameModeEnabled();
        if (obj instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)obj;
            if (!fullNames) {
                return extension.getPoint();
            }
            if (extension.getName() != null) {
                return extension.getTranslatedName();
            }
            ISchema schema = schemaRegistry.getSchema(extension.getPoint());
            if (schema != null) {
                return schema.getName();
            }
            return extension.getPoint();
        }
        if (obj instanceof IPluginElement) {
            IPluginElement element = (IPluginElement)obj;
            String baseName = element.getName();
            String fullName = null;
            ISchemaElement elementInfo = ExtensionsSection.getSchemaElement(element);
            IPluginAttribute labelAtt = null;
            if (elementInfo != null && elementInfo.getLabelProperty() != null) {
                labelAtt = element.getAttribute(elementInfo.getLabelProperty());
            }
            if (labelAtt == null) {
                String[] stringArray = COMMON_LABEL_ATTRIBUTES;
                int n = COMMON_LABEL_ATTRIBUTES.length;
                int n2 = 0;
                while (n2 < n) {
                    String labelAttribute = stringArray[n2];
                    labelAtt = element.getAttribute(labelAttribute);
                    if (labelAtt != null && labelAtt.getValue().length() > 0) break;
                    ++n2;
                }
                if (labelAtt == null && element.getAttributeCount() == 1) {
                    labelAtt = element.getAttributes()[0];
                }
            }
            if (labelAtt != null && labelAtt.getValue() != null) {
                fullName = ExtensionsSection.stripShortcuts(labelAtt.getValue());
                if (labelAtt.getName().equals(COMMON_LABEL_ATTRIBUTES[3])) {
                    fullName = fullName.substring(fullName.lastIndexOf(46) + 1, fullName.length());
                }
            }
            fullName = element.getResourceString(fullName);
            if (fullNames) {
                return fullName != null ? fullName : baseName;
            }
            if (fullName == null) {
                return baseName;
            }
            if (BidiUtil.isBidiPlatform()) {
                return String.valueOf(fullName) + " \u200f(\u200e" + baseName + ")";
            }
            return String.valueOf(fullName) + " (" + baseName + ')';
        }
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    @Override
    public void setFocus() {
        if (this.fExtensionTree != null) {
            this.fExtensionTree.getTree().setFocus();
        }
    }

    public void setBypassFilterDelay(boolean bypassFilterDelay) {
        this.fBypassFilterDelay = bypassFilterDelay;
    }

    public static String stripShortcuts(String input) {
        StringBuilder output = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c != '&') {
                if (c == '@') break;
                output.append(c);
            }
            ++i;
        }
        return output.toString();
    }

    @Override
    public boolean canCopy(ISelection selection) {
        if (this.fFilteredTree.getFilterControl().isFocusControl() && !selection.isEmpty()) {
            return true;
        }
        return super.canCopy(selection);
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        if (this.fFilteredTree.getFilterControl().isFocusControl()) {
            return true;
        }
        return super.canPaste(clipboard);
    }

    @Override
    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        boolean allExtensions = true;
        boolean allElements = true;
        Object[] objectArray = sourceObjects;
        int n = sourceObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object sourceObject = objectArray[n2];
            if (sourceObject instanceof IPluginExtension) {
                allElements = false;
            } else if (sourceObject instanceof IPluginElement) {
                allExtensions = false;
            } else {
                return false;
            }
            ++n2;
        }
        if (allExtensions) {
            return true;
        }
        if (!allElements) {
            return false;
        }
        if (!(targetObject instanceof IPluginParent)) {
            return false;
        }
        if (!(targetObject instanceof IDocumentElementNode)) {
            return false;
        }
        IPluginParent targetParent = (IPluginParent)targetObject;
        ISchema schema = ExtensionsSection.getSchema(targetParent);
        if (schema == null) {
            return true;
        }
        String tagName = ((IDocumentElementNode)targetParent).getXMLTagName();
        ISchemaElement schemaElement = schema.findElement(tagName);
        if (schemaElement == null) {
            return false;
        }
        if (!(schemaElement.getType() instanceof ISchemaComplexType)) {
            return false;
        }
        TreeSet<ISchemaElement> elementSet = XMLElementProposalComputer.computeElementProposal(schemaElement, (IDocumentElementNode)targetObject);
        if (sourceObjects.length > 1) {
            IPluginElement[] sourcePluginElements = new IPluginElement[sourceObjects.length];
            System.arraycopy(sourceObjects, 0, sourcePluginElements, 0, sourceObjects.length);
            return this.canPasteSourceElements(sourcePluginElements, elementSet);
        }
        return this.canPasteSourceElement((IPluginElement)sourceObjects[0], elementSet);
    }

    private boolean canPasteSourceElements(IPluginElement[] sourceElements, TreeSet<?> targetElementSet) {
        HashSet<String> targetElementNameSet = new HashSet<String>();
        Iterator<?> iterator = targetElementSet.iterator();
        while (iterator.hasNext()) {
            targetElementNameSet.add(((ISchemaElement)iterator.next()).getName());
        }
        IPluginElement[] iPluginElementArray = sourceElements;
        int n = sourceElements.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginElement sourceElement = iPluginElementArray[n2];
            String sourceTagName = sourceElement.getName();
            if (!targetElementNameSet.contains(sourceTagName)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean canPasteSourceElement(IPluginElement sourceElement, TreeSet<?> targetElementSet) {
        boolean canPaste = false;
        String sourceTagName = sourceElement.getName();
        Iterator<?> iterator = targetElementSet.iterator();
        while (iterator.hasNext()) {
            String targetTagName = ((ISchemaElement)iterator.next()).getName();
            if (!sourceTagName.equals(targetTagName)) continue;
            canPaste = true;
            break;
        }
        return canPaste;
    }

    private IPluginModelBase getPluginModelBase() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (!(model instanceof IBundlePluginModelBase)) {
            return null;
        }
        ISharedExtensionsModel extensionModel = ((IBundlePluginModelBase)model).getExtensionsModel();
        if (extensionModel == null || !(extensionModel instanceof IPluginModelBase)) {
            return null;
        }
        return (IPluginModelBase)extensionModel;
    }

    @Override
    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        ((ManifestEditor)this.getPage().getEditor()).ensurePluginContextPresence();
        IPluginModelBase model = this.getPluginModelBase();
        if (model == null) {
            return;
        }
        IPluginBase pluginBase = model.getPluginBase();
        try {
            Object[] objectArray = sourceObjects;
            int n = sourceObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object sourceObject = objectArray[n2];
                if (sourceObject instanceof IPluginExtension && pluginBase instanceof IDocumentElementNode) {
                    IDocumentElementNode extension = (IDocumentElementNode)sourceObject;
                    extension.reconnect((IDocumentElementNode)pluginBase, (IModel)model);
                    pluginBase.add((IPluginExtension)extension);
                } else if (sourceObject instanceof IPluginElement && targetObject instanceof IPluginParent && targetObject instanceof IDocumentElementNode) {
                    IDocumentElementNode element = (IDocumentElementNode)sourceObject;
                    element.reconnect((IDocumentElementNode)targetObject, (IModel)model);
                    ((IPluginParent)targetObject).add((IPluginObject)((IPluginElement)element));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleMove(boolean up) {
        ITreeSelection sel = this.fExtensionTree.getStructuredSelection();
        IPluginObject object = (IPluginObject)sel.getFirstElement();
        if (object instanceof IPluginElement) {
            IPluginParent parent = (IPluginParent)object.getParent();
            IPluginObject[] children = parent.getChildren();
            int index = parent.getIndexOf(object);
            int newIndex = up ? index - 1 : index + 1;
            IPluginObject child2 = children[newIndex];
            try {
                parent.swap(object, child2);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        } else if (object instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)object;
            IPluginBase plugin = extension.getPluginBase();
            IPluginExtension[] extensions = plugin.getExtensions();
            int index = plugin.getIndexOf(extension);
            int newIndex = up ? index - 1 : index + 1;
            IPluginExtension e2 = extensions[newIndex];
            try {
                plugin.swap(extension, e2);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void updateButtons(Object item) {
        boolean sorted;
        if (this.fExpandAction != null) {
            this.fExpandAction.setEnabled(ToggleExpandStateAction.isExpandable((IStructuredSelection)this.fExtensionTree.getStructuredSelection()));
        }
        if (this.fFilterRelatedAction != null) {
            boolean filterRelatedEnabled = false;
            if (this.fExtensionTree != null) {
                filterRelatedEnabled = ExtensionsFilterUtil.isFilterRelatedEnabled((IStructuredSelection)this.fExtensionTree.getStructuredSelection());
            }
            this.fFilterRelatedAction.setEnabled(filterRelatedEnabled);
        }
        if (!this.getPage().getModel().isEditable()) {
            return;
        }
        boolean bl = sorted = this.fSortAction != null && this.fSortAction.isChecked();
        if (sorted) {
            this.getTreePart().setButtonEnabled(3, false);
            this.getTreePart().setButtonEnabled(4, false);
            return;
        }
        IStructuredSelection selection = item instanceof IStructuredSelection ? (IStructuredSelection)item : null;
        boolean filtered = this.fFilteredTree.isFiltered();
        boolean addEnabled = true;
        boolean removeEnabled = true;
        boolean upEnabled = false;
        boolean downEnabled = false;
        if (filtered) {
            addEnabled = true;
            upEnabled = false;
            downEnabled = false;
            removeEnabled = this.isRemoveEnabled(selection);
        } else if (selection != null && selection.size() == 1) {
            Object selected = selection.getFirstElement();
            if (selected instanceof IPluginElement) {
                IPluginElement element = (IPluginElement)selected;
                IPluginParent parent = (IPluginParent)element.getParent();
                int index = parent.getIndexOf((IPluginObject)element);
                if (index > 0) {
                    upEnabled = true;
                }
                if (index < parent.getChildCount() - 1) {
                    downEnabled = true;
                }
            } else if (selected instanceof IPluginExtension) {
                IPluginExtension extension = (IPluginExtension)selected;
                IExtensions extensions = (IExtensions)extension.getParent();
                int index = extensions.getIndexOf(extension);
                int size = extensions.getExtensions().length;
                if (index > 0) {
                    upEnabled = true;
                }
                if (index < size - 1) {
                    downEnabled = true;
                }
            }
        }
        this.getTreePart().setButtonEnabled(0, addEnabled);
        this.getTreePart().setButtonEnabled(1, removeEnabled);
        this.getTreePart().setButtonEnabled(3, upEnabled);
        this.getTreePart().setButtonEnabled(4, downEnabled);
    }

    boolean isRemoveEnabled(IStructuredSelection selection) {
        if (selection != null) {
            for (Object element : selection) {
                if (!(element instanceof PluginExtensionNode)) continue;
                return ((PluginExtensionNode)element).getChildCount() == 0;
            }
        }
        return true;
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent, int style) {
        this.fPatternFilter = new ExtensionsPatternFilter();
        this.fFilteredTree = new FormFilteredTree(parent, style, this.fPatternFilter){

            protected WorkbenchJob doCreateRefreshJob() {
                WorkbenchJob job = super.doCreateRefreshJob();
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
                    private ISelection selection;
                    private boolean aboutToRunPassed = false;

                    public void scheduled(IJobChangeEvent event) {
                        ((ExtensionsPatternFilter)(this).ExtensionsSection.this.fFilteredTree.getPatternFilter()).clearMatchingLeafs();
                        this.selection = (this).ExtensionsSection.this.fExtensionTree.getSelection();
                    }

                    public void aboutToRun(IJobChangeEvent event) {
                        this.aboutToRunPassed = true;
                    }

                    public void done(IJobChangeEvent event) {
                        if (this.aboutToRunPassed) {
                            try {
                                Object[] leafs;
                                (this).ExtensionsSection.this.fFilteredTree.setRedraw(false);
                                ExtensionsPatternFilter extensionsPatternFilter = (ExtensionsPatternFilter)(this).ExtensionsSection.this.fFilteredTree.getPatternFilter();
                                (this).ExtensionsSection.this.fExtensionTree.collapseAll();
                                Object[] objectArray = leafs = extensionsPatternFilter.getMatchingLeafsAsArray();
                                int n = leafs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object leaf = objectArray[n2];
                                    (this).ExtensionsSection.this.fExtensionTree.expandToLevel(leaf, 0);
                                    ++n2;
                                }
                                if (this.selection != null && !this.selection.isEmpty()) {
                                    (this).ExtensionsSection.this.fExtensionTree.setSelection(this.selection, true);
                                }
                            }
                            finally {
                                (this).ExtensionsSection.this.fFilteredTree.setRedraw(true);
                            }
                        }
                    }
                });
                return job;
            }

            protected long getRefreshJobDelay() {
                long delay = ExtensionsSection.this.fBypassFilterDelay ? 0 : 1200;
                ExtensionsSection.this.setBypassFilterDelay(false);
                return delay;
            }

            protected void clearText() {
                this.setFilterText("");
            }

            protected void textChanged() {
                String filterText = this.getFilterString();
                if (filterText != null && filterText.length() == 0) {
                    ExtensionsSection.this.setBypassFilterDelay(true);
                }
                super.textChanged();
            }
        };
        parent.setData("filtered", (Object)Boolean.TRUE);
        return this.fFilteredTree.getViewer();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (((Object)((Object)this.fSortAction)).equals(event.getSource()) && "result".equals(event.getProperty())) {
            StructuredViewer viewer = this.getStructuredViewerPart().getViewer();
            IStructuredSelection ssel = viewer.getStructuredSelection();
            this.updateButtons(ssel);
        }
    }

    protected void selectExtensionElement(ISelection selection) {
        this.fExtensionTree.setSelection(selection, true);
    }

    @Override
    protected boolean isDragAndDropEnabled() {
        return true;
    }

    @Override
    public boolean canDragMove(Object[] sourceObjects) {
        if (!this.validateDragMoveSanity(sourceObjects)) {
            return false;
        }
        if (this.fFilteredTree.isFiltered()) {
            return false;
        }
        return !this.isTreeViewerSorted();
    }

    private boolean validateDropMoveSanity(Object targetObject, Object[] sourceObjects) {
        if (!(targetObject instanceof IPluginParent)) {
            return false;
        }
        if (!(targetObject instanceof IDocumentElementNode)) {
            return false;
        }
        return this.validateDragMoveSanity(sourceObjects);
    }

    private boolean validateDragMoveSanity(Object[] sourceObjects) {
        if (sourceObjects == null) {
            return false;
        }
        if (sourceObjects.length != 1) {
            return false;
        }
        if (!(sourceObjects[0] instanceof IDocumentElementNode)) {
            return false;
        }
        return sourceObjects[0] instanceof IPluginParent;
    }

    private boolean validateDropMoveModel(IPluginParent sourcePluginObject, IPluginParent targetPluginObject) {
        ISharedPluginModel targetModel;
        ISharedPluginModel sourceModel = sourcePluginObject.getModel();
        return sourceModel.equals(targetModel = targetPluginObject.getModel());
    }

    @Override
    public boolean canDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            return false;
        }
        IPluginParent sourcePluginObject = (IPluginParent)sourceObjects[0];
        IPluginParent targetPluginObject = (IPluginParent)targetObject;
        if (!this.validateDropMoveModel(sourcePluginObject, targetPluginObject)) {
            return false;
        }
        if (sourcePluginObject instanceof IPluginExtension) {
            IPluginExtension sourceExtensionObject = (IPluginExtension)sourcePluginObject;
            if (targetPluginObject instanceof IPluginExtension) {
                IPluginExtension targetExtensionObject = (IPluginExtension)targetPluginObject;
                return this.canDropMove(targetExtensionObject, sourceExtensionObject, targetLocation);
            }
            if (targetPluginObject instanceof IPluginElement) {
                return false;
            }
        } else if (sourcePluginObject instanceof IPluginElement) {
            IPluginElement sourceElementObject = (IPluginElement)sourcePluginObject;
            if (targetPluginObject instanceof IPluginExtension) {
                IPluginExtension targetExtensionObject = (IPluginExtension)targetPluginObject;
                return this.canDropMove(targetExtensionObject, sourceElementObject, targetLocation);
            }
            if (targetPluginObject instanceof IPluginElement) {
                IPluginElement targetElementObject = (IPluginElement)targetPluginObject;
                return this.canDropMove(targetElementObject, sourceElementObject, targetLocation);
            }
        }
        return false;
    }

    private boolean canDropMove(IPluginElement targetElementObject, IPluginElement sourceElementObject, int targetLocation) {
        if (!this.validateDropMoveParent(targetElementObject, sourceElementObject)) {
            return false;
        }
        if (targetLocation == 1) {
            IDocumentElementNode previousNode = ((IDocumentElementNode)targetElementObject).getPreviousSibling();
            if (sourceElementObject.equals(previousNode)) {
                return false;
            }
            IPluginObject targetParentObject = targetElementObject.getParent();
            if (!(targetParentObject instanceof IPluginParent)) {
                return false;
            }
            return this.validateDropMoveSchema((IPluginParent)targetParentObject, (IPluginParent)sourceElementObject);
        }
        if (targetLocation == 2) {
            IDocumentElementNode nextNode = ((IDocumentElementNode)sourceElementObject).getPreviousSibling();
            if (targetElementObject.equals(nextNode)) {
                return false;
            }
            IPluginObject targetParentObject = targetElementObject.getParent();
            if (!(targetParentObject instanceof IPluginParent)) {
                return false;
            }
            return this.validateDropMoveSchema((IPluginParent)targetParentObject, (IPluginParent)sourceElementObject);
        }
        if (targetLocation == 3) {
            IDocumentElementNode lastNode;
            IDocumentElementNode targetExtensionNode = (IDocumentElementNode)targetElementObject;
            int childCount = targetExtensionNode.getChildCount();
            if (childCount != 0 && sourceElementObject.equals(lastNode = targetExtensionNode.getChildAt(childCount - 1))) {
                return false;
            }
            return this.validateDropMoveSchema((IPluginParent)targetElementObject, (IPluginParent)sourceElementObject);
        }
        return false;
    }

    private boolean validateDropMoveParent(IPluginElement targetElementObject, IPluginElement sourceElementObject) {
        IPluginObject currentParent = targetElementObject.getParent();
        while (currentParent != null) {
            if (!(currentParent instanceof IPluginElement)) {
                return true;
            }
            if (sourceElementObject.equals(currentParent)) {
                return false;
            }
            currentParent = currentParent.getParent();
        }
        return true;
    }

    private boolean canDropMove(IPluginExtension targetExtensionObject, IPluginElement sourceElementObject, int targetLocation) {
        if (targetLocation == 1) {
            return false;
        }
        if (targetLocation == 2) {
            return false;
        }
        if (targetLocation == 3) {
            IDocumentElementNode lastNode;
            IDocumentElementNode targetExtensionNode = (IDocumentElementNode)targetExtensionObject;
            int childCount = targetExtensionNode.getChildCount();
            if (childCount != 0 && sourceElementObject.equals(lastNode = targetExtensionNode.getChildAt(childCount - 1))) {
                return false;
            }
            return this.validateDropMoveSchema((IPluginParent)targetExtensionObject, (IPluginParent)sourceElementObject);
        }
        return false;
    }

    private boolean validateDropMoveSchema(IPluginParent targetPluginObject, IPluginParent sourcePluginObject) {
        IDocumentElementNode targetPluginNode = (IDocumentElementNode)targetPluginObject;
        if (targetPluginObject.equals(sourcePluginObject.getParent())) {
            return true;
        }
        ISchema schema = ExtensionsSection.getSchema(targetPluginObject);
        if (schema == null) {
            return true;
        }
        String targetNodeTagName = targetPluginNode.getXMLTagName();
        ISchemaElement schemaElement = schema.findElement(targetNodeTagName);
        if (schemaElement == null) {
            return false;
        }
        if (!(schemaElement.getType() instanceof ISchemaComplexType)) {
            return false;
        }
        TreeSet<ISchemaElement> elementSet = XMLElementProposalComputer.computeElementProposal(schemaElement, targetPluginNode);
        Iterator<ISchemaElement> iterator = elementSet.iterator();
        while (iterator.hasNext()) {
            String targetTagName = iterator.next().getName();
            String sourceNodeTagName = ((IDocumentElementNode)sourcePluginObject).getXMLTagName();
            if (!sourceNodeTagName.equals(targetTagName)) continue;
            return true;
        }
        return false;
    }

    private boolean canDropMove(IPluginExtension targetExtensionObject, IPluginExtension sourceExtensionObject, int targetLocation) {
        if (targetLocation == 1) {
            IDocumentElementNode previousNode = ((IDocumentElementNode)targetExtensionObject).getPreviousSibling();
            return !sourceExtensionObject.equals(previousNode);
        }
        if (targetLocation == 2) {
            IDocumentElementNode nextNode = ((IDocumentElementNode)sourceExtensionObject).getPreviousSibling();
            return !targetExtensionObject.equals(nextNode);
        }
        if (targetLocation == 3) {
            return false;
        }
        return false;
    }

    @Override
    public void doDragRemove(Object[] sourceObjects) {
        if (!this.validateDragMoveSanity(sourceObjects)) {
            return;
        }
        IPluginParent pluginParentObject = (IPluginParent)sourceObjects[0];
        try {
            IPluginElement element;
            IPluginObject object;
            if (pluginParentObject instanceof IPluginExtension) {
                IPluginExtension extension = (IPluginExtension)pluginParentObject;
                IPluginBase pluginBase = pluginParentObject.getPluginBase();
                if (pluginBase != null) {
                    pluginBase.remove(extension);
                }
            } else if (pluginParentObject instanceof IPluginElement && (object = (element = (IPluginElement)pluginParentObject).getParent()) instanceof IPluginParent) {
                ((IPluginParent)object).remove((IPluginObject)element);
            }
            ((PDEFormEditor)this.getPage().getEditor()).getContextManager().getPrimaryContext().flushEditorInput();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    @Override
    public void doDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            Display.getDefault().beep();
            return;
        }
        IPluginParent sourcePluginObject = (IPluginParent)sourceObjects[0];
        IPluginParent targetPluginObject = (IPluginParent)targetObject;
        try {
            if (sourcePluginObject instanceof IPluginExtension) {
                IPluginExtension sourceExtensionObject = (IPluginExtension)sourcePluginObject;
                if (targetPluginObject instanceof IPluginExtension) {
                    IPluginExtension targetExtensionObject = (IPluginExtension)targetPluginObject;
                    this.doDropMove(targetExtensionObject, sourceExtensionObject, targetLocation);
                } else if (targetPluginObject instanceof IPluginElement) {
                    return;
                }
            } else if (sourcePluginObject instanceof IPluginElement) {
                IPluginElement sourceElementObject = (IPluginElement)sourcePluginObject;
                if (targetPluginObject instanceof IPluginExtension) {
                    IPluginExtension targetExtensionObject = (IPluginExtension)targetPluginObject;
                    this.doDropMove(targetExtensionObject, sourceElementObject, targetLocation);
                } else if (targetPluginObject instanceof IPluginElement) {
                    IPluginElement targetElementObject = (IPluginElement)targetPluginObject;
                    this.doDropMove(targetElementObject, sourceElementObject, targetLocation);
                }
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void doDropMove(IPluginExtension targetExtensionObject, IPluginExtension sourceExtensionObject, int targetLocation) throws CoreException {
        IPluginModelBase model = this.getPluginModelBase();
        if (model == null) {
            return;
        }
        IPluginBase pluginBase = model.getPluginBase();
        if (!(pluginBase instanceof IDocumentElementNode)) {
            return;
        }
        if (!(pluginBase instanceof PluginBaseNode)) {
            return;
        }
        IDocumentElementNode pluginBaseNode = (IDocumentElementNode)pluginBase;
        IDocumentElementNode sourceExtensionNode = (IDocumentElementNode)sourceExtensionObject;
        IDocumentElementNode targetExtensionNode = (IDocumentElementNode)targetExtensionObject;
        if (targetLocation == 1) {
            sourceExtensionNode.reconnect(pluginBaseNode, (IModel)model);
            int index = pluginBaseNode.indexOf(targetExtensionNode);
            if (index == -1) {
                return;
            }
            ((PluginBaseNode)pluginBaseNode).add(sourceExtensionObject, index);
        } else if (targetLocation == 2) {
            sourceExtensionNode.reconnect(pluginBaseNode, (IModel)model);
            int index = pluginBaseNode.indexOf(targetExtensionNode);
            if (index == -1) {
                return;
            }
            ((PluginBaseNode)pluginBaseNode).add(sourceExtensionObject, index + 1);
        }
    }

    private void doDropMove(IPluginExtension targetExtensionObject, IPluginElement sourceElementObject, int targetLocation) throws CoreException {
        IPluginModelBase model = this.getPluginModelBase();
        if (model == null) {
            return;
        }
        IDocumentElementNode targetExtensionNode = (IDocumentElementNode)targetExtensionObject;
        IDocumentElementNode sourceElementNode = (IDocumentElementNode)sourceElementObject;
        if (targetLocation != 1 && targetLocation != 2 && targetLocation == 3) {
            sourceElementNode.reconnect(targetExtensionNode, (IModel)model);
            targetExtensionObject.add((IPluginObject)sourceElementObject);
        }
    }

    private void doDropMove(IPluginElement targetElementObject, IPluginElement sourceElementObject, int targetLocation) throws CoreException {
        IPluginModelBase model = this.getPluginModelBase();
        if (model == null) {
            return;
        }
        IDocumentElementNode targetElementNode = (IDocumentElementNode)targetElementObject;
        IDocumentElementNode sourceElementNode = (IDocumentElementNode)sourceElementObject;
        if (targetLocation == 1) {
            IPluginObject targetParentObject = targetElementObject.getParent();
            if (!(targetParentObject instanceof IPluginParent)) {
                return;
            }
            if (!(targetParentObject instanceof IDocumentElementNode)) {
                return;
            }
            IDocumentElementNode targetParentNode = (IDocumentElementNode)targetParentObject;
            sourceElementNode.reconnect(targetParentNode, (IModel)model);
            int index = targetParentNode.indexOf(targetElementNode);
            if (index == -1) {
                return;
            }
            ((IPluginParent)targetParentObject).add(index, (IPluginObject)sourceElementObject);
        } else if (targetLocation == 2) {
            IPluginObject targetParentObject = targetElementObject.getParent();
            if (!(targetParentObject instanceof IPluginParent)) {
                return;
            }
            if (!(targetParentObject instanceof IDocumentElementNode)) {
                return;
            }
            IDocumentElementNode targetParentNode = (IDocumentElementNode)targetParentObject;
            sourceElementNode.reconnect(targetParentNode, (IModel)model);
            int index = targetParentNode.indexOf(targetElementNode);
            if (index == -1) {
                return;
            }
            ((IPluginParent)targetParentObject).add(index + 1, (IPluginObject)sourceElementObject);
        } else if (targetLocation == 3) {
            sourceElementNode.reconnect(targetElementNode, (IModel)model);
            targetElementObject.add((IPluginObject)sourceElementObject);
        }
    }

    private boolean isTreeViewerSorted() {
        if (this.fSortAction == null) {
            return false;
        }
        return this.fSortAction.isChecked();
    }

    private boolean isSingleSelection() {
        ITreeSelection selection = this.fExtensionTree.getStructuredSelection();
        return selection.size() == 1;
    }

    private void reportMissingExtensionPointSchemas(IPluginBase pluginBase) {
        IPluginExtension[] extensions;
        IPluginExtension[] iPluginExtensionArray = extensions = pluginBase.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension ext = iPluginExtensionArray[n2];
            if (ext.getSchema() == null) {
                this.reportMissingExtensionPointSchema(ext.getPoint());
            }
            ++n2;
        }
    }

    private void reportMissingExtensionPointSchema(String point) {
        this.getManagedForm().getMessageManager().addMessage((Object)point, NLS.bind((String)PDEUIMessages.ManifestEditor_DetailExtension_missingExtPointSchema, (Object)point), null, 2);
    }

    class ExtensionContentProvider
    implements ITreeContentProvider {
        ExtensionContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            Object[] children = null;
            if (parent instanceof IPluginBase) {
                children = ((IPluginBase)parent).getExtensions();
            } else if (parent instanceof IPluginExtension) {
                children = ((IPluginExtension)parent).getChildren();
            } else if (parent instanceof IPluginElement) {
                children = ((IPluginElement)parent).getChildren();
            }
            if (children == null) {
                children = new Object[]{};
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginExtension) {
                return ((IPluginModelBase)ExtensionsSection.this.getPage().getModel()).getPluginBase();
            }
            if (child instanceof IPluginObject) {
                return ((IPluginObject)child).getParent();
            }
            return null;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }
    }

    class ExtensionLabelProvider
    extends LabelProvider
    implements IFontProvider {
        ExtensionLabelProvider() {
        }

        public String getText(Object obj) {
            return ExtensionsSection.this.resolveObjectName(obj);
        }

        public Image getImage(Object obj) {
            return ExtensionsSection.this.resolveObjectImage(obj);
        }

        public Font getFont(Object element) {
            if (ExtensionsSection.this.fFilteredTree.isFiltered() && ExtensionsSection.this.fPatternFilter.getMatchingLeafs().contains(element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }
    }
}

