/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.connector;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.registry.IConnectorListener;
import org.eclipse.viatra.query.runtime.registry.connector.AbstractRegistrySourceConnector;

public class SpecificationMapSourceConnector
extends AbstractRegistrySourceConnector {
    private static final String DUPLICATE_MESSAGE = "Duplicate FQN %s cannot be added to connector";
    private Map<String, IQuerySpecificationProvider> specificationProviderMap = new HashMap<String, IQuerySpecificationProvider>();

    public SpecificationMapSourceConnector(String identifier, boolean includeInDefaultViews) {
        super(identifier, includeInDefaultViews);
    }

    public SpecificationMapSourceConnector(String identifier, Set<IQuerySpecificationProvider> specificationProviders, boolean includeInDefaultViews) {
        this(identifier, includeInDefaultViews);
        for (IQuerySpecificationProvider provider : specificationProviders) {
            this.addQuerySpecificationProvider(provider);
        }
    }

    public SpecificationMapSourceConnector(String identifier, SpecificationMapSourceConnector connector, boolean includeInDefaultViews) {
        this(identifier, includeInDefaultViews);
        this.specificationProviderMap.putAll(connector.specificationProviderMap);
    }

    public void addQuerySpecificationProvider(IQuerySpecificationProvider provider) {
        Objects.requireNonNull(provider, "Provider must not be null!");
        String fullyQualifiedName = provider.getFullyQualifiedName();
        if (!this.specificationProviderMap.containsKey(fullyQualifiedName)) {
            this.specificationProviderMap.put(fullyQualifiedName, provider);
            for (IConnectorListener listener : this.listeners) {
                listener.querySpecificationAdded(this, provider);
            }
        } else {
            throw new IllegalArgumentException(String.format(DUPLICATE_MESSAGE, fullyQualifiedName));
        }
    }

    public void removeQuerySpecificationProvider(String fullyQualifiedName) {
        Objects.requireNonNull(fullyQualifiedName, "Fully qualified name must not be null!");
        IQuerySpecificationProvider provider = this.specificationProviderMap.remove(fullyQualifiedName);
        if (provider == null) {
            throw new NoSuchElementException(String.format("Connector does not contain specification with FQN %s", fullyQualifiedName));
        }
        for (IConnectorListener listener : this.listeners) {
            listener.querySpecificationRemoved(this, provider);
        }
    }

    public Set<String> getQuerySpecificationFQNs() {
        return Collections.unmodifiableSet(new HashSet<String>(this.specificationProviderMap.keySet()));
    }

    public boolean hasQuerySpecificationFQN(String fullyQualifiedName) {
        Objects.requireNonNull(fullyQualifiedName, "FQN must not be null!");
        return this.specificationProviderMap.containsKey(fullyQualifiedName);
    }

    @Override
    protected void sendQuerySpecificationsToListener(IConnectorListener listener) {
        for (IQuerySpecificationProvider provider : this.specificationProviderMap.values()) {
            listener.querySpecificationAdded(this, provider);
        }
    }
}

