/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.utils.dialogfields.ComboDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public class ComboButtonDialogField
extends ComboDialogField {
    private final IStringButtonAdapter m_browseAdapter;
    private Button m_browseButton;
    private boolean m_browseButtonEnabled = true;
    private Combo m_combo;

    public ComboButtonDialogField(IStringButtonAdapter adapter, int flags) {
        super(flags);
        this.m_browseAdapter = adapter;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int columns) {
        this.assertEnoughColumns(columns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)ComboButtonDialogField.gridDataForLabel(1));
        this.m_combo = this.getComboControl(parent);
        GridDataFactory.create((Control)this.m_combo).fillH().grabH().spanH(columns - 2);
        Button button = this.getChangeControl(parent);
        return new Control[]{label, this.m_combo, button};
    }

    public void changeControlPressed() {
        this.m_browseAdapter.changeControlPressed(this);
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    public Button getChangeControl(Composite parent) {
        if (this.m_browseButton == null) {
            this.assertCompositeNotNull(parent);
            this.m_browseButton = new Button(parent, 8);
            this.m_browseButton.setFont(parent.getFont());
            this.m_browseButton.setText("...");
            this.m_browseButton.setEnabled(this.isEnabled() && this.m_browseButtonEnabled);
            this.m_browseButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    ComboButtonDialogField.this.changeControlPressed();
                }

                public void widgetSelected(SelectionEvent e) {
                    ComboButtonDialogField.this.changeControlPressed();
                }
            });
        }
        return this.m_browseButton;
    }

    public void enableButton(boolean enable) {
        if (this.isOkToUse((Control)this.m_browseButton)) {
            this.m_browseButton.setEnabled(this.isEnabled() && enable);
        }
        this.m_browseButtonEnabled = enable;
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.m_browseButton)) {
            this.m_browseButton.setEnabled(this.isEnabled() && this.m_browseButtonEnabled);
        }
    }
}

