/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.absolute;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.ObjectInfoUtils;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.JavaInfoAddProperties;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.ClipboardCommand;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.layout.absolute.BoundsProperty;
import org.eclipse.wb.internal.core.model.layout.absolute.OrderingSupport;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.converter.IntegerConverter;
import org.eclipse.wb.internal.core.model.util.AbsoluteLayoutCreationFlowSupport;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.layout.LayoutClipboardCommand;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.absolute.IAbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

public final class AbsoluteLayoutInfo
extends LayoutInfo
implements IAbsoluteLayoutInfo<ControlInfo> {
    private static final String SET_SIZE_POINT = "setSize(org.eclipse.swt.graphics.Point)";
    private static final String SET_SIZE_INT_INT = "setSize(int,int)";
    private static final String SET_LOCATION_POINT = "setLocation(org.eclipse.swt.graphics.Point)";
    private static final String SET_LOCATION_INT_INT = "setLocation(int,int)";

    public AbsoluteLayoutInfo(AstEditor editor, ToolkitDescription toolkit, CreationSupport creationSupport) throws Exception {
        super(editor, new ComponentDescription(null), creationSupport);
        ObjectInfoUtils.setNewId((ObjectInfo)this);
        this.getDescription().setToolkit(toolkit);
        this.getDescription().setOrder("first");
        this.getDescription().setIcon(Activator.getImage("info/layout/absolute/layout.gif"));
        this.setVariableSupport(new AbsoluteLayoutVariableSupport(this));
    }

    protected void initialize() throws Exception {
        super.initialize();
        this.whenSetComplexLayout_forChildComposite();
        this.addBroadcastListener(new JavaEventListener(){

            public void setPropertyExpression(GenericPropertyImpl property, String[] source, Object[] value, boolean[] shouldSet) throws Exception {
                this.checkForAutoSize(property);
            }

            private void checkForAutoSize(GenericPropertyImpl property) throws Exception {
                GenericPropertyDescription propertyDescription;
                IPreferenceStore preferences = AbsoluteLayoutInfo.this.getDescription().getToolkit().getPreferences();
                if (preferences.getBoolean("absoluteLayout.autoSize.onTextImage") && AbsoluteLayoutInfo.this.isManagedObject(property.getJavaInfo()) && (propertyDescription = property.getDescription()) != null) {
                    boolean isTextProperty = propertyDescription.hasTrueTag("isText");
                    boolean isImageProperty = propertyDescription.hasTrueTag("isImage");
                    if (isTextProperty || isImageProperty) {
                        final ControlInfo control = (ControlInfo)property.getJavaInfo();
                        ExecutionUtils.runLater((ObjectInfo)control, (RunnableEx)new RunnableEx(){

                            public void run() throws Exception {
                                AbsoluteLayoutInfo.this.commandChangeBounds(control, (Point)null, control.getPreferredSize());
                            }
                        });
                    }
                }
            }
        });
        this.addBroadcastListener(new JavaInfoAddProperties(){

            public void invoke(JavaInfo javaInfo, List<Property> properties) throws Exception {
                if (AbsoluteLayoutInfo.this.isManagedObject(javaInfo)) {
                    ControlInfo control = (ControlInfo)javaInfo;
                    properties.add(AbsoluteLayoutInfo.this.getBoundsProperty(control));
                }
            }
        });
        this.addBroadcastListener(new JavaEventListener(){

            public void canMove(JavaInfo javaInfo, boolean[] forceMoveEnable, boolean[] forceMoveDisable) throws Exception {
                if (AbsoluteLayoutInfo.this.isManagedObject(javaInfo)) {
                    forceMoveEnable[0] = true;
                }
            }
        });
        this.addBroadcastListener(new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (AbsoluteLayoutInfo.this.isManagedObject(object)) {
                    ControlInfo control = (ControlInfo)object;
                    AbsoluteLayoutInfo.this.contributeControlContextMenu(manager, control);
                }
            }
        });
    }

    private void whenSetComplexLayout_forChildComposite() {
        this.addBroadcastListener(new JavaEventListener(){

            public void addAfter(JavaInfo parent, JavaInfo child) throws Exception {
                int result;
                if (child instanceof LayoutInfo && !(child instanceof AbsoluteLayoutInfo) && parent instanceof CompositeInfo && parent.getParent() == AbsoluteLayoutInfo.this.getComposite() && (result = this.openQuestion()) == 0) {
                    LayoutInfo formLayout = (LayoutInfo)JavaInfoUtils.createJavaInfo((AstEditor)AbsoluteLayoutInfo.this.getEditor(), (String)"org.eclipse.swt.layout.FormLayout", (CreationSupport)new ConstructorCreationSupport());
                    AbsoluteLayoutInfo.this.getComposite().setLayout(formLayout);
                }
            }

            private int openQuestion() {
                MessageDialog dialog = new MessageDialog(DesignerPlugin.getShell(), ModelMessages.AbsoluteLayoutInfo_layoutConfirmTitle, null, String.valueOf(ModelMessages.AbsoluteLayoutInfo_layoutConfirmMessage1) + ModelMessages.AbsoluteLayoutInfo_layoutConfirmMessage2 + ModelMessages.AbsoluteLayoutInfo_layoutConfirmMessage3 + ModelMessages.AbsoluteLayoutInfo_layoutConfirmMessage4 + ModelMessages.AbsoluteLayoutInfo_layoutConfirmMessage5, 4, new String[]{ModelMessages.AbsoluteLayoutInfo_layoutConfirmButtonYes, ModelMessages.AbsoluteLayoutInfo_layoutConfirmButtonNo}, 0);
                return dialog.open();
            }
        });
    }

    private void contributeControlContextMenu(IMenuManager manager, final ControlInfo control) {
        List<ControlInfo> controls = this.getComposite().getChildrenControls();
        new OrderingSupport(controls, (IAbstractComponentInfo)control).contributeActions(manager);
        ObjectInfoAction action = new ObjectInfoAction((ObjectInfo)control, ModelMessages.AbsoluteLayoutInfo_autoSize, DesignerPlugin.getImageDescriptor((String)"info/layout/absolute/fit_to_size.png")){

            protected void runEx() throws Exception {
                AbsoluteLayoutInfo.this.commandChangeBounds(control, (Point)null, control.getPreferredSize());
            }
        };
        manager.appendToGroup("org.eclipse.wb.popup.group.constraints", (IAction)action);
    }

    @Override
    public void onSet() throws Exception {
        for (ControlInfo control : this.getComposite().getChildrenControls()) {
            Rectangle bounds = control.getModelBounds();
            control.addMethodInvocation("setBounds(int,int,int,int)", String.valueOf(bounds.x) + ", " + bounds.y + ", " + bounds.width + ", " + bounds.height);
        }
    }

    @Override
    protected void deleteLayoutData(ControlInfo control) throws Exception {
        super.deleteLayoutData(control);
        control.removeMethodInvocations(SET_LOCATION_INT_INT);
        control.removeMethodInvocations(SET_LOCATION_POINT);
        control.removeMethodInvocations(SET_SIZE_INT_INT);
        control.removeMethodInvocations(SET_SIZE_POINT);
        control.removeMethodInvocations("setBounds(int,int,int,int)");
        control.removeMethodInvocations("setBounds(org.eclipse.swt.graphics.Rectangle)");
    }

    protected List<Property> getPropertyList() throws Exception {
        return Collections.emptyList();
    }

    private Property getBoundsProperty(ControlInfo control) {
        Rectangle modelBounds;
        ComplexProperty boundsProperty = (ComplexProperty)control.getArbitraryValue(this);
        if (boundsProperty == null) {
            boundsProperty = new ComplexProperty("Bounds", null);
            boundsProperty.setCategory(PropertyCategory.system((int)5));
            boundsProperty.setModified(true);
            control.putArbitraryValue(this, boundsProperty);
            BoundsProperty<ControlInfo> xProperty = new BoundsProperty<ControlInfo>(control, "x"){

                public void setValue2(int value, Rectangle modelBounds) throws Exception {
                    AbsoluteLayoutInfo.this.commandChangeBounds((ControlInfo)this.m_component, new Point(value, modelBounds.y), (Dimension)null);
                }
            };
            BoundsProperty<ControlInfo> yProperty = new BoundsProperty<ControlInfo>(control, "y"){

                public void setValue2(int value, Rectangle modelBounds) throws Exception {
                    AbsoluteLayoutInfo.this.commandChangeBounds((ControlInfo)this.m_component, new Point(modelBounds.x, value), (Dimension)null);
                }
            };
            BoundsProperty<ControlInfo> widthProperty = new BoundsProperty<ControlInfo>(control, "width"){

                public void setValue2(int value, Rectangle modelBounds) throws Exception {
                    AbsoluteLayoutInfo.this.commandChangeBounds((ControlInfo)this.m_component, (Point)null, new Dimension(value, modelBounds.height));
                }
            };
            BoundsProperty<ControlInfo> heightProperty = new BoundsProperty<ControlInfo>(control, "height"){

                public void setValue2(int value, Rectangle modelBounds) throws Exception {
                    AbsoluteLayoutInfo.this.commandChangeBounds((ControlInfo)this.m_component, (Point)null, new Dimension(modelBounds.width, value));
                }
            };
            boundsProperty.setProperties(new Property[]{xProperty, yProperty, widthProperty, heightProperty});
        }
        if ((modelBounds = control.getModelBounds()) != null) {
            boundsProperty.setText("(" + modelBounds.x + ", " + modelBounds.y + ", " + modelBounds.width + ", " + modelBounds.height + ")");
        }
        return boundsProperty;
    }

    @Override
    public void commandCreate(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.command_CREATE(control, nextControl);
    }

    @Override
    public void commandMove(ControlInfo control, ControlInfo nextControl) throws Exception {
        this.command_MOVE(control, nextControl);
    }

    @Override
    public void commandChangeBounds(ControlInfo widget, Point location, Dimension size) throws Exception {
        this.commandChangeBounds0(widget, location, size);
        if (location != null && this.useCreationFlow()) {
            AbsoluteLayoutCreationFlowSupport.apply((IAbstractComponentInfo)this.getComposite(), this.getControls(), (IAbstractComponentInfo)widget, (Point)location, (Dimension)size);
        }
    }

    private void commandChangeBounds0(ControlInfo widget, Point location, Dimension size) throws Exception {
        String newCode;
        Expression exp;
        MethodInvocation mi;
        Assert.isLegal((location != null || size != null ? 1 : 0) != 0, (String)ModelMessages.AbsoluteLayoutInfo_notNullLocationSize);
        AstEditor editor = widget.getEditor();
        MethodInvocation mi2 = widget.getMethodInvocation("setBounds(int,int,int,int)");
        if (mi2 != null) {
            if (location != null) {
                this.setExpression(mi2, 0, location.x);
                this.setExpression(mi2, 1, location.y);
            }
            if (size != null) {
                this.setExpression(mi2, 2, size.width);
                this.setExpression(mi2, 3, size.height);
            }
            this.removeUnusedMethodsAfterSetBounds(widget);
            return;
        }
        mi2 = widget.getMethodInvocation("setBounds(org.eclipse.swt.graphics.Rectangle)");
        if (mi2 != null) {
            Rectangle widgetBounds = widget.getModelBounds();
            Expression exp2 = (Expression)mi2.arguments().get(0);
            String newCode2 = "new org.eclipse.swt.graphics.Rectangle(";
            newCode2 = location != null ? String.valueOf(newCode2) + location.x + ", " + location.y : String.valueOf(newCode2) + widgetBounds.x + ", " + widgetBounds.y;
            newCode2 = String.valueOf(newCode2) + ", ";
            newCode2 = size != null ? String.valueOf(newCode2) + size.width + ", " + size.height : String.valueOf(newCode2) + widgetBounds.width + ", " + widgetBounds.height;
            newCode2 = String.valueOf(newCode2) + ")";
            editor.replaceExpression(exp2, newCode2);
            this.removeUnusedMethodsAfterSetBounds(widget);
            return;
        }
        boolean setLocationFound = false;
        boolean setSizeFound = false;
        if (location != null) {
            mi = widget.getMethodInvocation(SET_LOCATION_INT_INT);
            if (mi != null) {
                setLocationFound = true;
                this.setExpression(mi, 0, location.x);
                this.setExpression(mi, 1, location.y);
            }
            if ((mi = widget.getMethodInvocation(SET_LOCATION_POINT)) != null) {
                setLocationFound = true;
                exp = (Expression)mi.arguments().get(0);
                newCode = "new org.eclipse.swt.graphics.Point(";
                newCode = String.valueOf(newCode) + location.x + ", " + location.y + ")";
                editor.replaceExpression(exp, newCode);
            }
        }
        if (size != null) {
            mi = widget.getMethodInvocation(SET_SIZE_INT_INT);
            if (mi != null) {
                setSizeFound = true;
                this.setExpression(mi, 0, size.width);
                this.setExpression(mi, 1, size.height);
            }
            if ((mi = widget.getMethodInvocation(SET_SIZE_POINT)) != null) {
                setSizeFound = true;
                exp = (Expression)mi.arguments().get(0);
                newCode = "new org.eclipse.swt.graphics.Point(";
                newCode = String.valueOf(newCode) + size.width + ", " + size.height + ")";
                editor.replaceExpression(exp, newCode);
            }
        }
        if (location != null && !setLocationFound && size != null && !setSizeFound) {
            widget.addMethodInvocation("setBounds(int,int,int,int)", String.valueOf(location.x) + ", " + location.y + ", " + size.width + ", " + size.height);
            return;
        }
        if (location != null && !setLocationFound) {
            widget.addMethodInvocation(SET_LOCATION_INT_INT, String.valueOf(location.x) + ", " + location.y);
        }
        if (size != null && !setSizeFound) {
            widget.addMethodInvocation(SET_SIZE_INT_INT, String.valueOf(size.width) + ", " + size.height);
        }
    }

    private boolean useCreationFlow() {
        return this.getToolkit().getPreferences().getBoolean("P_CREATION_FLOW");
    }

    private ToolkitDescription getToolkit() {
        return this.getDescription().getToolkit();
    }

    private void setExpression(MethodInvocation mi, int index, int arg) throws Exception {
        this.getEditor().replaceExpression((Expression)mi.arguments().get(index), IntegerConverter.INSTANCE.toJavaSource((JavaInfo)this, (Object)arg));
    }

    private void removeUnusedMethodsAfterSetBounds(ControlInfo widget) throws Exception {
        MethodInvocation mi = widget.getMethodInvocation(SET_LOCATION_INT_INT);
        if (mi != null) {
            widget.removeMethodInvocations(SET_LOCATION_INT_INT);
        }
        if ((mi = widget.getMethodInvocation(SET_LOCATION_POINT)) != null) {
            widget.removeMethodInvocations(SET_LOCATION_POINT);
        }
        if ((mi = widget.getMethodInvocation(SET_SIZE_INT_INT)) != null) {
            widget.removeMethodInvocations(SET_SIZE_INT_INT);
        }
        if ((mi = widget.getMethodInvocation(SET_SIZE_POINT)) != null) {
            widget.removeMethodInvocations(SET_SIZE_POINT);
        }
    }

    @Override
    protected void clipboardCopy_addControlCommands(ControlInfo control, List<ClipboardCommand> commands) throws Exception {
        final Rectangle bounds = control.getModelBounds();
        commands.add((ClipboardCommand)new LayoutClipboardCommand<AbsoluteLayoutInfo>(control){
            private static final long serialVersionUID = 0L;

            @Override
            protected void add(AbsoluteLayoutInfo layout, ControlInfo control) throws Exception {
                layout.command_CREATE(control, null);
                layout.commandChangeBounds(control, bounds.getLocation(), bounds.getSize());
            }
        });
    }

    public static AbsoluteLayoutInfo createExplicit(CompositeInfo parent) throws Exception {
        AstEditor editor = parent.getEditor();
        ToolkitDescriptionJava toolkit = parent.getDescription().getToolkit();
        AbsoluteLayoutCreationSupport creationSupport = new AbsoluteLayoutCreationSupport();
        return new AbsoluteLayoutInfo(editor, (ToolkitDescription)toolkit, (CreationSupport)creationSupport);
    }
}

