/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Expression;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.core._CoreStringUtils;
import freemarker.core._DelayedGetMessage;
import freemarker.core._DelayedJQuote;
import freemarker.core._MiscTemplateException;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;

public final class LibraryLoad
extends TemplateElement {
    private Expression importedTemplateNameExp;
    private String namespace;

    LibraryLoad(Template template, Expression templateName, String namespace) {
        this.namespace = namespace;
        this.importedTemplateNameExp = templateName;
    }

    void accept(Environment env) throws TemplateException, IOException {
        Template importedTemplate;
        String fullImportedTemplateName;
        String importedTemplateName = this.importedTemplateNameExp.evalAndCoerceToString(env);
        try {
            fullImportedTemplateName = env.toFullTemplateName(this.getTemplate().getName(), importedTemplateName);
        }
        catch (MalformedTemplateNameException e) {
            throw new _MiscTemplateException((Throwable)e, env, new Object[]{"Malformed template name ", new _DelayedJQuote(e.getTemplateName()), ":\n", e.getMalformednessDescription()});
        }
        try {
            importedTemplate = env.getTemplateForImporting(fullImportedTemplateName);
        }
        catch (IOException e) {
            throw new _MiscTemplateException((Throwable)e, env, new Object[]{"Template importing failed (for parameter value ", new _DelayedJQuote(importedTemplateName), "):\n", new _DelayedGetMessage(e)});
        }
        env.importLib(importedTemplate, this.namespace);
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        buf.append(this.importedTemplateNameExp.getCanonicalForm());
        buf.append(" as ");
        buf.append(_CoreStringUtils.toFTLTopLevelTragetIdentifier(this.namespace));
        if (canonical) {
            buf.append("/>");
        }
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "#import";
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.importedTemplateNameExp;
            }
            case 1: {
                return this.namespace;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.TEMPLATE_NAME;
            }
            case 1: {
                return ParameterRole.NAMESPACE;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public String getTemplateName() {
        return this.importedTemplateNameExp.toString();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

