/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.util.GenericUtils;

public interface AttributeRepository {
    public int getAttributesCount();

    public <T> T getAttribute(AttributeKey<T> var1);

    default public <T> T resolveAttribute(AttributeKey<T> key) {
        return this.getAttribute(key);
    }

    public Collection<AttributeKey<?>> attributeKeys();

    public static <A> AttributeRepository ofKeyValuePair(AttributeKey<A> key, A value) {
        Objects.requireNonNull(key, "No key provided");
        Objects.requireNonNull(value, "No value provided");
        return AttributeRepository.ofAttributesMap(Collections.singletonMap(key, value));
    }

    public static AttributeRepository ofAttributesMap(final Map<AttributeKey<?>, ?> attributes) {
        return new AttributeRepository(){

            @Override
            public int getAttributesCount() {
                return attributes.size();
            }

            @Override
            public <T> T getAttribute(AttributeKey<T> key) {
                Objects.requireNonNull(key, "No key provided");
                return GenericUtils.isEmpty(attributes) ? null : (T)attributes.get(key);
            }

            @Override
            public Collection<AttributeKey<?>> attributeKeys() {
                return GenericUtils.isEmpty(attributes) ? Collections.emptySet() : new HashSet(attributes.keySet());
            }

            public String toString() {
                return AttributeRepository.class.getSimpleName() + "[" + attributes + "]";
            }
        };
    }

    public static class AttributeKey<T> {
    }
}

