/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.model.util.BPELUtils;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.AddImportCommand;
import org.eclipse.bpel.ui.details.providers.ModelTreeLabelProvider;
import org.eclipse.bpel.ui.details.tree.TreeNode;
import org.eclipse.bpel.ui.dialogs.ListAndViewDialog;
import org.eclipse.bpel.ui.dialogs.NamespaceMappingDialog;
import org.eclipse.bpel.ui.dialogs.SchemaImportDialog;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class BrowseSelectorDialog
extends ListAndViewDialog {
    protected static final int BID_ADD_IMPORT = 1025;
    protected static final int BID_FROM_IMPORTS_ONLY = 1031;
    protected static final int BID_FROM_PROJECT = 1032;
    protected static final int BID_FROM_WORKSPACE = 1033;
    protected static final int BID_FROM_XML_CATALOG = 1034;
    protected static final int BID_FROM_REPOSITORY = 1035;
    protected static final int BID_DUPLICATES = 1044;
    protected boolean showDuplicates = false;
    protected EObject modelObject;
    protected Text filterText;
    protected IStructuredContentProvider contentProvider = null;
    protected IStructuredContentProvider resourceContentProvider = null;
    protected ITreeContentProvider treeContentProvider = null;
    protected Group checkButtonGroup;
    protected Tree fTree;
    protected TreeViewer fTreeViewer;
    private Button fFromImportsRadio;
    private Button fFromProjectRadio;
    private Button fFromWorkspaceRadio;
    private Object[] fWorkspaceObjects;
    private Object[] fProjectObjects;
    private Label filterLabel;
    static final String VIEW_FROM_KEY = "ViewFrom";
    static final String SHOW_DUPLICATES_KEY = "ShowDuplicates";
    protected int VIEW_FROM = 1031;
    String fBrowseFromLabel;

    public BrowseSelectorDialog(Shell parent, ILabelProvider elementRenderer) {
        super(parent, elementRenderer);
        IDialogSettings settings = this.getDialogSettings();
        this.setMessage(Messages.BrowseSelectorDialog_0);
        this.setUpperListLabel(Messages.BrowseSelectorDialog_1);
        this.setBrowseFromLabel(Messages.BrowseSelectorDialog_2);
        try {
            this.VIEW_FROM = settings.getInt(VIEW_FROM_KEY);
        }
        catch (Exception exception) {
            this.VIEW_FROM = 1031;
        }
        try {
            this.showDuplicates = settings.getBoolean(SHOW_DUPLICATES_KEY);
        }
        catch (Exception exception) {
            this.showDuplicates = false;
        }
    }

    protected void setBrowseFromLabel(String label) {
        this.fBrowseFromLabel = label;
    }

    @Override
    protected void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(VIEW_FROM_KEY, this.VIEW_FROM);
        settings.put(SHOW_DUPLICATES_KEY, this.showDuplicates);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.handleAddImport();
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.computeResult();
        Object[] obj = this.getResult();
        if (obj != null && obj.length > 0) {
            if (!this.ensureXSDTypeNamespaceMappings(obj[0])) {
                return;
            }
            this.handleAddImport(obj[0]);
            super.okPressed();
        }
    }

    @Override
    protected void computeResult() {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] sel1 = this.getSelectedElements();
        TreeItem[] sel2 = this.fTree.getSelection();
        int i = 0;
        while (i < sel1.length) {
            result.add(sel1[i]);
            ++i;
        }
        i = 0;
        while (i < sel2.length) {
            Object data = sel2[i].getData();
            if (data instanceof TreeNode) {
                ArrayList<Object> elements = new ArrayList<Object>();
                TreeNode node = (TreeNode)data;
                ITreeContentProvider prov = (ITreeContentProvider)this.fTreeViewer.getContentProvider();
                do {
                    elements.add(node.getModelObject());
                } while ((node = (TreeNode)prov.getParent((Object)node)) != null && node.getModelObject() != sel1[0]);
                int e = elements.size();
                while (e > 0) {
                    result.add(elements.get(e - 1));
                    --e;
                }
            }
            ++i;
        }
        this.setResult(result);
    }

    private boolean ensureXSDTypeNamespaceMappings(Object obj) {
        String targetNamespace = null;
        if (obj instanceof XSDNamedComponent) {
            XSDNamedComponent namedComponent = (XSDNamedComponent)obj;
            targetNamespace = namedComponent.getTargetNamespace();
        }
        if (targetNamespace == null) {
            return true;
        }
        String prefix = BPELUtils.getNamespacePrefix((EObject)this.modelObject, (String)targetNamespace);
        if (prefix != null) {
            return true;
        }
        NamespaceMappingDialog dialog = new NamespaceMappingDialog(this.getShell(), this.modelObject);
        dialog.setNamespace(targetNamespace);
        if (dialog.open() == 1) {
            return false;
        }
        BPELUtils.setPrefix((EObject)BPELUtils.getProcess((Object)this.modelObject), (String)targetNamespace, (String)dialog.getPrefix());
        return true;
    }

    protected void buttonPressed(int id, boolean checked, boolean bRefresh) {
        switch (id) {
            case 1044: {
                this.showDuplicates = checked;
                break;
            }
            case 1031: 
            case 1032: 
            case 1033: 
            case 1034: 
            case 1035: {
                if (!checked) {
                    return;
                }
                if (!checked) break;
                this.VIEW_FROM = id;
                break;
            }
        }
        if (bRefresh) {
            this.refresh();
        }
    }

    protected void handleAddImport() {
        SchemaImportDialog dialog = new SchemaImportDialog(this.getShell(), this.modelObject);
        if (dialog.open() == 1) {
            return;
        }
        Object obj = dialog.getFirstResult();
        if (obj == null) {
            return;
        }
        if (this.handleAddImport(obj)) {
            this.showImportedTypes();
            this.refresh();
        }
    }

    protected boolean handleAddImport(Object obj) {
        String targetNamespace;
        if (obj instanceof XSDSimpleTypeDefinition && (targetNamespace = ((XSDSimpleTypeDefinition)obj).getTargetNamespace()) != null && ((XSDSimpleTypeDefinition)obj).getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            return false;
        }
        AddImportCommand cmd = new AddImportCommand(BPELUtils.getProcess((Object)this.modelObject), obj);
        if (cmd.canDoExecute() && !cmd.wouldCreateDuplicateImport()) {
            ModelHelper.getBPELEditor(this.modelObject).getCommandStack().execute((Command)cmd);
            return true;
        }
        return false;
    }

    protected Button createRadioButton(Composite parent, String label, int id, boolean checked) {
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                int val = (Integer)b.getData();
                BrowseSelectorDialog.this.buttonPressed(val, b.getSelection(), true);
            }
        });
        return button;
    }

    protected Button createCheckButton(Composite parent, String label, int id, boolean checked) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.setSelection(checked);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button b = (Button)event.widget;
                int val = (Integer)b.getData();
                BrowseSelectorDialog.this.buttonPressed(val, b.getSelection(), true);
            }
        });
        return button;
    }

    protected Text createFilterText(Composite parent) {
        this.filterText = super.createFilterText(parent);
        this.createBrowseFromGroup(parent);
        this.createBrowseFilterGroup(parent);
        return this.filterText;
    }

    protected Label createMessageArea(Composite composite) {
        this.filterLabel = super.createMessageArea(composite);
        return this.filterLabel;
    }

    protected void createBrowseFromGroup(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(this.fBrowseFromLabel);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        group.setLayoutData((Object)data);
        this.createBrowseFromGroupButtons(group);
    }

    protected void createBrowseFromGroupButtons(Group group) {
        this.fFromImportsRadio = this.createRadioButton((Composite)group, Messages.TypeSelectorDialog_10, 1031, this.VIEW_FROM == 1031);
        this.fFromProjectRadio = this.createRadioButton((Composite)group, Messages.TypeSelectorDialog_11, 1032, this.VIEW_FROM == 1032);
        this.fFromWorkspaceRadio = this.createRadioButton((Composite)group, Messages.TypeSelectorDialog_12, 1033, this.VIEW_FROM == 1033);
    }

    protected void createBrowseFilterGroup(Composite parent) {
        this.checkButtonGroup = new Group(parent, 16);
        this.checkButtonGroup.setText(Messages.BrowseSelectorDialog_4);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 3;
        this.checkButtonGroup.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.checkButtonGroup.setLayoutData((Object)data);
        this.createBrowseFilterGroupButtons(this.checkButtonGroup);
    }

    protected void createBrowseFilterGroupButtons(Group group) {
        this.createCheckButton((Composite)group, Messages.TypeSelectorDialog_19, 1044, this.showDuplicates);
    }

    @Override
    protected Object createLowerView(Composite parent) {
        this.fTree = new Tree(parent, 2048);
        this.fTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                BrowseSelectorDialog.this.updateOkState();
            }
        });
        this.fTreeViewer = new TreeViewer(this.fTree);
        this.fTreeViewer.setContentProvider((IContentProvider)this.treeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ModelTreeLabelProvider());
        this.fTreeViewer.setInput(null);
        this.fTreeViewer.setAutoExpandLevel(this.getAutoExpandLevel());
        GridData data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.minimumHeight = 200;
        this.fTree.setLayoutData((Object)data);
        return this.fTree;
    }

    protected int getAutoExpandLevel() {
        return 3;
    }

    @Override
    protected void updateLowerViewWidget(Object[] elements) {
        if (elements == null || elements.length < 1) {
            this.fTreeViewer.setInput(null);
            return;
        }
        this.fTreeViewer.setInput(elements[0]);
        ScrollBar bar = this.fTree.getVerticalBar();
        if (bar != null) {
            bar.setSelection(0);
        }
    }

    protected Object[] merge(Object[] a1, Object[] a2) {
        Object[] result = new Object[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }

    protected void refresh() {
        if (this.VIEW_FROM == 1031) {
            this.refreshFromImports();
        } else if (this.VIEW_FROM == 1032) {
            this.refreshFromProject();
        } else if (this.VIEW_FROM == 1033) {
            this.refreshFromWorkspace();
        } else if (this.VIEW_FROM == 1034) {
            this.refreshFromXMLCatalog();
        } else if (this.VIEW_FROM == 1035) {
            this.refreshFromRepository();
        } else {
            return;
        }
        if (this.fFilteredList != null) {
            if (this.fFilteredList.isEmpty()) {
                this.handleEmptyList();
            } else {
                this.handleNonEmptyList();
            }
        }
        this.updateOkState();
    }

    protected void refreshFromImports() {
        List<?> elements = this.collectItemsFromImports();
        if (this.fFilteredList != null) {
            this.fFilteredList.setAllowDuplicates(this.showDuplicates);
            this.fFilteredList.setElements(this.contentProvider.getElements(elements));
            this.fFilteredList.setEnabled(true);
        }
    }

    protected List<?> collectItemsFromImports() {
        return Collections.emptyList();
    }

    protected void refreshFromWorkspace() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(null);
        }
        if (this.fWorkspaceObjects == null) {
            this.fWorkspaceObjects = this.resourceContentProvider.getElements((Object)ResourcesPlugin.getWorkspace().getRoot());
        }
        if (this.fFilteredList != null) {
            this.fFilteredList.setEnabled(true);
            this.fFilteredList.setAllowDuplicates(this.showDuplicates);
            this.fFilteredList.setElements(this.contentProvider.getElements((Object)this.fWorkspaceObjects));
        }
    }

    protected void refreshFromProject() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(null);
        }
        if (this.fProjectObjects == null) {
            Resource resource = this.modelObject.eResource();
            IFile file = BPELUtil.getFileFromURI(resource.getURI());
            this.fProjectObjects = this.resourceContentProvider.getElements((Object)file.getProject());
        }
        if (this.fFilteredList != null) {
            this.fFilteredList.setEnabled(true);
            this.fFilteredList.setAllowDuplicates(this.showDuplicates);
            this.fFilteredList.setElements(this.contentProvider.getElements((Object)this.fProjectObjects));
            if (this.contentProvider.getElements((Object)this.fProjectObjects) != null && this.contentProvider.getElements((Object)this.fProjectObjects).length > 0) {
                this.updateLowerViewWidget(this.fFilteredList.getSelection());
            }
        }
    }

    protected void refreshFromXMLCatalog() {
        Object[] elements = new Object[]{};
        this.modelObject.eContainer();
        if (this.fFilteredList != null) {
            this.fFilteredList.setAllowDuplicates(this.showDuplicates);
            this.fFilteredList.setElements(elements);
            this.fFilteredList.setEnabled(true);
        }
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(null);
        }
    }

    protected void refreshFromRepository() {
        Object[] elements = new Object[]{};
        this.modelObject.eContainer();
        if (this.fFilteredList != null) {
            this.fFilteredList.setAllowDuplicates(this.showDuplicates);
            this.fFilteredList.setElements(elements);
            this.fFilteredList.setEnabled(true);
        }
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(null);
        }
    }

    protected void showImportedTypes() {
        this.fFromImportsRadio.setSelection(true);
        this.fFromProjectRadio.setSelection(false);
        this.fFromWorkspaceRadio.setSelection(false);
        this.fFromImportsRadio.forceFocus();
        this.buttonPressed(1031, true, false);
    }

    protected void handleEmptyList() {
        this.fTreeViewer.setInput(null);
        this.fFilteredList.setSelection(new int[0]);
        super.handleEmptyList();
    }

    protected void handleNonEmptyList() {
        this.setEnabled((Control)this.filterText, true);
        this.setEnabled((Control)this.filterLabel, true);
        this.setEnabled((Control)this.fFilteredList, true);
    }

    void setEnabled(Control control, boolean b) {
        if (control != null) {
            control.setEnabled(b);
        }
    }
}

