/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.qmltypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.qt.core.qmltypes.QMLModelBuilder;
import org.eclipse.cdt.qt.core.qmljs.IJSObjectExpression;
import org.eclipse.cdt.qt.core.qmljs.IJSProperty;
import org.eclipse.cdt.qt.core.qmljs.IQmlObjectDefinition;
import org.eclipse.cdt.qt.core.qmljs.IQmlObjectMember;
import org.eclipse.cdt.qt.core.qmljs.IQmlPropertyBinding;
import org.eclipse.cdt.qt.core.qmljs.IQmlScriptBinding;
import org.eclipse.cdt.qt.core.qmljs.QMLExpressionEvaluator;

public class QMLEnumInfo {
    static final String IDENTIFIER = "Enum";
    static final String PROPERTY_NAME = "name";
    static final String PROPERTY_VALUE = "values";
    private String name;
    private List<EnumConst> constantList;

    QMLEnumInfo(QMLModelBuilder builder, IQmlObjectDefinition obj) {
        block14: {
            this.constantList = new ArrayList<EnumConst>();
            if (!builder.ensureIdentifier(obj.getIdentifier(), IDENTIFIER)) break block14;
            block10: for (IQmlObjectMember member : obj.getBody().getMembers()) {
                if (!builder.ensureNode(member, IQmlPropertyBinding.class)) continue;
                IQmlPropertyBinding prop = (IQmlPropertyBinding)member;
                switch (prop.getIdentifier().getName()) {
                    case "name": {
                        this.name = builder.getStringBinding(prop);
                        break;
                    }
                    case "values": {
                        IQmlScriptBinding binding;
                        if (!builder.ensureNode(prop.getBinding(), IQmlScriptBinding.class) || !builder.ensureNode((binding = (IQmlScriptBinding)prop.getBinding()).getScript(), IJSObjectExpression.class)) continue block10;
                        IJSObjectExpression objExpr = (IJSObjectExpression)binding.getScript();
                        for (IJSProperty property : objExpr.getProperties()) {
                            try {
                                Object value = QMLExpressionEvaluator.evaluateConstExpr(property.getValue());
                                if (!(value instanceof Number)) continue;
                                this.constantList.add(new EnumConst(property.getType(), ((Number)value).intValue()));
                            }
                            catch (QMLExpressionEvaluator.InvalidExpressionException e) {
                                builder.handleException(e);
                            }
                        }
                        continue block10;
                    }
                }
            }
        }
        this.constantList = Collections.unmodifiableList(this.constantList);
    }

    public String getName() {
        return this.name;
    }

    public List<EnumConst> getConstants() {
        return this.constantList;
    }

    public static class EnumConst {
        private final String identifier;
        private final int value;

        private EnumConst(String ident, int val) {
            this.identifier = ident;
            this.value = val;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public int getValue() {
            return this.value;
        }
    }
}

