/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.unittest.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.dsf.gdb.launching.InferiorRuntimeProcess;
import org.eclipse.cdt.testsrunner.internal.launcher.TestsRunnerProvidersManager;
import org.eclipse.cdt.testsrunner.internal.model.TestCase;
import org.eclipse.cdt.testsrunner.internal.model.TestSuite;
import org.eclipse.cdt.testsrunner.launcher.ITestsRunnerProvider;
import org.eclipse.cdt.testsrunner.model.ITestCase;
import org.eclipse.cdt.testsrunner.model.ITestItem;
import org.eclipse.cdt.testsrunner.model.ITestMessage;
import org.eclipse.cdt.testsrunner.model.ITestModelUpdater;
import org.eclipse.cdt.testsrunner.model.ITestSuite;
import org.eclipse.cdt.testsrunner.model.TestingException;
import org.eclipse.cdt.unittest.CDTUnitTestPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.unittest.launcher.ITestRunnerClient;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;

public class CDTTestRunnerClient
implements ITestRunnerClient {
    private static final String NL = System.lineSeparator();
    private final ITestRunSession fTestRunSession;
    private ITestsRunnerProvider fTestsRunnerProvider;
    private IProcess process;
    private ILaunchListener fFindProcessListener;
    protected boolean fDebug = false;
    private InputStream fStream;

    public CDTTestRunnerClient(ITestRunSession session) {
        this.fTestRunSession = session;
    }

    public void startMonitoring() {
        final ILaunch launch = this.fTestRunSession.getLaunch();
        this.fFindProcessListener = new ILaunchListener(){

            public void launchRemoved(ILaunch launch2) {
            }

            public void launchChanged(ILaunch aLaunch) {
                if (aLaunch.equals(launch) && CDTTestRunnerClient.this.process == null) {
                    CDTTestRunnerClient.this.process = CDTTestRunnerClient.this.connectProcess(launch);
                }
            }

            public void launchAdded(ILaunch launch2) {
            }
        };
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.fFindProcessListener);
        try {
            this.fTestsRunnerProvider = new TestsRunnerProvidersManager().getTestsRunnerProviderInfo(launch.getLaunchConfiguration()).instantiateTestsRunnerProvider();
            this.process = this.connectProcess(launch);
        }
        catch (CoreException e) {
            CDTUnitTestPlugin.log(e);
        }
    }

    private IProcess connectProcess(ILaunch launch) {
        if (this.process != null) {
            return this.process;
        }
        this.process = Arrays.stream(launch.getProcesses()).filter(InferiorRuntimeProcess.class::isInstance).findAny().orElse(null);
        if (this.process != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.fFindProcessListener);
            this.fStream = CDTTestRunnerClient.toInputStream(this.process);
            Job.createSystem((String)"Monitor test process", monitor -> this.run(this.fStream)).schedule();
        }
        return this.process;
    }

    private static InputStream toInputStream(final IProcess process) {
        IStreamMonitor monitor = process.getStreamsProxy().getOutputStreamMonitor();
        if (monitor == null) {
            return null;
        }
        final List<Integer> content = Collections.synchronizedList(new LinkedList());
        monitor.addListener((text, progresMonitor) -> text.chars().forEach(content::add));
        byte[] initialContent = monitor.getContents().getBytes();
        int i = initialContent.length - 1;
        while (i >= 0) {
            content.add(0, Integer.valueOf(initialContent[i]));
            --i;
        }
        return new InputStream(){

            @Override
            public int read() throws IOException {
                while (!process.isTerminated() || !content.isEmpty()) {
                    if (!content.isEmpty()) {
                        return (Integer)content.remove(0);
                    }
                    try {
                        Thread.sleep(20L, 0);
                    }
                    catch (InterruptedException e) {
                        return -1;
                    }
                }
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                if (process.isTerminated() && this.available() == 0) {
                    return -1;
                }
                if (len == 0) {
                    return 0;
                }
                int i = 0;
                do {
                    b[off + i] = (byte)this.read();
                } while (this.available() > 0 && ++i < len && off + i < b.length);
                return i;
            }

            @Override
            public int available() throws IOException {
                return content.size();
            }
        };
    }

    public void run(InputStream iStream) {
        if (iStream == null) {
            return;
        }
        this.fTestRunSession.notifyTestSessionStarted(null);
        try {
            this.fTestsRunnerProvider.run((ITestModelUpdater)new TestModelUpdaterAdapter(), iStream);
            this.fTestRunSession.notifyTestSessionCompleted(this.fTestRunSession.getDuration());
        }
        catch (TestingException e) {
            this.fTestRunSession.notifyTestSessionAborted(null, (Exception)((Object)e));
        }
    }

    public void stopTest() {
        this.stopMonitoring();
    }

    ITestItem convertFromTestElement(ITestElement element) {
        if (element instanceof ITestSuiteElement) {
            return this.convertFromTestSuiteElement((ITestSuiteElement)element);
        }
        if (element instanceof ITestCaseElement) {
            return this.convertFromTestCaseElement((ITestCaseElement)element);
        }
        return null;
    }

    ITestCase convertFromTestCaseElement(ITestCaseElement element) {
        if (element == null) {
            return null;
        }
        return new TestCase(element.getTestName(), (TestSuite)this.convertFromTestSuiteElement(element.getParent()));
    }

    ITestSuite convertFromTestSuiteElement(ITestSuiteElement testSuiteElement) {
        if (testSuiteElement == null) {
            return null;
        }
        return new TestSuite(testSuiteElement.getTestName(), (TestSuite)this.convertFromTestSuiteElement(testSuiteElement.getParent()));
    }

    public void stopMonitoring() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.fFindProcessListener);
    }

    class TestModelUpdaterAdapter
    implements ITestModelUpdater {
        Deque<TestElementReference> testElementRefs = new LinkedList<TestElementReference>();
        String fCurrentTestCase;
        String fCurrentTestSuite;
        int fTestId = 0;
        final StringBuilder fFailedTrace = new StringBuilder();

        TestModelUpdaterAdapter() {
        }

        public void enterTestSuite(String name) {
            if (CDTTestRunnerClient.this.fDebug) {
                System.out.println("TestModelUpdaterAdapter.enterTestSuite: name = " + name);
            }
            TestElementReference pRef = this.testElementRefs.isEmpty() ? null : this.testElementRefs.peek();
            TestElementReference cRef = new TestElementReference(pRef == null ? String.valueOf("-1") : pRef.id, String.valueOf(this.fTestId++), name, true);
            this.testElementRefs.push(cRef);
            this.fCurrentTestSuite = cRef.id;
            CDTTestRunnerClient.this.fTestRunSession.newTestSuite(cRef.id, cRef.name, null, this.getTestSuite(cRef.parentId), cRef.name, null);
        }

        public void exitTestSuite() {
            if (CDTTestRunnerClient.this.fDebug) {
                System.out.println("TestModelUpdaterAdapter.exitTestSuite");
            }
            TestElementReference cRef = this.testElementRefs.pop();
            while (cRef != null && !cRef.isSuite) {
                this.logUnexpectedTest(cRef.id, cRef);
                cRef = this.testElementRefs.pop();
            }
        }

        public void enterTestCase(String name) {
            if (CDTTestRunnerClient.this.fDebug) {
                System.out.println("TestModelUpdaterAdapter.enterTestCase: name = " + name);
            }
            TestElementReference pRef = this.testElementRefs.isEmpty() ? null : this.testElementRefs.peek();
            String parentId = String.valueOf("-1");
            if (pRef != null) {
                parentId = pRef.isSuite ? pRef.id : pRef.parentId;
            }
            TestElementReference cRef = new TestElementReference(parentId, String.valueOf(this.fTestId++), name, false);
            this.testElementRefs.push(cRef);
            this.fCurrentTestCase = cRef.id;
            this.fFailedTrace.setLength(0);
            ITestCaseElement test = CDTTestRunnerClient.this.fTestRunSession.newTestCase(cRef.id, cRef.name, this.getTestSuite(cRef.parentId), cRef.name, null);
            CDTTestRunnerClient.this.fTestRunSession.notifyTestStarted((ITestElement)test);
        }

        private ITestSuiteElement getTestSuite(String parentId) {
            ITestElement parent = CDTTestRunnerClient.this.fTestRunSession.getTestElement(parentId);
            if (parent instanceof ITestSuiteElement) {
                return (ITestSuiteElement)parent;
            }
            return null;
        }

        public void setTestStatus(ITestItem.Status status) {
            if (CDTTestRunnerClient.this.fDebug) {
                System.out.println("TestModelUpdaterAdapter.setTestStatus: status = " + status.toString());
            }
            if (status.isError()) {
                TestElementReference cRef;
                TestElementReference testElementReference = cRef = this.testElementRefs.isEmpty() ? null : this.testElementRefs.peek();
                if (cRef != null) {
                    ITestElement test = CDTTestRunnerClient.this.fTestRunSession.getTestElement(cRef.id);
                    if (test != null) {
                        CDTTestRunnerClient.this.fTestRunSession.notifyTestFailed(test, status == ITestItem.Status.Aborted ? ITestElement.Result.ERROR : ITestElement.Result.FAILURE, false, new ITestElement.FailureTrace(this.fFailedTrace.toString(), "", ""));
                    }
                } else {
                    this.logUnexpectedTest(this.fCurrentTestCase, null);
                }
            }
        }

        public void setTestingTime(int testingTime) {
            TestElementReference cRef;
            if (CDTTestRunnerClient.this.fDebug) {
                System.out.println("TestModelUpdaterAdapter.setTestingTime: testingTime = " + testingTime);
            }
            TestElementReference testElementReference = cRef = this.testElementRefs.isEmpty() ? null : this.testElementRefs.peek();
            if (cRef != null) {
                cRef.testingTime = testingTime;
            } else {
                this.logUnexpectedTest(this.fCurrentTestCase, null);
            }
        }

        public void exitTestCase() {
            TestElementReference cRef;
            if (CDTTestRunnerClient.this.fDebug) {
                System.out.println("TestModelUpdaterAdapter.exitTestCase");
            }
            TestElementReference testElementReference = cRef = this.testElementRefs.isEmpty() ? null : this.testElementRefs.peek();
            if (cRef != null && !cRef.isSuite) {
                this.testElementRefs.pop();
                ITestElement testElement = CDTTestRunnerClient.this.fTestRunSession.getTestElement(cRef.id);
                CDTTestRunnerClient.this.fTestRunSession.notifyTestEnded(testElement, false);
            } else {
                this.logUnexpectedTest(cRef == null ? "null" : cRef.id, cRef);
            }
        }

        public void addTestMessage(String file, int line, ITestMessage.Level level, String text) {
            if (CDTTestRunnerClient.this.fDebug) {
                System.out.println("TestModelUpdaterAdapter.addTestMessage: file = " + file + ", line = " + line + ", level = " + level.toString() + ", text = " + text);
            }
            this.fFailedTrace.append(level.toString()).append(": ").append(text).append("\r\n").append(" at ").append(file).append(':').append(line).append("\r\n");
        }

        public ITestSuite currentTestSuite() {
            ITestElement testElement;
            if (CDTTestRunnerClient.this.fDebug) {
                System.out.println("TestModelUpdaterAdapter.currentTestSuite");
            }
            if ((testElement = CDTTestRunnerClient.this.fTestRunSession.getTestElement(this.fCurrentTestSuite)) instanceof ITestSuiteElement) {
                return CDTTestRunnerClient.this.convertFromTestSuiteElement((ITestSuiteElement)testElement);
            }
            return CDTTestRunnerClient.this.convertFromTestSuiteElement(testElement.getParent());
        }

        public ITestCase currentTestCase() {
            ITestElement testElement;
            if (CDTTestRunnerClient.this.fDebug) {
                System.out.println("TestModelUpdaterAdapter.currentTestCase");
            }
            if ((testElement = CDTTestRunnerClient.this.fTestRunSession.getTestElement(this.fCurrentTestCase)) instanceof ITestCaseElement) {
                return CDTTestRunnerClient.this.convertFromTestCaseElement((ITestCaseElement)testElement);
            }
            return null;
        }

        private void logUnexpectedTest(String testId, TestElementReference testElement) {
            CDTUnitTestPlugin.log(new Exception("Unexpected TestElement type for testId '" + testId + "': " + testElement));
        }

        class TestElementReference {
            String parentId;
            String id;
            String name;
            boolean isSuite;
            private long startTime;
            private long testingTime;

            public TestElementReference(String parentId, String id, String name, boolean isSuite) {
                this.parentId = parentId;
                this.id = id;
                this.name = name;
                this.isSuite = isSuite;
                this.startTime = System.currentTimeMillis();
            }

            public String toString() {
                return "TestElementReference: " + "parentId = " + this.parentId + NL + "id = " + this.id + NL + "name = " + this.name + NL + "isSuite = " + this.isSuite + NL + "startTime = " + this.startTime + NL + "testingTime = " + this.testingTime + NL;
            }
        }
    }
}

