/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.commit;

import java.text.MessageFormat;
import java.util.LinkedList;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.internal.common.branch.CDOBranchPointImpl;

public class CDOChangeSetSegment
implements CDOBranchPoint {
    private CDOBranchPoint branchPoint;
    private long endTime;

    public CDOChangeSetSegment(CDOBranch branch, long timeStamp, long endTime) {
        this.branchPoint = new CDOBranchPointImpl(branch, timeStamp);
        this.endTime = endTime;
    }

    @Override
    public CDOBranch getBranch() {
        return this.branchPoint.getBranch();
    }

    @Override
    public long getTimeStamp() {
        return this.branchPoint.getTimeStamp();
    }

    public long getEndTime() {
        return this.endTime;
    }

    public CDOBranchPoint getEndPoint() {
        return this.getBranch().getPoint(this.endTime);
    }

    public boolean isOpenEnded() {
        return this.endTime == 0L;
    }

    public boolean contains(CDOBranchPoint branchPoint) {
        CDOBranch branch = branchPoint.getBranch();
        if (branch != this.getBranch()) {
            return false;
        }
        long timeStamp = branchPoint.getTimeStamp();
        if (timeStamp < this.getTimeStamp()) {
            return false;
        }
        return this.isOpenEnded() || timeStamp <= this.endTime;
    }

    public String toString() {
        return MessageFormat.format("Segment[{0}, {1}, {2}]", this.getBranch(), this.getTimeStamp(), this.endTime);
    }

    public static void handleSegments(CDOBranchPoint endPoint, Handler handler) {
        long creationTime = endPoint.getBranch().getBranchManager().getMainBranch().getBase().getTimeStamp();
        CDOChangeSetSegment.handleSegments(creationTime, endPoint, handler);
    }

    public static void handleSegments(long startTime, CDOBranchPoint endPoint, Handler handler) {
        CDOBranch endBranch = endPoint.getBranch();
        while (true) {
            CDOBranchPoint base = endBranch.getBase();
            long timeStamp = base.getTimeStamp();
            long endTime = endPoint.getTimeStamp();
            if (timeStamp <= startTime) {
                handler.handleSegment(new CDOChangeSetSegment(endBranch, startTime, endTime));
                return;
            }
            if (!handler.handleSegment(new CDOChangeSetSegment(endBranch, timeStamp, endTime))) {
                return;
            }
            endPoint = base;
            endBranch = base.getBranch();
        }
    }

    public static void handleSegments(CDOBranchPoint startPoint, CDOBranchPoint endPoint, Handler handler) {
        CDOBranch startBranch = startPoint.getBranch();
        CDOBranch endBranch = endPoint.getBranch();
        while (startBranch != endBranch) {
            CDOBranchPoint base = endBranch.getBase();
            if (!handler.handleSegment(new CDOChangeSetSegment(endBranch, base.getTimeStamp(), endPoint.getTimeStamp()))) {
                return;
            }
            endPoint = base;
            endBranch = base.getBranch();
        }
        handler.handleSegment(new CDOChangeSetSegment(startBranch, startPoint.getTimeStamp(), endPoint.getTimeStamp()));
    }

    public static CDOChangeSetSegment[] createFrom(long startTime, CDOBranchPoint endPoint) {
        final LinkedList result = new LinkedList();
        CDOChangeSetSegment.handleSegments(startTime, endPoint, new Handler(){

            @Override
            public boolean handleSegment(CDOChangeSetSegment segment) {
                result.addFirst(segment);
                return true;
            }
        });
        return result.toArray(new CDOChangeSetSegment[result.size()]);
    }

    public static CDOChangeSetSegment[] createFrom(CDOBranchPoint startPoint, CDOBranchPoint endPoint) {
        final LinkedList result = new LinkedList();
        CDOChangeSetSegment.handleSegments(startPoint, endPoint, new Handler(){

            @Override
            public boolean handleSegment(CDOChangeSetSegment segment) {
                result.addFirst(segment);
                return true;
            }
        });
        return result.toArray(new CDOChangeSetSegment[result.size()]);
    }

    public static boolean contains(CDOChangeSetSegment[] segments, CDOBranchPoint branchPoint) {
        CDOChangeSetSegment[] cDOChangeSetSegmentArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            CDOChangeSetSegment segment = cDOChangeSetSegmentArray[n2];
            if (segment.contains(branchPoint)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static interface Handler {
        public boolean handleSegment(CDOChangeSetSegment var1);
    }
}

