/*
 * generated by Xtext 2.17.0
 */
package org.eclipse.gef.dot.internal.language.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlLabel;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmllabelPackage;
import org.eclipse.gef.dot.internal.language.services.DotHtmlLabelGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class DotHtmlLabelSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotHtmlLabelGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == HtmllabelPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case HtmllabelPackage.HTML_ATTR:
				sequence_HtmlAttr(context, (HtmlAttr) semanticObject); 
				return; 
			case HtmllabelPackage.HTML_CONTENT:
				sequence_HtmlContent(context, (HtmlContent) semanticObject); 
				return; 
			case HtmllabelPackage.HTML_LABEL:
				sequence_HtmlLabel(context, (HtmlLabel) semanticObject); 
				return; 
			case HtmllabelPackage.HTML_TAG:
				sequence_HtmlTag(context, (HtmlTag) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     HtmlAttr returns HtmlAttr
	 *
	 * Constraint:
	 *     (name=ID value=ATTR_VALUE)
	 */
	protected void sequence_HtmlAttr(ISerializationContext context, HtmlAttr semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, HtmllabelPackage.Literals.HTML_ATTR__NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, HtmllabelPackage.Literals.HTML_ATTR__NAME));
			if (transientValues.isValueTransient(semanticObject, HtmllabelPackage.Literals.HTML_ATTR__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, HtmllabelPackage.Literals.HTML_ATTR__VALUE));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getHtmlAttrAccess().getNameIDTerminalRuleCall_0_0(), semanticObject.getName());
		feeder.accept(grammarAccess.getHtmlAttrAccess().getValueATTR_VALUETerminalRuleCall_4_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     HtmlContent returns HtmlContent
	 *
	 * Constraint:
	 *     (tag=HtmlTag | text=TEXT)
	 */
	protected void sequence_HtmlContent(ISerializationContext context, HtmlContent semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     HtmlLabel returns HtmlLabel
	 *
	 * Constraint:
	 *     parts+=HtmlContent+
	 */
	protected void sequence_HtmlLabel(ISerializationContext context, HtmlLabel semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     HtmlTag returns HtmlTag
	 *
	 * Constraint:
	 *     (name=ID attributes+=HtmlAttr* (selfClosing?=TAG_END_CLOSE | (children+=HtmlContent* closeName=ID)))
	 */
	protected void sequence_HtmlTag(ISerializationContext context, HtmlTag semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
}
