/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.validation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.dot.internal.language.htmllabel.DotHtmlLabelHelper;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlAttr;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlLabel;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmllabelPackage;
import org.eclipse.gef.dot.internal.language.validation.AbstractDotHtmlLabelValidator;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;

public class DotHtmlLabelValidator
extends AbstractDotHtmlLabelValidator {
    public static final String HTML_TAG_IS_NOT_PROPERLY_CLOSED = "html_tag_is_not_properly_closed";
    public static final String HTML_TAG_SELF_CLOSING_IS_NOT_ALLOWED = "html_tag_self_closing_is_not_allowed";
    public static final String HTML_TAG_INVALID_TAG_NAME = "html_tag_invalid_tag_name";
    public static final String HTML_ATTRIBUTE_INVALID_ATTRIBUTE_NAME = "html_attribute_invalid_attribute_name";
    public static final String HTML_ATTRIBUTE_INVALID_ATTRIBUTE_VALUE = "html_attribute_invalid_attribute_value";
    public static final String HTML_ATTRIBUTE_DUPLICATE_ATTRIBUTE_NAME = "html_attribute_duplicate_attribute_name";

    @Check
    public void checkHtmlLabelPartsAreValidSiblings(HtmlLabel label) {
        this.checkSiblingsAreValid((List<HtmlContent>)label.getParts());
    }

    @Check
    public void checkHtmlTagChildrenAreValidSiblings(HtmlTag tag) {
        this.checkSiblingsAreValid((List<HtmlContent>)tag.getChildren());
    }

    @Check
    public void checkTagIsClosed(HtmlTag tag) {
        if (!tag.isSelfClosing() && !tag.getName().toUpperCase().equals(tag.getCloseName().toUpperCase())) {
            this.reportRangeBasedError(HTML_TAG_IS_NOT_PROPERLY_CLOSED, "Tag '<" + tag.getName() + ">' is not closed (expected '</" + tag.getName() + ">' but got '</" + tag.getCloseName() + ">').", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__CLOSE_NAME, new String[]{HTML_TAG_IS_NOT_PROPERLY_CLOSED, EcoreUtil.getURI((EObject)tag).toString(), tag.getName(), tag.getCloseName()});
        }
    }

    @Check
    public void checkSelfClosingTagIsAllowed(HtmlTag tag) {
        String tagNameUpperCase = tag.getName().toUpperCase();
        if (tag.isSelfClosing() && DotHtmlLabelHelper.getNonSelfClosingTags().contains(tagNameUpperCase)) {
            this.reportRangeBasedError(HTML_TAG_SELF_CLOSING_IS_NOT_ALLOWED, "Tag '<" + tag.getName() + "/>' cannot be self closing.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
        }
    }

    @Check
    public void checkStringLiteralIsAllowed(HtmlTag tag) {
        Object[] stringLiteralIsNotAllowed = new String[]{"BR", "HR", "IMG", "TABLE", "TR", "VR"};
        String tagNameUpperCase = tag.getName().toUpperCase();
        if (Arrays.binarySearch(stringLiteralIsNotAllowed, tagNameUpperCase) >= 0) {
            for (HtmlContent child : tag.getChildren()) {
                String text = child.getText();
                if (text == null || text.trim().isEmpty()) continue;
                this.reportRangeBasedError(null, "Tag '<" + tag.getName() + ">' cannot contain a string literal.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
            }
        }
    }

    @Check
    public void checkTagNameIsValid(HtmlTag tag) {
        String tagName = tag.getName();
        if (!DotHtmlLabelHelper.getAllTags().contains(tagName.toUpperCase())) {
            this.reportRangeBasedError(HTML_TAG_INVALID_TAG_NAME, "Tag '<" + tagName + ">' is not supported.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
        } else {
            EObject container = tag.eContainer().eContainer();
            HtmlTag parent = null;
            if (container instanceof HtmlTag) {
                parent = (HtmlTag)container;
            }
            String parentName = parent == null ? DotHtmlLabelHelper.getRootTagKey() : parent.getName();
            Map<String, Set<String>> validTags = DotHtmlLabelHelper.getValidTags();
            if (!validTags.containsKey(parentName.toUpperCase()) || !validTags.get(parentName.toUpperCase()).contains(tagName.toUpperCase())) {
                this.reportRangeBasedError(HTML_TAG_INVALID_TAG_NAME, "Tag '<" + tagName + ">' is not allowed inside '<" + parentName + ">', but only inside '<" + String.join((CharSequence)">', '<", (Iterable<? extends CharSequence>)DotHtmlLabelHelper.getAllowedParents().get(tagName.toUpperCase())) + ">'.", tag, (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
            }
        }
    }

    @Check
    public void checkAttributeNameIsValid(HtmlAttr attr) {
        String attrName = attr.getName();
        EObject container = attr.eContainer();
        if (container instanceof HtmlTag) {
            HtmlTag tag = (HtmlTag)container;
            String tagName = tag.getName();
            Map<String, Set<String>> validAttributes = DotHtmlLabelHelper.getValidAttributes();
            if (!validAttributes.containsKey(tagName.toUpperCase()) || !validAttributes.get(tagName.toUpperCase()).contains(attrName.toUpperCase())) {
                this.reportRangeBasedError(HTML_ATTRIBUTE_INVALID_ATTRIBUTE_NAME, "Attribute '" + attrName + "' is not allowed inside '<" + tagName + ">'.", attr, (EStructuralFeature)HtmllabelPackage.Literals.HTML_ATTR__NAME, new String[]{HTML_ATTRIBUTE_INVALID_ATTRIBUTE_NAME, EcoreUtil.getURI((EObject)attr).toString(), tagName, attrName});
            }
        }
    }

    @Check
    public void checkAttributeValueIsValid(HtmlAttr attr) {
        HtmlTag tag;
        String htmlTagName;
        String message;
        String htmlAttributeName = attr.getName();
        String htmlAttributeValue = this.removeQuotes(attr.getValue());
        EObject container = attr.eContainer();
        if (container instanceof HtmlTag && (message = this.getAttributeValueErrorMessage(htmlTagName = (tag = (HtmlTag)container).getName(), htmlAttributeName, htmlAttributeValue)) != null) {
            this.reportRangeBasedError(HTML_ATTRIBUTE_INVALID_ATTRIBUTE_VALUE, "The value '" + htmlAttributeValue + "' is not a correct " + htmlAttributeName + ": " + message, attr, (EStructuralFeature)HtmllabelPackage.Literals.HTML_ATTR__VALUE);
        }
    }

    @Check
    public void checkAttributeNameIsNotDuplicate(HtmlTag tag) {
        HashMap<String, HtmlAttr> definedAttributes = new HashMap<String, HtmlAttr>();
        HashSet<HtmlAttr> duplicateAttrSet = new HashSet<HtmlAttr>();
        for (HtmlAttr attr : tag.getAttributes()) {
            String attrNameLower = attr.getName().toLowerCase(Locale.ENGLISH);
            if (definedAttributes.putIfAbsent(attrNameLower, attr) == null) continue;
            duplicateAttrSet.add(attr);
            duplicateAttrSet.add((HtmlAttr)definedAttributes.get(attrNameLower));
        }
        for (HtmlAttr attr : duplicateAttrSet) {
            this.reportRangeBasedError(HTML_ATTRIBUTE_DUPLICATE_ATTRIBUTE_NAME, "The attribute '" + attr.getName() + "' is defined more than once.", attr, (EStructuralFeature)HtmllabelPackage.Literals.HTML_ATTR__NAME);
        }
    }

    private void checkSiblingsAreValid(List<HtmlContent> siblings) {
        if (!DotHtmlLabelHelper.isValidSiblings(siblings)) {
            for (HtmlContent htmlText : siblings) {
                if (htmlText.getTag() != null) {
                    this.reportRangeBasedError(null, "Invalid siblings.", htmlText.getTag(), (EStructuralFeature)HtmllabelPackage.Literals.HTML_TAG__NAME);
                    continue;
                }
                this.reportRangeBasedError(null, "Invalid siblings.", htmlText, (EStructuralFeature)HtmllabelPackage.Literals.HTML_CONTENT__TEXT);
            }
        }
    }

    private String removeQuotes(String value) {
        if (value.startsWith("\"") || value.startsWith("'")) {
            value = value.substring(1);
        }
        if (value.endsWith("\"") || value.endsWith("'")) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private String getAttributeValueErrorMessage(String htmlTagName, String htmlAttributeName, String htmlAttributeValue) {
        block96: {
            block94: {
                block92: {
                    block90: {
                        if (!"BR".equalsIgnoreCase(htmlTagName)) break block90;
                        switch (htmlAttributeName.toUpperCase()) {
                            case "ALIGN": {
                                return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "CENTER", "LEFT", "RIGHT");
                            }
                        }
                    }
                    if (!"IMG".equalsIgnoreCase(htmlTagName)) break block92;
                    switch (htmlAttributeName.toUpperCase()) {
                        case "SCALE": {
                            return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "FALSE", "TRUE", "WIDTH", "HEIGHT", "BOTH");
                        }
                    }
                }
                if (!"TABLE".equalsIgnoreCase(htmlTagName)) break block94;
                switch (htmlAttributeName.toUpperCase()) {
                    case "ALIGN": {
                        return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "CENTER", "LEFT", "RIGHT");
                    }
                    case "BORDER": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 255);
                    }
                    case "CELLBORDER": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 127);
                    }
                    case "CELLPADDING": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 255);
                    }
                    case "CELLSPACING": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 127);
                    }
                    case "ROWS": 
                    case "COLUMNS": {
                        return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "*");
                    }
                    case "FIXEDSIZE": {
                        return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "FALSE", "TRUE");
                    }
                    case "WIDTH": 
                    case "HEIGHT": {
                        return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 65535);
                    }
                    case "SIDES": {
                        return this.getSidesAttributeValueErrorMessage(htmlAttributeValue);
                    }
                    case "VALIGN": {
                        return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "MIDDLE", "BOTTOM", "TOP");
                    }
                }
            }
            if (!"TD".equalsIgnoreCase(htmlTagName)) break block96;
            switch (htmlAttributeName.toUpperCase()) {
                case "ALIGN": {
                    return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "CENTER", "LEFT", "RIGHT", "TEXT");
                }
                case "BALIGN": {
                    return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "CENTER", "LEFT", "RIGHT");
                }
                case "BORDER": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 255);
                }
                case "CELLPADDING": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 255);
                }
                case "CELLSPACING": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 127);
                }
                case "COLSPAN": 
                case "ROWSPAN": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 1, 65535);
                }
                case "FIXEDSIZE": {
                    return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "FALSE", "TRUE");
                }
                case "WIDTH": 
                case "HEIGHT": {
                    return this.getNumberAttributeValueErrorMessage(htmlAttributeValue, 0, 65535);
                }
                case "SIDES": {
                    return this.getSidesAttributeValueErrorMessage(htmlAttributeValue);
                }
                case "VALIGN": {
                    return this.getEnumAttributeValueErrorMessage(htmlAttributeValue, "MIDDLE", "BOTTOM", "TOP");
                }
            }
        }
        return null;
    }

    private String getEnumAttributeValueErrorMessage(String currentValue, String ... allowedValues) {
        List<String> allowedValuesList = Arrays.asList(allowedValues);
        if (allowedValuesList.contains(currentValue.toUpperCase())) {
            return null;
        }
        String formattedAllowedValues = allowedValuesList.stream().map(e -> "'" + e + "'").collect(Collectors.joining(", "));
        return "Value has to be " + (allowedValues.length > 1 ? "one of " : "") + formattedAllowedValues + ".";
    }

    private String getNumberAttributeValueErrorMessage(String currentValue, int minimum, int maximum) {
        boolean isValid = true;
        try {
            int currentValueParsed = Integer.parseInt(currentValue);
            isValid = minimum <= currentValueParsed && currentValueParsed <= maximum;
        }
        catch (NumberFormatException e) {
            isValid = false;
        }
        if (isValid) {
            return null;
        }
        return String.format("Value has to be between %1$d and %2$d.", minimum, maximum);
    }

    private String getSidesAttributeValueErrorMessage(String htmlAttributeValue) {
        if (htmlAttributeValue.isEmpty()) {
            return "Value has to contain only the 'L', 'T', 'R', 'B' characters.";
        }
        int i = 0;
        while (i < htmlAttributeValue.length()) {
            String subString = Character.toString(htmlAttributeValue.charAt(i)).toUpperCase();
            if (!"LTRB".contains(subString)) {
                return "Value has to contain only the 'L', 'T', 'R', 'B' characters.";
            }
            ++i;
        }
        return null;
    }

    private void reportRangeBasedError(String issueCode, String message, EObject object, EStructuralFeature feature) {
        this.reportRangeBasedError(issueCode, message, object, feature, null);
    }

    private void reportRangeBasedError(String issueCode, String message, EObject object, EStructuralFeature feature, String[] issueData) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)object, (EStructuralFeature)feature);
        if (nodes.size() != 1) {
            throw new IllegalStateException("Exact 1 node is expected for the feature, but got " + nodes.size() + " node(s).");
        }
        INode node = (INode)nodes.get(0);
        int offset = node.getTotalOffset();
        int length = node.getLength();
        this.getMessageAcceptor().acceptError(message, object, offset, length, issueCode, issueData);
    }
}

