/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.eclipse.jgit.pgm.internal.CLIText;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.kohsuke.args4j.Option;

@Command(common=true, usage="usage_getAndSetOptions")
class Config
extends TextBuiltin {
    @Option(name="--system", usage="usage_configSystem")
    private boolean system;
    @Option(name="--global", usage="usage_configGlobal")
    private boolean global;
    @Option(name="--local", usage="usage_configLocal")
    private boolean local;
    @Option(name="--list", aliases={"-l"}, usage="usage_configList")
    private boolean list;
    @Option(name="--file", aliases={"-f"}, metaVar="metaVar_file", usage="usage_configFile")
    private File configFile;

    Config() {
    }

    @Override
    protected void run() {
        if (!this.list) {
            throw Config.die(CLIText.get().configOnlyListOptionSupported);
        }
        try {
            this.list();
        }
        catch (IOException | ConfigInvalidException e) {
            throw Config.die(e.getMessage(), e);
        }
    }

    private void list() throws IOException, ConfigInvalidException {
        FS fs = this.getRepository().getFS();
        if (this.configFile != null) {
            this.list((StoredConfig)new FileBasedConfig(this.configFile, fs));
            return;
        }
        if (this.system || this.isListAll() && StringUtils.isEmptyOrNull((String)SystemReader.getInstance().getenv("GIT_CONFIG_NOSYSTEM"))) {
            this.list((StoredConfig)SystemReader.getInstance().openSystemConfig(null, fs));
        }
        if (this.global || this.isListAll()) {
            this.list((StoredConfig)SystemReader.getInstance().openUserConfig(null, fs));
        }
        if (this.local || this.isListAll()) {
            this.list((StoredConfig)new FileBasedConfig(fs.resolve(this.getRepository().getDirectory(), "config"), fs));
        }
    }

    private boolean isListAll() {
        return !this.system && !this.global && !this.local && this.configFile == null;
    }

    private void list(StoredConfig config) throws IOException, ConfigInvalidException {
        config.load();
        Set sections = config.getSections();
        for (String section : sections) {
            Set names = config.getNames(section);
            for (String name : names) {
                String[] stringArray = config.getStringList(section, null, name);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    this.outw.println(String.valueOf(section) + "." + name + "=" + value);
                    ++n2;
                }
            }
            if (!names.isEmpty()) continue;
            for (String subsection : config.getSubsections(section)) {
                names = config.getNames(section, subsection);
                for (String name : names) {
                    String[] stringArray = config.getStringList(section, subsection, name);
                    int n = stringArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String value = stringArray[n3];
                        this.outw.println(String.valueOf(section) + "." + subsection + "." + name + "=" + value);
                        ++n3;
                    }
                }
            }
        }
    }
}

