/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ClasspathUtil {
    public static final String LEGACY_METADATA_FILE_NAME = ".settings/org.eclipse.jst.common.project.facet.core.prefs";
    public static final Object SYSTEM_OWNER = new Object();
    private static final String OWNER_PROJECT_FACETS_ATTR = "owner.project.facets";

    private ClasspathUtil() {
    }

    public static List<IClasspathEntry> getProjectClasspath(IJavaProject project) throws CoreException {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            result.add(cpe);
            ++n2;
        }
        return result;
    }

    public static void setProjectClasspath(IJavaProject project, List<IClasspathEntry> cp) throws CoreException {
        ClasspathUtil.validateClasspathEdit(project);
        project.setRawClasspath(cp.toArray(new IClasspathEntry[cp.size()]), null);
    }

    public static void addClasspathEntry(IProject project, IClasspathEntry cpe) throws CoreException {
        ClasspathUtil.addClasspathEntry(JavaCore.create((IProject)project), cpe);
    }

    public static void addClasspathEntry(IJavaProject project, IClasspathEntry cpe) throws CoreException {
        ClasspathUtil.validateClasspathEdit(project);
        IClasspathEntry[] cpOld = project.getRawClasspath();
        IClasspathEntry[] cpNew = new IClasspathEntry[cpOld.length + 1];
        System.arraycopy(cpOld, 0, cpNew, 0, cpOld.length);
        cpNew[cpOld.length] = cpe;
        project.setRawClasspath(cpNew, null);
    }

    public static List<IClasspathEntry> getClasspathEntries(IProject project, IProjectFacet facet) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        return ClasspathUtil.getClasspathEntries(jproj, facet);
    }

    public static List<IClasspathEntry> getClasspathEntries(IJavaProject project, IProjectFacet facet) throws CoreException {
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = project.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry cpe = iClasspathEntryArray[n2];
            Set<Object> owners = ClasspathUtil.getOwners(project, cpe);
            if (owners.contains(facet)) {
                result.add(cpe);
            }
            ++n2;
        }
        return result;
    }

    public static void addClasspathEntries(IProject project, IProjectFacet facet, List<IClasspathEntry> cpentries) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        ClasspathUtil.addClasspathEntries(jproj, facet, cpentries);
    }

    public static void addClasspathEntries(IJavaProject project, IProjectFacet facet, List<IClasspathEntry> cpentries) throws CoreException {
        ClasspathUtil.validateClasspathEdit(project);
        ClasspathUtil.convertLegacyMetadata(project);
        List<IClasspathEntry> cp = ClasspathUtil.getProjectClasspath(project);
        for (IClasspathEntry cpe : cpentries) {
            IClasspathEntry annotatedEntry;
            IClasspathEntry existingClasspathEntry = null;
            for (IClasspathEntry x : cp) {
                if (!x.getPath().equals((Object)cpe.getPath())) continue;
                existingClasspathEntry = x;
                break;
            }
            Set<Object> owners = ClasspathUtil.getOwners(project, existingClasspathEntry);
            owners.add(facet);
            if (existingClasspathEntry != null) {
                annotatedEntry = ClasspathUtil.setOwners(existingClasspathEntry, owners);
                int existingIndex = cp.indexOf(existingClasspathEntry);
                cp.set(existingIndex, annotatedEntry);
                continue;
            }
            annotatedEntry = ClasspathUtil.setOwners(cpe, owners);
            cp.add(annotatedEntry);
        }
        ClasspathUtil.setProjectClasspath(project, cp);
    }

    public static void removeClasspathEntries(IProject project, IProjectFacet facet) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        ClasspathUtil.removeClasspathEntries(jproj, facet);
    }

    public static void removeClasspathEntries(IJavaProject project, IProjectFacet facet) throws CoreException {
        ClasspathUtil.validateClasspathEdit(project);
        ClasspathUtil.convertLegacyMetadata(project);
        List<IClasspathEntry> cp = ClasspathUtil.getProjectClasspath(project);
        boolean cpchanged = false;
        ListIterator<IClasspathEntry> itr = cp.listIterator();
        while (itr.hasNext()) {
            IClasspathEntry cpe = itr.next();
            Set<Object> owners = ClasspathUtil.getOwners(project, cpe);
            if (!owners.remove(facet)) continue;
            if (owners.size() == 0) {
                itr.remove();
            } else {
                itr.set(ClasspathUtil.setOwners(cpe, owners));
            }
            cpchanged = true;
        }
        if (cpchanged) {
            ClasspathUtil.setProjectClasspath(project, cp);
        }
    }

    public static void removeClasspathEntries(IProject project, IProjectFacet facet, List<IClasspathEntry> cpentries) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)project);
        ClasspathUtil.removeClasspathEntries(jproj, facet, cpentries);
    }

    public static void removeClasspathEntries(IJavaProject project, IProjectFacet facet, List<IClasspathEntry> cpentries) throws CoreException {
        ClasspathUtil.validateClasspathEdit(project);
        ClasspathUtil.convertLegacyMetadata(project);
        List<IClasspathEntry> cp = ClasspathUtil.getProjectClasspath(project);
        boolean cpchanged = false;
        ListIterator<IClasspathEntry> itr = cp.listIterator();
        while (itr.hasNext()) {
            Set<Object> owners;
            IClasspathEntry cpe = itr.next();
            if (!cpentries.contains(cpe) || !(owners = ClasspathUtil.getOwners(project, cpe)).remove(facet)) continue;
            if (owners.size() == 0) {
                itr.remove();
            } else {
                itr.set(ClasspathUtil.setOwners(cpe, owners));
            }
            cpchanged = true;
        }
        if (cpchanged) {
            ClasspathUtil.setProjectClasspath(project, cp);
        }
    }

    private static Set<Object> getOwners(IJavaProject project, IClasspathEntry cpe) throws CoreException {
        HashSet<Object> owners = new HashSet<Object>();
        if (cpe != null) {
            IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
            int n = iClasspathAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attr = iClasspathAttributeArray[n2];
                if (attr.getName().equals(OWNER_PROJECT_FACETS_ATTR)) {
                    owners.addAll(ClasspathUtil.decodeOwnersString(attr.getValue()));
                    break;
                }
                ++n2;
            }
            owners.addAll(ClasspathUtil.getOwnersFromLegacyMetadata(project, cpe));
            if (owners.isEmpty()) {
                owners.add(SYSTEM_OWNER);
            }
        }
        return owners;
    }

    private static Set<Object> getOwnersFromLegacyMetadata(IJavaProject project, IClasspathEntry cpe) throws CoreException {
        IProject pj = project.getProject();
        IFile legacyMetadataFile = pj.getFile(LEGACY_METADATA_FILE_NAME);
        if (legacyMetadataFile.exists()) {
            String[] keys;
            ProjectScope scope = new ProjectScope(pj);
            IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.jst.common.project.facet.core");
            Preferences root = pluginRoot.node("classpath.helper");
            try {
                keys = root.childrenNames();
            }
            catch (BackingStoreException e) {
                throw new CoreException(FacetCorePlugin.createErrorStatus(e.getMessage(), (Exception)((Object)e)));
            }
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                Preferences node = root.node(key);
                String owners = node.get("owners", null);
                if (owners != null) {
                    Path path = new Path(key.replaceAll("::", "/"));
                    if (cpe.getPath().equals((Object)path)) {
                        return ClasspathUtil.decodeOwnersString(owners);
                    }
                }
                ++n2;
            }
        }
        return Collections.emptySet();
    }

    private static IClasspathEntry setOwners(IClasspathEntry cpe, Set<Object> owners) {
        if (owners.size() == 1 && owners.iterator().next() == SYSTEM_OWNER) {
            owners.clear();
        }
        String ownersString = owners.size() == 0 ? null : ClasspathUtil.encodeOwnersString(owners);
        return ClasspathUtil.setOwners(cpe, ownersString);
    }

    private static IClasspathEntry setOwners(IClasspathEntry cpe, String owners) {
        ArrayList<IClasspathAttribute> attrs = new ArrayList<IClasspathAttribute>();
        IClasspathAttribute[] iClasspathAttributeArray = cpe.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attr = iClasspathAttributeArray[n2];
            if (!attr.getName().equals(OWNER_PROJECT_FACETS_ATTR)) {
                attrs.add(attr);
            }
            ++n2;
        }
        if (owners != null) {
            attrs.add(JavaCore.newClasspathAttribute((String)OWNER_PROJECT_FACETS_ATTR, (String)owners));
        }
        return new ClasspathEntry(cpe.getContentKind(), cpe.getEntryKind(), cpe.getPath(), cpe.getInclusionPatterns(), cpe.getExclusionPatterns(), cpe.getSourceAttachmentPath(), cpe.getSourceAttachmentRootPath(), cpe.getOutputLocation(), cpe.isExported(), cpe.getAccessRules(), cpe.combineAccessRules(), attrs.toArray(new IClasspathAttribute[attrs.size()]));
    }

    private static String encodeOwnersString(Set<Object> owners) {
        StringBuilder buf = new StringBuilder();
        for (Object owner : owners) {
            if (buf.length() > 0) {
                buf.append(';');
            }
            if (owner == SYSTEM_OWNER) {
                buf.append("#system#");
                continue;
            }
            IProjectFacet facet = (IProjectFacet)owner;
            buf.append(facet.getId());
        }
        return buf.toString();
    }

    private static Set<Object> decodeOwnersString(String str) {
        HashSet<Object> owners = new HashSet<Object>();
        String[] split = str.split(";");
        int j = 0;
        while (j < split.length) {
            String segment = split[j];
            if (segment.equals("#system#")) {
                owners.add(SYSTEM_OWNER);
            } else {
                String facetId = segment;
                int colon = facetId.indexOf(58);
                if (colon != -1) {
                    facetId = facetId.substring(0, colon);
                }
                owners.add(ProjectFacetsManager.getProjectFacet((String)facetId));
            }
            ++j;
        }
        return owners;
    }

    private static void convertLegacyMetadata(IJavaProject project) throws CoreException {
        IProject pj = project.getProject();
        IFile legacyMetadataFile = pj.getFile(LEGACY_METADATA_FILE_NAME);
        if (legacyMetadataFile.exists()) {
            Object owners;
            String[] keys;
            ProjectScope scope = new ProjectScope(pj);
            IEclipsePreferences pluginRoot = scope.getNode("org.eclipse.jst.common.project.facet.core");
            Preferences root = pluginRoot.node("classpath.helper");
            HashMap<Path, String> metadata = new HashMap<Path, String>();
            try {
                keys = root.childrenNames();
            }
            catch (BackingStoreException e) {
                throw new CoreException(FacetCorePlugin.createErrorStatus(e.getMessage(), (Exception)((Object)e)));
            }
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                Preferences node = root.node(key);
                owners = node.get("owners", null);
                if (owners != null) {
                    metadata.put(new Path(key.replaceAll("::", "/")), (String)owners);
                }
                ++n2;
            }
            if (!metadata.isEmpty()) {
                List<IClasspathEntry> cp = ClasspathUtil.getProjectClasspath(project);
                boolean cpchanged = false;
                ListIterator<IClasspathEntry> itr = cp.listIterator();
                while (itr.hasNext()) {
                    IClasspathEntry cpe = itr.next();
                    String ownersString = (String)metadata.get(cpe.getPath());
                    if (ownersString == null) continue;
                    owners = ClasspathUtil.decodeOwnersString(ownersString);
                    itr.set(ClasspathUtil.setOwners(cpe, ClasspathUtil.encodeOwnersString((Set<Object>)owners)));
                    cpchanged = true;
                }
                if (cpchanged) {
                    ClasspathUtil.setProjectClasspath(project, cp);
                }
            }
            legacyMetadataFile.delete(true, null);
        }
    }

    private static void validateClasspathEdit(IJavaProject jproject) throws CoreException {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = jproject.getProject();
        IStatus st = ws.validateEdit(new IFile[]{project.getFile(".classpath")}, IWorkspace.VALIDATE_PROMPT);
        if (st.getSeverity() == 4) {
            throw new CoreException(st);
        }
    }
}

