/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class JSPValidator
extends AbstractValidator
implements IValidatorJob {
    private static final String PLUGIN_ID_JSP_CORE = "org.eclipse.jst.jsp.core";
    private IContentType fJSPFContentType = null;
    static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        block11: {
            JSPFileVisitor visitor;
            block9: {
                block10: {
                    String[] uris = helper.getURIs();
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    if (uris.length <= 0) break block10;
                    IFile currentFile = null;
                    int i = 0;
                    while (i < uris.length && !reporter.isCancelled()) {
                        currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                        if (currentFile != null && currentFile.exists()) {
                            if (this.shouldValidate(currentFile) && this.fragmentCheck(currentFile)) {
                                LocalizedMessage message = new LocalizedMessage(4, uris[i]);
                                reporter.displaySubtask((IValidator)this, (IMessage)message);
                                this.validateFile(currentFile, reporter);
                            }
                            if (DEBUG) {
                                System.out.println("validating: [" + uris[i] + "]");
                            }
                        }
                        ++i;
                    }
                    break block11;
                }
                if (!(helper instanceof IWorkbenchContext)) break block11;
                IProject project = ((IWorkbenchContext)helper).getProject();
                visitor = new JSPFileVisitor(reporter);
                try {
                    project.accept((IResourceProxyVisitor)visitor, 2);
                }
                catch (CoreException e) {
                    if (!DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            IFile[] files = visitor.getFiles();
            int i = 0;
            while (i < files.length && !reporter.isCancelled()) {
                if (this.shouldValidate(files[i]) && this.fragmentCheck(files[i])) {
                    int percent = i * 100 / files.length + 1;
                    LocalizedMessage message = new LocalizedMessage(4, String.valueOf(percent) + "% " + files[i].getFullPath().toString());
                    reporter.displaySubtask((IValidator)this, (IMessage)message);
                    this.validateFile(files[i], reporter);
                }
                if (DEBUG) {
                    System.out.println("validating: [" + files[i] + "]");
                }
                ++i;
            }
        }
    }

    protected void validateFile(IFile f, IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        this.validateFile((IFile)resource, reporter);
        return result;
    }

    protected String getDirectiveName(ITextRegionCollection collection) {
        String name = "";
        ITextRegionList subRegions = collection.getRegions();
        int j = 0;
        while (j < subRegions.size()) {
            ITextRegion subRegion = subRegions.get(j);
            if (subRegion.getType() == "JSP_DIRECTIVE_NAME") {
                name = collection.getText(subRegion);
                break;
            }
            ++j;
        }
        return name;
    }

    protected ITextRegion getAttributeValueRegion(ITextRegionCollection sdr, String attrName) {
        ITextRegion valueRegion = null;
        ITextRegionList subRegions = sdr.getRegions();
        int i = 0;
        block0: while (i < subRegions.size()) {
            ITextRegion subRegion = subRegions.get(i);
            if (subRegion.getType() == "XML_TAG_ATTRIBUTE_NAME" && sdr.getText(subRegion).equals(attrName)) {
                int j = i;
                while (j < subRegions.size()) {
                    subRegion = subRegions.get(j);
                    if (subRegion.getType() == "XML_TAG_ATTRIBUTE_VALUE") {
                        valueRegion = subRegion;
                        break block0;
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        return valueRegion;
    }

    protected String getAttributeValue(ITextRegionCollection sdr, String attrName) {
        ITextRegion r = this.getAttributeValueRegion(sdr, attrName);
        if (r != null) {
            return sdr.getText(r).trim();
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isFragment(IFile file) {
        boolean isFragment = false;
        InputStream is = null;
        try {
            IContentDescription contentDescription = file.getContentDescription();
            if (contentDescription == null) {
                is = file.getContents();
                contentDescription = Platform.getContentTypeManager().getDescriptionFor(is, file.getName(), new QualifiedName[]{IContentDescription.CHARSET});
            }
            if (contentDescription != null) {
                String fileCtId = contentDescription.getContentType().getId();
                isFragment = fileCtId != null && ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT.equals(fileCtId);
            }
        }
        catch (IOException iOException) {
            if (is == null) return isFragment;
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        catch (CoreException coreException) {
            try {
                if (is == null) return isFragment;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                is.close();
                return isFragment;
            }
            catch (Exception exception) {}
            return isFragment;
        }
        if (is == null) return isFragment;
        try {
            is.close();
            return isFragment;
        }
        catch (Exception exception) {}
        return isFragment;
    }

    private boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    private boolean fragmentCheck(IFile file) {
        boolean shouldValidateFragments;
        boolean shouldValidate = true;
        if (this.getJSPFContentType().isAssociatedWith(file.getName()) && !(shouldValidateFragments = Boolean.valueOf(JSPFContentProperties.getProperty("validateFragments", (IResource)file, true)).booleanValue())) {
            boolean isFragment = this.isFragment(file);
            shouldValidate = !isFragment;
        }
        return shouldValidate;
    }

    private IContentType getJSPFContentType() {
        if (this.fJSPFContentType == null) {
            this.fJSPFContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT);
        }
        return this.fJSPFContentType;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        return null;
    }

    public IStatus validateInJob(IValidationContext helper, IReporter reporter) throws ValidationException {
        IStatus status = Status.OK_STATUS;
        try {
            this.validate(helper, reporter);
        }
        catch (ValidationException e) {
            Logger.logException(e);
            status = new Status(4, PLUGIN_ID_JSP_CORE, 4, e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }

    protected class JSPFileVisitor
    implements IResourceProxyVisitor {
        private List<IFile> fFiles = new ArrayList<IFile>();
        private IReporter fReporter = null;

        public JSPFileVisitor(IReporter reporter) {
            this.fReporter = reporter;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IFile file;
            if (this.fReporter.isCancelled() || proxy.isDerived()) {
                return false;
            }
            if (proxy.getType() == 1 && this.isJSPType(proxy.getName()) && (file = (IFile)proxy.requestResource()).exists()) {
                if (DEBUG) {
                    System.out.println("(+) JSPValidator adding file: " + file.getName());
                }
                this.fFiles.add(file);
                return false;
            }
            return true;
        }

        public final IFile[] getFiles() {
            return this.fFiles.toArray(new IFile[this.fFiles.size()]);
        }

        private boolean isJSPType(String fileName) {
            boolean valid = ContentTypeIdForJSP.indexOfJSPExtension(fileName) >= 0;
            return valid;
        }
    }

    protected class LocalizedMessage
    extends Message {
        private String _message;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this._message = null;
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }
    }
}

