/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.JavaMofBeanVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.JavaMofTypeVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofTypeVisitor;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.AttributeElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BeanModelElementsFactory;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeFactory;
import org.eclipse.jst.ws.internal.consumption.sampleapp.common.SamplePropertyDescriptor;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.ws.internal.datamodel.Element;

public class JavaMofAttributeVisitorAction
extends JavaMofBeanVisitorAction {
    public JavaMofAttributeVisitorAction(Element parentElement, String project, IEnvironment env) {
        super(parentElement, project, env);
    }

    public IStatus visit(Object propertyDecorator) {
        IStatus status = Status.OK_STATUS;
        SamplePropertyDescriptor pd = (SamplePropertyDescriptor)propertyDecorator;
        try {
            if (!(this.getReturnParam() && TypeFactory.isRecognizedReturnType(pd.getPropertyType()) || !TypeFactory.isUnSupportedType(pd.getPropertyType()))) {
                status = StatusUtils.warningStatus((String)(String.valueOf(ConsumptionMessages.MSG_WARN_JTS_UNSUPPORTED_TYPE) + pd.getPropertyType().getJavaName()));
                return status;
            }
            Method setMethod = pd.getWriteMethod();
            Method getMethod = pd.getReadMethod();
            if (setMethod != null && setMethod.isStatic()) {
                setMethod = null;
            }
            if (getMethod != null && getMethod.isStatic()) {
                getMethod = null;
            }
            if (pd.isfStatic()) {
                return status;
            }
            AttributeElement attributeElement = (AttributeElement)BeanModelElementsFactory.getBeanModelElement(propertyDecorator, this.fParentElement);
            if (attributeElement != null) {
                JavaParameter[] javaParameter;
                if (getMethod != null && (javaParameter = getMethod.listParametersWithoutReturn()).length > 0) {
                    if (this.getReturnParam()) {
                        return status;
                    }
                    status = StatusUtils.warningStatus((String)(String.valueOf(ConsumptionMessages.MSG_WARN_JTS_UNSUPPORTED_INDEXED_PROPERTIES) + getMethod.getName()));
                    return status;
                }
                if (setMethod != null) {
                    attributeElement.setSetterMethod(setMethod.getMethodElementSignature());
                }
                if (getMethod != null) {
                    attributeElement.setGetterMethod(getMethod.getMethodElementSignature());
                }
                JavaMofTypeVisitorAction typeVisitorAction = new JavaMofTypeVisitorAction((Element)attributeElement, this.clientProject, this.env_);
                typeVisitorAction.setStatusMonitor(this.getStatusMonitor());
                typeVisitorAction.setBeansCreated(this.getBeansCreated());
                typeVisitorAction.setReturnParam(this.getReturnParam());
                JavaMofTypeVisitor typeVisitor = new JavaMofTypeVisitor(this.env_);
                typeVisitor.setClientProject(this.getProject());
                status = typeVisitor.run(pd, typeVisitorAction);
            }
            return status;
        }
        catch (Exception e) {
            this.env_.getLog().log(2, 5054, (Object)this, "visit", (Throwable)e);
            status = StatusUtils.warningStatus((String)ConsumptionMessages.MSG_ERROR_JTS_JSP_GEN, (Throwable)e);
            try {
                this.env_.getStatusHandler().report(status);
            }
            catch (StatusException statusException) {
                status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_JTS_JSP_GEN);
            }
            return status;
        }
    }
}

