/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.provider;

import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.m2e.pde.MavenTargetLocation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class DependencyNodeLabelProvider
implements ILabelProvider {
    private Image inheritedImage;
    private Image jarImage;
    private Image errorImage;

    public String getText(Object element) {
        if (element instanceof DependencyNode) {
            DependencyNode node = (DependencyNode)element;
            Artifact artifact = node.getArtifact();
            MavenTargetLocation location = this.getTargetLocation(node);
            String baseLabel = String.valueOf(artifact.getGroupId()) + ":" + artifact.getArtifactId() + " (" + artifact.getVersion() + ")";
            if (location != null) {
                if (location.isIgnored(artifact)) {
                    return "(ignored) " + baseLabel;
                }
                if (location.isFailed(artifact)) {
                    return "(failed) " + baseLabel;
                }
            }
            return baseLabel;
        }
        return String.valueOf(element);
    }

    private MavenTargetLocation getTargetLocation(DependencyNode node) {
        Object object = node.getData().get("dependencynode.parent");
        if (object instanceof DependencyNode) {
            return this.getTargetLocation((DependencyNode)object);
        }
        if (object instanceof MavenTargetLocation) {
            return (MavenTargetLocation)object;
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof DependencyNode) {
            DependencyNode node = (DependencyNode)element;
            MavenTargetLocation location = this.getTargetLocation(node);
            Display current = Display.getCurrent();
            if (location != null) {
                if (location.isIgnored(node.getArtifact())) {
                    if (this.jarImage == null && current != null) {
                        this.jarImage = new Image((Device)current, DependencyNodeLabelProvider.class.getResourceAsStream("/icons/jar_obj.gif"));
                    }
                    return this.jarImage;
                }
                if (location.isFailed(node.getArtifact())) {
                    if (this.errorImage == null && current != null) {
                        this.errorImage = new Image((Device)current, DependencyNodeLabelProvider.class.getResourceAsStream("/icons/error_st_obj.gif"));
                    }
                    return this.errorImage;
                }
            }
            if (this.inheritedImage == null && current != null) {
                this.inheritedImage = new Image((Device)current, DependencyNodeLabelProvider.class.getResourceAsStream("/icons/show_inherited_dependencies.gif"));
            }
            return this.inheritedImage;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        if (this.inheritedImage != null) {
            this.inheritedImage.dispose();
        }
        if (this.jarImage != null) {
            this.jarImage.dispose();
        }
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

