/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.eclipse.m2e.pde.MavenTargetLocation;

public class BNDInstructions {
    private static final String BND_DEFAULT_PROPERTIES_PATH = "bnd-default.properties";
    public static final BNDInstructions EMPTY = new BNDInstructions("", null);
    private String key;
    private String instructions;

    public BNDInstructions(String key, String instructions) {
        this.key = key;
        this.instructions = instructions;
    }

    public String getKey() {
        return this.key;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public static BNDInstructions getDefaultInstructions() {
        InputStream input = MavenTargetLocation.class.getResourceAsStream(BND_DEFAULT_PROPERTIES_PATH);
        try {
            return new BNDInstructions("", IOUtils.toString((InputStream)input, (Charset)StandardCharsets.ISO_8859_1));
        }
        catch (IOException e) {
            throw new RuntimeException("load default properties failed", e);
        }
    }

    public Properties asProperties() {
        Reader reader = this.instructions == null || this.instructions.isBlank() ? new InputStreamReader(MavenTargetLocation.class.getResourceAsStream(BND_DEFAULT_PROPERTIES_PATH), StandardCharsets.ISO_8859_1) : new StringReader(this.instructions);
        Properties properties = new Properties();
        try {
            properties.load(reader);
        }
        catch (IOException e) {
            throw new RuntimeException("conversion to properties failed", e);
        }
        return properties;
    }
}

